/*
 * Decompiled with CFR 0.152.
 */
package mocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mocks.MockEmailNotificationService;
import mocks.MockStyleableEmailContentService;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.mail.Mailer;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.action.ActionItemContract;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.api.preferences.PreferencesService;
import org.kuali.rice.kew.mail.DailyEmailJob;
import org.kuali.rice.kew.mail.WeeklyEmailJob;
import org.kuali.rice.kew.mail.service.EmailContentService;
import org.kuali.rice.kew.mail.service.impl.CustomizableActionListEmailServiceImpl;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;

public class MockEmailNotificationServiceImpl
extends CustomizableActionListEmailServiceImpl
implements MockEmailNotificationService {
    private static final Logger LOG = Logger.getLogger(MockEmailNotificationServiceImpl.class);
    private static Map<String, List> immediateReminders = new HashMap<String, List>();
    private static Map<String, Integer> aggregateReminderCount = new HashMap<String, Integer>();
    private boolean sendDailyReminderCalled = false;
    private boolean sendWeeklyReminderCalled = false;
    private static final String DAILY_TRIGGER_NAME = "Daily Email Trigger";
    private static final String DAILY_JOB_NAME = "Daily Email";
    private static final String WEEKLY_TRIGGER_NAME = "Weekly Email Trigger";
    private static final String WEEKLY_JOB_NAME = "Weekly Email";
    private EmailContentService contentService;
    private String deploymentEnvironment;
    private Mailer mailer;

    @Override
    public void resetReminderCounts() {
        aggregateReminderCount.clear();
        immediateReminders.clear();
    }

    public void sendImmediateReminder(ActionItem actionItem, Boolean skipOnApprovals) {
        if (skipOnApprovals != null && skipOnApprovals.booleanValue() && actionItem.getActionRequestCd().equals("A")) {
            LOG.debug((Object)("As requested, skipping immediate reminder notification on action item approval for " + actionItem.getPrincipalId()));
            return;
        }
        ArrayList<ActionItem> actionItemsSentUser = immediateReminders.get(actionItem.getPrincipalId());
        Preferences preferences = this.getPreferencesService().getPreferences(actionItem.getPrincipalId());
        boolean shouldNotify = this.checkEmailNotificationPreferences((ActionItemContract)actionItem, preferences, "immediate");
        if (shouldNotify) {
            if (actionItemsSentUser == null) {
                actionItemsSentUser = new ArrayList<ActionItem>();
                immediateReminders.put(actionItem.getPrincipalId(), actionItemsSentUser);
            }
            actionItemsSentUser.add(actionItem);
        }
    }

    protected boolean sendActionListEmailNotification() {
        return true;
    }

    @Override
    public void sendDailyReminder() {
        LOG.info((Object)"Sending daily reminder");
        try {
            this.getEmailContentGenerator().generateWeeklyReminder(null, null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ArrayList<ActionItem> actionItems = new ArrayList<ActionItem>(1);
        actionItems.add(ActionItem.Builder.create((String)"ai1", (String)"ai2", (String)"ai3", (DateTime)new DateTime(), (String)"ai4", (String)"ai5", (String)"ai6", (String)"ai7", (String)"ai8").build());
        this.sendPeriodicReminder(null, actionItems, "daily");
        this.sendDailyReminderCalled = true;
    }

    @Override
    public boolean wasDailyReminderSent() {
        return this.sendDailyReminderCalled;
    }

    @Override
    public void sendWeeklyReminder() {
        LOG.info((Object)"Sending weekly reminder");
        try {
            this.getEmailContentGenerator().generateWeeklyReminder(null, null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ArrayList<ActionItem> actionItems = new ArrayList<ActionItem>(1);
        actionItems.add(ActionItem.Builder.create((String)"ai1", (String)"ai2", (String)"ai3", (DateTime)new DateTime(), (String)"ai4", (String)"ai5", (String)"ai6", (String)"ai7", (String)"ai8").build());
        this.sendPeriodicReminder(null, actionItems, "weekly");
        this.sendWeeklyReminderCalled = true;
    }

    @Override
    public boolean wasWeeklyReminderSent() {
        return this.sendWeeklyReminderCalled;
    }

    public void scheduleBatchEmailReminders() throws Exception {
        this.sendDailyReminderCalled = false;
        this.sendWeeklyReminderCalled = false;
        LOG.info((Object)"Scheduling Batch Email Reminders.");
        String emailBatchGroup = "Email Batch";
        String dailyCron = ConfigContext.getCurrentContextConfig().getProperty("dailyEmail.cronExpression");
        if (!StringUtils.isBlank((String)dailyCron)) {
            LOG.info((Object)("Scheduling Daily Email batch with cron expression: " + dailyCron));
            CronTrigger dailyTrigger = new CronTrigger(DAILY_TRIGGER_NAME, emailBatchGroup, dailyCron);
            JobDetail dailyJobDetail = new JobDetail(DAILY_JOB_NAME, emailBatchGroup, DailyEmailJob.class);
            dailyTrigger.setJobName(dailyJobDetail.getName());
            dailyTrigger.setJobGroup(dailyJobDetail.getGroup());
            this.sendDailyReminderCalled = true;
        } else {
            LOG.warn((Object)"No dailyEmail.cronExpression parameter was configured.  Daily Email batch was not scheduled!");
        }
        String weeklyCron = ConfigContext.getCurrentContextConfig().getProperty("weeklyEmail.cronExpression");
        if (!StringUtils.isBlank((String)weeklyCron)) {
            LOG.info((Object)("Scheduling Weekly Email batch with cron expression: " + weeklyCron));
            CronTrigger weeklyTrigger = new CronTrigger(WEEKLY_TRIGGER_NAME, emailBatchGroup, weeklyCron);
            JobDetail weeklyJobDetail = new JobDetail(WEEKLY_JOB_NAME, emailBatchGroup, WeeklyEmailJob.class);
            weeklyTrigger.setJobName(weeklyJobDetail.getName());
            weeklyTrigger.setJobGroup(weeklyJobDetail.getGroup());
            this.sendWeeklyReminderCalled = true;
        } else {
            LOG.warn((Object)"No weeklyEmail.cronExpression parameter was configured.  Weekly Email batch was not scheduled!");
        }
    }

    protected void sendPeriodicReminder(Person user, Collection<ActionItem> actionItems, String emailSetting) {
        if (!aggregateReminderCount.containsKey(emailSetting)) {
            aggregateReminderCount.put(emailSetting, actionItems.size());
        } else {
            aggregateReminderCount.put(emailSetting, aggregateReminderCount.get(emailSetting) + actionItems.size());
        }
    }

    @Override
    public Integer getTotalPeriodicRemindersSent(String emailReminderConstant) {
        Integer returnVal = aggregateReminderCount.get(emailReminderConstant);
        if (returnVal == null) {
            returnVal = 0;
        }
        return returnVal;
    }

    @Override
    public Integer getTotalPeriodicRemindersSent() {
        int total = 0;
        for (Map.Entry<String, Integer> mapEntry : aggregateReminderCount.entrySet()) {
            Integer value = mapEntry.getValue();
            total += value == null ? 0 : value;
        }
        return total;
    }

    @Override
    public boolean wasStyleServiceAccessed() {
        return this.getEmailContentGenerator().wasServiceAccessed();
    }

    private void resetStyleService() {
        this.getEmailContentGenerator().resetServiceAccessed();
    }

    @Override
    public int immediateReminderEmailsSent(String networkId, String documentId, String actionRequestCd) {
        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(networkId);
        List actionItemsSentUser = immediateReminders.get(principal.getPrincipalId());
        if (actionItemsSentUser == null) {
            LOG.info((Object)("There are no immediate reminders for Principal " + networkId + " and Document ID " + documentId));
            return 0;
        }
        LOG.info((Object)("There are " + actionItemsSentUser.size() + " immediate reminders for Principal " + networkId + " and Document ID " + documentId));
        int emailsSent = 0;
        for (ActionItem actionItem : actionItemsSentUser) {
            if (!actionItem.getDocumentId().equals(documentId) || !actionItem.getActionRequestCd().equals(actionRequestCd)) continue;
            ++emailsSent;
        }
        LOG.info((Object)(emailsSent + "No immediate e-mails were sent to Principal " + networkId + " and Document ID " + documentId));
        return emailsSent;
    }

    public void setEmailContentGenerator(EmailContentService contentService) {
        this.contentService = contentService;
    }

    protected MockStyleableEmailContentService getEmailContentGenerator() {
        return (MockStyleableEmailContentService)this.contentService;
    }

    public void setMailer(Mailer mailer) {
        this.mailer = mailer;
    }

    public void setDeploymentEnvironment(String deploymentEnvironment) {
        this.deploymentEnvironment = deploymentEnvironment;
    }

    private PreferencesService getPreferencesService() {
        return KewApiServiceLocator.getPreferencesService();
    }
}

