/*
 * Decompiled with CFR 0.152.
 */
package mocks;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import mocks.MockStyleableEmailContentService;
import org.kuali.rice.core.api.mail.EmailContent;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.feedback.web.FeedbackForm;
import org.kuali.rice.kew.mail.service.impl.StyleableEmailContentServiceImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kim.api.identity.Person;

public class MockStyleableEmailContentServiceImpl
extends StyleableEmailContentServiceImpl
implements MockStyleableEmailContentService {
    private boolean wasAccessed = false;

    public EmailContent generateImmediateReminder(Person user, ActionItem actionItem, DocumentType documentType) {
        this.wasAccessed = true;
        return super.generateImmediateReminder(user, actionItem, documentType);
    }

    public EmailContent generateDailyReminder(Person user, Collection<ActionItem> actionItems) {
        this.wasAccessed = true;
        return super.generateDailyReminder(user, actionItems);
    }

    public EmailContent generateWeeklyReminder(Person user, Collection<ActionItem> actionItems) {
        this.wasAccessed = true;
        return super.generateWeeklyReminder(user, actionItems);
    }

    public EmailContent generateFeedback(FeedbackForm form) {
        this.wasAccessed = true;
        return super.generateFeedback(form);
    }

    public DocumentRouteHeaderValue getRouteHeader(ActionItem actionItem) {
        DocumentRouteHeaderValue routeHeader = null;
        if (actionItem.getDocumentId() != null) {
            routeHeader = super.getRouteHeader(actionItem);
        }
        if (routeHeader == null) {
            routeHeader = new DocumentRouteHeaderValue();
            routeHeader.setDocRouteStatus("R");
            routeHeader.setCreateDate(new Timestamp(new Date().getTime()));
        }
        return routeHeader;
    }

    public Map<String, DocumentRouteHeaderValue> getRouteHeaders(Collection<ActionItem> actionItems) {
        Map routeHeaders = super.getRouteHeaders(actionItems);
        DocumentRouteHeaderValue routeHeader = null;
        for (ActionItem actionItem : actionItems) {
            if (routeHeaders.get(actionItem.getDocumentId()) != null) continue;
            routeHeader = new DocumentRouteHeaderValue();
            routeHeader.setDocRouteStatus("R");
            routeHeader.setCreateDate(new Timestamp(new Date().getTime()));
            routeHeaders.put(actionItem.getDocumentId(), routeHeader);
        }
        return routeHeaders;
    }

    @Override
    public boolean wasServiceAccessed() {
        return this.wasAccessed;
    }

    @Override
    public void resetServiceAccessed() {
        this.wasAccessed = false;
    }
}

