/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.edl.impl.EDLGlobalConfig;
import org.kuali.rice.edl.impl.EDLGlobalConfigFactory;
import org.kuali.rice.edl.impl.TestConfigProcessor;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EDLGlobalConfigFactoryTest
extends KEWTestCase {
    @Test
    public void testEDLGlobalConfigParsing() throws Exception {
        EDLGlobalConfig edlGlobalConfig = EDLGlobalConfigFactory.createEDLGlobalConfig((String)"classpath:org/kuali/rice/kew/edl/TestEDLConfig.xml");
        Map preProcessors = edlGlobalConfig.getPreProcessors();
        Map postProcessors = edlGlobalConfig.getPostProcessors();
        Map stateComps = edlGlobalConfig.getStateComponents();
        InputStream fakeyEDL = TestUtilities.loadResource(((Object)((Object)this)).getClass(), "FakeyEDL.xml");
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fakeyEDL);
        Object configProcessorInst = null;
        NodeList edlDefinitionNodes = doc.getElementsByTagName("fieldDef");
        for (int i = 0; i < edlDefinitionNodes.getLength(); ++i) {
            Node definitionNode = edlDefinitionNodes.item(i);
            Class configClass = edlGlobalConfig.getConfigProcessor(definitionNode, null);
            if (configClass == null) continue;
            configProcessorInst = configClass.newInstance();
        }
        Assert.assertTrue((String)"should be 1 preProcessor", (preProcessors.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"should be 1 postProcessor", (postProcessors.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"should be 1 stateComps", (stateComps.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Object made from config proces, arg1", (boolean)(configProcessorInst instanceof TestConfigProcessor));
    }
}

