/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.doctype.IllegalDocumentTypeException;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class CreateDocumentTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test(expected=RiceIllegalArgumentException.class)
    public void testCreateNonExistentDocumentType() throws Exception {
        WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"flim-flam-flooey");
    }

    @Test(expected=IllegalDocumentTypeException.class)
    public void testCreateNonRoutableDocumentType() throws Exception {
        WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"BlanketApproveTest");
    }

    @Test(expected=IllegalDocumentTypeException.class)
    public void testCreateInactiveDocumentType() throws Exception {
        WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"CreatedDocumentInactive");
    }

    @Test
    public void testCreateSimpleDocumentType() throws Exception {
        String principalId = this.getPrincipalIdForName("ewestfal");
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)principalId, (String)"TestDocumentType");
        Assert.assertNotNull((Object)workflowDocument);
        Assert.assertNotNull((Object)workflowDocument.getDocumentId());
        Document document = workflowDocument.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertNotNull((Object)document.getDateCreated());
        Assert.assertNotNull((Object)document.getDateLastModified());
        Assert.assertNull((Object)document.getDateApproved());
        Assert.assertNull((Object)document.getDateFinalized());
        Assert.assertEquals((Object)"", (Object)document.getTitle());
        Assert.assertNotNull((Object)document.getDocumentTypeId());
        Assert.assertEquals((Object)"TestDocumentType", (Object)document.getDocumentTypeName());
        Assert.assertEquals((Object)principalId, (Object)document.getInitiatorPrincipalId());
        Assert.assertEquals((Object)DocumentStatus.INITIATED, (Object)document.getStatus());
    }

    @Override
    protected String getPrincipalIdForName(String principalName) {
        return KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(principalName);
    }
}

