/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.SplitNode;
import org.kuali.rice.kew.engine.node.SplitResult;

public class CustomCycleSplit
implements SplitNode {
    private static int timesToCycle = 0;
    private static String cycleBranchName = null;
    private static String nonCycleBranchName = null;
    private static int timesCycled = 0;

    public SplitResult process(RouteContext context, RouteHelper helper) throws Exception {
        ArrayList<String> branchNames = new ArrayList<String>();
        if (StringUtils.isEmpty((String)cycleBranchName) || StringUtils.isEmpty((String)nonCycleBranchName)) {
            throw new Exception("Must specify cycle and non-cycle branch names.");
        }
        if (timesCycled++ == timesToCycle) {
            branchNames.add(nonCycleBranchName);
        } else {
            branchNames.add(cycleBranchName);
        }
        return new SplitResult(branchNames);
    }

    public static void configureCycle(String cycleBranchName, String nonCycleBranchName, int timesToCycle) {
        CustomCycleSplit.cycleBranchName = cycleBranchName;
        CustomCycleSplit.nonCycleBranchName = nonCycleBranchName;
        CustomCycleSplit.timesToCycle = timesToCycle;
        timesCycled = 0;
    }

    public static int getTimesCycled() {
        return timesCycled;
    }
}

