/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.AdHocRevoke;
import org.kuali.rice.kew.api.action.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;

public class RevokeAdHocActionTest
extends KEWTestCase {
    private static final String ADH0C_DOC = "AdhocRouteTest";
    private String docId;

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testRevokeByActionRequestId() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)ADH0C_DOC);
        this.docId = doc.getDocumentId();
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "annotation1", this.getPrincipalIdForName("dewey"), "respDesc1", false);
        TestUtilities.assertNumberOfPendingRequests(this.docId, 1);
        TestUtilities.assertUserHasPendingRequest(this.docId, "dewey");
        try {
            doc.revokeAdHocRequestById("123456789", "");
            Assert.fail((String)"Revoking by a bad action request id should have thrown an exception!");
        }
        catch (InvalidActionTakenException invalidActionTakenException) {
            // empty catch block
        }
        List actionRequestVOs = KewApiServiceLocator.getWorkflowDocumentService().getRootActionRequests(this.docId);
        Assert.assertEquals((long)1L, (long)actionRequestVOs.size());
        String actionRequestId = ((ActionRequest)actionRequestVOs.get(0)).getId();
        doc.revokeAdHocRequestById(actionRequestId, "");
        TestUtilities.assertNumberOfPendingRequests(this.docId, 0);
        doc.route("");
        doc = this.getDocument("user1");
        Assert.assertTrue((boolean)doc.isApprovalRequested());
        actionRequestVOs = KewApiServiceLocator.getWorkflowDocumentService().getRootActionRequests(this.docId);
        for (int index = 0; index < actionRequestVOs.size(); ++index) {
            if (!((ActionRequest)actionRequestVOs.get(index)).isPending()) continue;
            try {
                doc.revokeAdHocRequestById(((ActionRequest)actionRequestVOs.get(index)).getId().toString(), "");
                Assert.fail((String)"Attempted to revoke by an invalid action request id, should have thrown an error!");
                continue;
            }
            catch (InvalidActionTakenException invalidActionTakenException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testRevokeByUserAndGroup() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)ADH0C_DOC);
        this.docId = doc.getDocumentId();
        String principalId = this.getPrincipalIdForName("dewey");
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "annotationDewey1", principalId, "respDesc1", false);
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "annotationDewey2", principalId, "respDesc1", false);
        String groupId = this.getGroupIdForName("KR-WKFLW", "WorkflowAdmin");
        doc.adHocToGroup(ActionRequestType.APPROVE, "AdHoc", "Annotation WorkflowAdmin", groupId, "respDesc2", true);
        TestUtilities.assertNumberOfPendingRequests(this.docId, 3);
        TestUtilities.assertUserHasPendingRequest(this.docId, "dewey");
        TestUtilities.assertUserHasPendingRequest(this.docId, "quickstart");
        doc.route("");
        Assert.assertTrue((boolean)doc.isEnroute());
        TestUtilities.assertAtNodeNew(doc, "AdHoc");
        TestUtilities.assertNumberOfPendingRequests(this.docId, 3);
        String testGroupId = this.getGroupIdForName("KR-WKFLW", "TestWorkgroup");
        AdHocRevoke revoke = AdHocRevoke.createRevokeFromPrincipal((String)this.getPrincipalIdForName("ewestfal"));
        doc.revokeAdHocRequests(revoke, "This should be a no-op");
        revoke = AdHocRevoke.createRevokeFromGroup((String)testGroupId);
        doc.revokeAdHocRequests(revoke, "This should be a no-op");
        doc = this.getDocument("rkirkend");
        TestUtilities.assertNumberOfPendingRequests(this.docId, 3);
        TestUtilities.assertUserHasPendingRequest(this.docId, "dewey");
        TestUtilities.assertUserHasPendingRequest(this.docId, "quickstart");
        revoke = AdHocRevoke.createRevokeFromPrincipal((String)this.getPrincipalIdForName("dewey"));
        doc.revokeAdHocRequests(revoke, "revokeUser");
        TestUtilities.assertNumberOfPendingRequests(this.docId, 1);
        doc = this.getDocument("dewey");
        Assert.assertFalse((String)"dewey should no longer have an approve request.", (boolean)doc.isApprovalRequested());
        revoke = AdHocRevoke.createRevokeFromGroup((String)groupId);
        doc.revokeAdHocRequests(revoke, "revokeWorkgroup");
        doc = this.getDocument("user1");
        TestUtilities.assertAtNodeNew(doc, "One");
        Assert.assertTrue((String)"user1 should have an approve request.", (boolean)doc.isApprovalRequested());
        doc.approve("");
        Assert.assertTrue((String)"doc should be final", (boolean)doc.isFinal());
    }

    @Test
    public void testRevokeByNodeName() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)ADH0C_DOC);
        this.docId = doc.getDocumentId();
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "annotationDewey1", this.getPrincipalIdForName("dewey"), "respDesc1", false);
        String groupId = this.getGroupIdForName("KR-WKFLW", "WorkflowAdmin");
        doc.adHocToGroup(ActionRequestType.APPROVE, "AdHoc", "Annotation WorkflowAdmin", groupId, "respDesc2", true);
        TestUtilities.assertNumberOfPendingRequests(this.docId, 2);
        doc.revokeAdHocRequests(AdHocRevoke.createRevokeAtNode((String)"AdHoc"), "");
        TestUtilities.assertNumberOfPendingRequests(this.docId, 0);
        doc.adHocToPrincipal(ActionRequestType.ACKNOWLEDGE, "AdHoc", "annotationEwestfal1", this.getPrincipalIdForName("ewestfal"), "respDesc1", false);
        doc = this.getDocument("rkirkend");
        doc.route("");
        TestUtilities.assertAtNodeNew(doc, "One");
        doc = this.getDocument("ewestfal");
        Assert.assertTrue((boolean)doc.isAcknowledgeRequested());
        doc = this.getDocument("user1");
        Assert.assertTrue((boolean)doc.isApprovalRequested());
        doc.approve("");
        Assert.assertTrue((boolean)doc.isProcessed());
        doc.revokeAdHocRequests(AdHocRevoke.createRevokeAtNode((String)"One"), "");
        doc = this.getDocument("ewestfal");
        Assert.assertTrue((boolean)doc.isProcessed());
        doc.revokeAdHocRequests(AdHocRevoke.createRevokeAtNode((String)"AdHoc"), "");
        doc = this.getDocument("ewestfal");
        Assert.assertTrue((boolean)doc.isFinal());
    }

    @Test
    public void testRevokePriorToRouting() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)ADH0C_DOC);
        this.docId = doc.getDocumentId();
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "annotation1", this.getPrincipalIdForName("dewey"), "respDesc1", false);
        doc = this.getDocument("dewey");
        Assert.assertFalse((String)"User andlee should not have an approve request yet.  Document not yet routed.", (boolean)doc.isApprovalRequested());
        String groupId = this.getGroupIdForName("KR-WKFLW", "WorkflowAdmin");
        doc.adHocToGroup(ActionRequestType.APPROVE, "AdHoc", "annotation2", groupId, "respDesc2", true);
        doc = this.getDocument("quickstart");
        Assert.assertFalse((String)"User should not have approve request yet.  Document not yet routed.", (boolean)doc.isApprovalRequested());
        Assert.assertTrue((String)"Document should still be intitiated.", (boolean)doc.isInitiated());
        doc = this.getDocument("rkirkend");
        List actionRequestVOs = KewApiServiceLocator.getWorkflowDocumentService().getRootActionRequests(doc.getDocumentId());
        Assert.assertEquals((String)"There should be 2 ad hoc requests.", (long)2L, (long)actionRequestVOs.size());
        for (ActionRequest requestVO : actionRequestVOs) {
            Assert.assertTrue((String)"Should be an ad hoc request.", (boolean)requestVO.isAdHocRequest());
            doc.revokeAdHocRequestById(requestVO.getId().toString(), "");
        }
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(this.docId);
        Assert.assertEquals((String)"There should be no pending requests.", (long)0L, (long)actionRequests.size());
        Collection actionTakens = KEWServiceLocator.getActionTakenService().findByDocumentId(this.docId);
        int numAdhocRevoked = 0;
        for (ActionTakenValue actionTaken : actionTakens) {
            if (!actionTaken.getActionTaken().equals("V")) continue;
            ++numAdhocRevoked;
        }
        Assert.assertEquals((String)"There should be 2 'AdHocRevoked' action takens", (long)2L, (long)numAdhocRevoked);
        doc = this.getDocument("rkirkend");
        Assert.assertTrue((String)"Document should still be intitiated.", (boolean)doc.isInitiated());
    }

    @Test
    public void testRevokeAfterBlanketApprove() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)ADH0C_DOC);
        this.docId = doc.getDocumentId();
        doc.adHocToPrincipal(ActionRequestType.FYI, "AdHoc", "annotationEwestfal1", this.getPrincipalIdForName("ewestfal"), "respDesc1", false);
        doc.blanketApprove("");
        Assert.assertTrue((boolean)doc.isProcessed());
        doc = this.getDocument("ewestfal");
        Assert.assertTrue((boolean)doc.isFYIRequested());
        doc = this.getDocument("user1");
        Assert.assertTrue((boolean)doc.isAcknowledgeRequested());
        doc.revokeAllAdHocRequests("revoking all adhocs");
        Assert.assertTrue((boolean)doc.isProcessed());
        TestUtilities.assertNumberOfPendingRequests(this.docId, 1);
        Assert.assertTrue((boolean)doc.isAcknowledgeRequested());
        doc = this.getDocument("ewestfal");
        Assert.assertFalse((boolean)doc.isFYIRequested());
    }

    private WorkflowDocument getDocument(String netid) throws WorkflowException {
        return WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(netid), (String)this.docId);
    }
}

