/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class RoleTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testRoleRequestGeneration() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NotificationTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((String)"This user should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"This user should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"This user should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("natjohns"), (String)document.getDocumentId());
        Assert.assertTrue((String)"This user should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("xqi"), (String)document.getDocumentId());
        document.acknowledge("");
        Assert.assertTrue((String)"Document should be final", (boolean)document.isFinal());
        List requests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        List rootRequests = KEWServiceLocator.getActionRequestService().getRootRequests((Collection)requests);
        for (ActionRequestValue request : rootRequests) {
            if (!request.isRoleRequest()) continue;
            this.iterateChildrenRequests(request.getChildrenRequests(), new String[]{"U", "W"}, request);
        }
    }

    private void iterateChildrenRequests(Collection childrenRequests, String[] requestTypes, ActionRequestValue parentRequest) {
        for (ActionRequestValue request : childrenRequests) {
            boolean matched = false;
            for (int i = 0; i < requestTypes.length; ++i) {
                if (!request.getRecipientTypeCd().equals(requestTypes[i])) continue;
                matched = true;
            }
            if (!matched) {
                Assert.fail((String)("Didn't find request of types expected Recipient Type: " + parentRequest.getRecipientTypeCd() + " RoleName: " + parentRequest.getRoleName() + " Qualified Role Name:" + parentRequest.getQualifiedRoleName() + " RuleId: " + parentRequest.getRuleBaseValuesId()));
            }
            if (!request.isRoleRequest()) continue;
            this.iterateChildrenRequests(request.getChildrenRequests(), new String[]{"U", "W"}, request);
        }
    }
}

