/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.InvalidActionTakenException;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class SaveActionEventTest
extends KEWTestCase {
    public static final String DOCUMENT_TYPE_NAME = "SaveActionEventTest";
    public static final String DOCUMENT_TYPE_NAME_NON_INITIATOR = "SaveActionEventTestNonInitiator";
    public static final String ADHOC_NODE = "AdHoc";
    public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testSaveActionEvent() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DOCUMENT_TYPE_NAME);
        document.saveDocumentData();
        Assert.assertTrue((String)"Document should be initiated.", (boolean)document.isInitiated());
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should be no action requests.", (long)0L, (long)actionRequests.size());
        Assert.assertTrue((String)"Document should be initiated.", (boolean)document.isInitiated());
        document.saveDocument("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertEquals((String)"Document should be at AdHoc node.", (Object)ADHOC_NODE, document.getNodeNames().iterator().next());
        Assert.assertTrue((String)"Document should be SAVED.", (boolean)document.isSaved());
        actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should be one COMPLETE request to the initiator.", (long)1L, (long)actionRequests.size());
        Assert.assertTrue((String)"Initiator should have complete request.", (boolean)document.isCompletionRequested());
        ActionRequestValue savedRequest = (ActionRequestValue)actionRequests.get(0);
        Assert.assertNotNull((Object)savedRequest);
        Assert.assertTrue((String)"Saved request should be a complete request.", (boolean)savedRequest.isCompleteRequst());
        Assert.assertEquals((String)"Request should be at the AdHoc node.", (Object)ADHOC_NODE, (Object)savedRequest.getNodeInstance().getName());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        try {
            document.route("");
            Assert.fail((String)"RouteDocument should have thrown an exception because we aren't the initiator");
        }
        catch (InvalidActionTakenException invalidActionTakenException) {
            // empty catch block
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        document.route("Routing Rowdy Roddy Pipper");
        actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Should be 2 pending requests.", (long)2L, (long)actionRequests.size());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be in routing.", (boolean)document.isEnroute());
        Assert.assertTrue((String)"rkirkend should have approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be in routing.", (boolean)document.isEnroute());
        Assert.assertTrue((String)"bmcgough should have approve request.", (boolean)document.isApprovalRequested());
        Assert.assertEquals((String)"Document should be at WorkflowDocument node.", (Object)WORKFLOW_DOCUMENT_NODE, document.getNodeNames().iterator().next());
        for (ActionRequestValue request : actionRequests) {
            Assert.assertNotNull((Object)request.getNodeInstance());
            Assert.assertEquals((String)"Request should be at WorkflowDocument node.", (Object)WORKFLOW_DOCUMENT_NODE, (Object)request.getNodeInstance().getName());
        }
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DOCUMENT_TYPE_NAME);
        document.saveDocument("");
        Assert.assertTrue((String)"Document should be saved.", (boolean)document.isSaved());
        Assert.assertTrue((String)"Should have complete request.", (boolean)document.isCompletionRequested());
        Assert.assertEquals((String)"Document should be at AdHoc node.", (Object)ADHOC_NODE, document.getNodeNames().iterator().next());
        document.complete("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        Assert.assertTrue((String)"Should have approve request.", (boolean)document.isApprovalRequested());
        Assert.assertEquals((String)"Document should be at WorkflowDocument node.", (Object)WORKFLOW_DOCUMENT_NODE, document.getNodeNames().iterator().next());
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DOCUMENT_TYPE_NAME);
        document.saveDocument("");
        Assert.assertTrue((String)"Document should be saved.", (boolean)document.isSaved());
        Assert.assertTrue((String)"Should have complete request.", (boolean)document.isCompletionRequested());
        Assert.assertTrue((String)"Should also indicate approval is valid.", (boolean)document.isApprovalRequested());
        Assert.assertEquals((String)"Document should be at AdHoc node.", (Object)ADHOC_NODE, document.getNodeNames().iterator().next());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        Assert.assertTrue((String)"Should have approve request.", (boolean)document.isApprovalRequested());
        Assert.assertEquals((String)"Document should be at WorkflowDocument node.", (Object)WORKFLOW_DOCUMENT_NODE, document.getNodeNames().iterator().next());
    }

    @Test
    public void testDefaultInitiatorMustSavePolicy() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DOCUMENT_TYPE_NAME);
        document.saveDocumentData();
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should be no action requests.", (long)0L, (long)actionRequests.size());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isInitiated());
        try {
            document.saveDocument("");
            Assert.fail((String)"A WorkflowException should have been thrown.");
        }
        catch (InvalidActionTakenException e) {
            e.printStackTrace();
        }
        actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should be no action requests.", (long)0L, (long)actionRequests.size());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        document.saveDocument("");
        Assert.assertTrue((boolean)document.isSaved());
        actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should be one action request.", (long)1L, (long)actionRequests.size());
    }

    @Test
    public void testFalseInitiatorMustSavePolicy() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DOCUMENT_TYPE_NAME_NON_INITIATOR);
        document.saveDocumentData();
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should be no action requests.", (long)0L, (long)actionRequests.size());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isInitiated());
        document.saveDocument("");
        Assert.assertTrue((boolean)document.isSaved());
        actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should be one action request.", (long)1L, (long)actionRequests.size());
    }
}

