/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.test.KEWTestCase;

public class SuperUserCancelTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testSuperUserCancel() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NotificationTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((String)"WorkflowDocument should indicate jhopf as SuperUser", (boolean)document.isValidAction(ActionType.SU_CANCEL));
        document.superUserCancel("");
        Assert.assertTrue((String)"Document should be final after Super User Cancel", (boolean)document.isCanceled());
    }

    @Test
    public void testSuperUserInitiatorCancel() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NotificationTest");
        Assert.assertTrue((String)"WorkflowDocument should indicate ewestfal as SuperUser", (boolean)document.isValidAction(ActionType.SU_CANCEL));
        document.superUserCancel("");
        Assert.assertTrue((String)"Document should be final after Super User Cancel", (boolean)document.isCanceled());
    }

    @Test
    public void testSuperUserNonInitiatorCancel() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("delyea"), (String)"NotificationTest");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"WorkflowDocument should indicate ewestfal as SuperUser", (boolean)document.isValidAction(ActionType.SU_CANCEL));
        document.superUserCancel("");
        Assert.assertTrue((String)"Document should be final after Super User Cancel", (boolean)document.isCanceled());
    }

    @Test
    public void testSuperUserCancelInvalidUser() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NotificationTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("quickstart"), (String)document.getDocumentId());
        try {
            Assert.assertFalse((String)"WorkflowDocument should not indicate quickstart as SuperUser", (boolean)document.isValidAction(ActionType.SU_CANCEL));
            document.superUserCancel("");
            Assert.fail((String)"invalid user attempted to SuperUserApprove");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

