/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class TakeWorkgroupAuthorityTest
extends KEWTestCase {
    public static final String DOC_TYPE = "TakeWorkgroupAuthorityDoc";
    public static List<String> WORKGROUP_MEMBERS = new ArrayList<String>();

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testTakeWorkgroupAuthorityAction() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)DOC_TYPE);
        doc.route("");
        String groupId = this.getGroupIdForName("KR-WKFLW", "TestWorkgroup");
        ActionListService aiService = KEWServiceLocator.getActionListService();
        Collection actionItems = aiService.findByDocumentId(doc.getDocumentId());
        Assert.assertTrue((String)"There should be more than one action item", (actionItems.size() > 1 ? 1 : 0) != 0);
        for (ActionItem actionItem : actionItems) {
            Assert.assertTrue((String)"Action Item not to workgroup member", (boolean)WORKGROUP_MEMBERS.contains(this.getPrincipalNameForId(actionItem.getPrincipalId())));
        }
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)doc.getDocumentId());
        doc.takeGroupAuthority("", groupId);
        actionItems = aiService.findByDocumentId(doc.getDocumentId());
        Assert.assertEquals((String)"There should only be a single action item to rkirkend", (long)1L, (long)actionItems.size());
        for (ActionItem actionItem : actionItems) {
            Assert.assertEquals((String)"Action item should be to rkirkend", (Object)"rkirkend", (Object)this.getPrincipalNameForId(actionItem.getPrincipalId()));
        }
        List actionsTaken = KewApiServiceLocator.getWorkflowDocumentService().getActionsTaken(doc.getDocumentId());
        boolean rkirkendATFound = false;
        for (ActionTaken at : actionsTaken) {
            if (!at.getPrincipalId().equals(this.getPrincipalIdForName("rkirkend"))) continue;
            Assert.assertEquals((String)"Incorrect action code recorded", (Object)"w", (Object)at.getActionTaken().getCode());
            rkirkendATFound = true;
        }
        Assert.assertTrue((String)"should have found action taken for rkirkend", (boolean)rkirkendATFound);
    }

    static {
        WORKGROUP_MEMBERS.add("ewestfal");
        WORKGROUP_MEMBERS.add("rkirkend");
        WORKGROUP_MEMBERS.add("jhopf");
        WORKGROUP_MEMBERS.add("bmcgough");
        WORKGROUP_MEMBERS.add("temay");
        WORKGROUP_MEMBERS.add("xqi");
        WORKGROUP_MEMBERS.add("natjohns");
        WORKGROUP_MEMBERS.add("pmckown");
        WORKGROUP_MEMBERS.add("jthomas");
        WORKGROUP_MEMBERS.add("jitrue");
    }
}

