/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Set;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.action.ValidActions;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.test.KEWTestCase;

public class ValidActionsTest
extends KEWTestCase {
    private static final Logger LOG = Logger.getLogger(ValidActionsTest.class);
    public static final String DOCUMENT_TYPE_NAME = "BlanketApproveSequentialTest";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testValidActions() throws Exception {
        WorkflowDocument document = null;
        String networkId = null;
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)DOCUMENT_TYPE_NAME);
        String documentId = document.getDocumentId();
        networkId = "rkirkend";
        document = this.checkActions(networkId, documentId, new String[]{"c", "a"}, new String[]{"B", "O", "S", "X", ActionType.RECALL.getCode()});
        networkId = "pmckown";
        document = this.checkActions(networkId, documentId, new String[0], new String[]{"B", "c", "a", "O", "S", "X", ActionType.RECALL.getCode()});
        networkId = "user1";
        document = this.checkActions(networkId, documentId, new String[]{"O", "S", "X"}, new String[]{"B", "c", "a", ActionType.RECALL.getCode()});
        document.saveDocument("");
        networkId = "rkirkend";
        document = this.checkActions(networkId, documentId, new String[]{"c", "a"}, new String[]{"B", "O", "S", "X", ActionType.RECALL.getCode()});
        networkId = "pmckown";
        document = this.checkActions(networkId, documentId, new String[0], new String[]{"B", "c", "a", "O", "S", "X", ActionType.RECALL.getCode()});
        networkId = "user1";
        document = this.checkActions(networkId, documentId, new String[]{"O", "S", "X"}, new String[]{"B", "c", "a", ActionType.RECALL.getCode()});
        document.route("");
        Assert.assertEquals((String)"Document should be ENROUTE", (Object)DocumentStatus.ENROUTE, (Object)document.getStatus());
        networkId = "user1";
        document = this.checkActions(networkId, documentId, new String[]{ActionType.RECALL.getCode()}, new String[]{"S", "O", "B", "c", "a", "X"});
        networkId = "rkirkend";
        document = this.checkActions(networkId, documentId, new String[]{"B", "c", "a", "A"}, new String[]{"S", "O", ActionType.RECALL.getCode()});
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        document.approve("");
        this.checkActions("user1", documentId, new String[0], new String[]{ActionType.RECALL.getCode()});
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("pmckown"), (String)document.getDocumentId());
        document.approve("");
        this.checkActions("user1", documentId, new String[0], new String[]{ActionType.RECALL.getCode()});
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        document.acknowledge("");
        this.checkActions("user1", documentId, new String[0], new String[]{ActionType.RECALL.getCode()});
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)document.getDocumentId());
        document.acknowledge("");
        this.checkActions("user1", documentId, new String[0], new String[]{ActionType.RECALL.getCode()});
    }

    private WorkflowDocument checkActions(String networkId, String documentId, String[] validActionsAllowed, String[] invalidActionsNotAllowed) throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(networkId), (String)documentId);
        ValidActions validActions = document.getValidActions();
        Set validActionsSet = validActions.getValidActions();
        for (int i = 0; i < validActionsAllowed.length; ++i) {
            String actionAllowed = validActionsAllowed[i];
            if (validActionsSet.contains(ActionType.fromCode((String)actionAllowed))) continue;
            Assert.fail((String)("Action '" + (String)KewApiConstants.ACTION_TAKEN_CD.get(actionAllowed) + "' should be allowed for user " + networkId));
        }
        for (int j = 0; j < invalidActionsNotAllowed.length; ++j) {
            String actionDisallowed = invalidActionsNotAllowed[j];
            if (!validActionsSet.contains(actionDisallowed)) continue;
            Assert.fail((String)("Action '" + (String)KewApiConstants.ACTION_TAKEN_CD.get(actionDisallowed) + "' should not be allowed for user " + networkId));
        }
        return document;
    }
}

