/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions.asyncservices;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionInvocation;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.impl.action.ActionInvocationQueueImpl;
import org.kuali.rice.kew.rule.TestRuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class ActionInvocationQueueImplTest
extends KEWTestCase {
    @Test
    public void testActionInvocationQueue_worksWithNoActionItem() throws Exception {
        TestRuleAttribute.setRecipientPrincipalIds("TestRole", "QualRole", this.getRecipients());
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)rkirkendPrincipalId, (String)"TestDocumentType");
        doc.route("");
        List requests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(doc.getDocumentId());
        Assert.assertFalse((boolean)requests.isEmpty());
        ActionRequestValue request = null;
        for (ActionRequestValue tempRequest : requests) {
            if (tempRequest.getPrincipal() == null || !tempRequest.getPrincipal().getPrincipalName().equals("user1")) continue;
            request = tempRequest;
            break;
        }
        Assert.assertNotNull(request);
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        String actionItemID = request.getDocumentId().trim();
        new ActionInvocationQueueImpl().invokeAction(user1PrincipalId, request.getDocumentId(), ActionInvocation.create((ActionType)ActionType.fromCode((String)request.getActionRequested()), (String)actionItemID));
        new ActionInvocationQueueImpl().invokeAction(user1PrincipalId, request.getDocumentId(), ActionInvocation.create((ActionType)ActionType.fromCode((String)request.getActionRequested()), (String)actionItemID));
        requests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(doc.getDocumentId());
        Assert.assertFalse((boolean)requests.isEmpty());
        request = null;
        for (ActionRequestValue tempRequest : requests) {
            if (tempRequest.getPrincipalId() == null || !tempRequest.getPrincipalId().equals(this.getPrincipalIdForName("user1")) || !tempRequest.isActive()) continue;
            request = tempRequest;
            break;
        }
        Assert.assertNull((Object)request);
    }

    public List<String> getRecipients() {
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(this.getPrincipalIdForName("user1"));
        recipients.add(this.getPrincipalIdForName("user2"));
        return recipients;
    }
}

