/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.clientapp;

import org.apache.commons.lang.StringUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.api.document.DocumentContentUpdate;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.TestRuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class DocumentContentTest
extends KEWTestCase {
    private static final String DOCUMENT_CONTENT = "documentContent";
    private static final String ATTRIBUTE_CONTENT = "attributeContent";
    private static final String SEARCHABLE_CONTENT = "searchableContent";
    private static final String APPLICATION_CONTENT = "applicationContent";

    @Test
    public void testEmptyDocumentContent() throws Exception {
        DocumentContent content = DocumentContent.Builder.create((String)"1234").build();
        Assert.assertEquals((Object)"<documentContent></documentContent>", (Object)content.getFullContent());
    }

    @Test
    public void testDocumentContent() throws Exception {
        String startContent = "<documentContent>";
        String endContent = "</documentContent>";
        String emptyContent1 = startContent + endContent;
        String emptyContent2 = "<documentContent/>";
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        Assert.assertEquals((String)"Content should be empty.", (Object)"", (Object)document.getApplicationContent());
        Assert.assertEquals((String)"Content should be empty.", (Object)"", (Object)document.getAttributeContent());
        Assert.assertEquals((String)"Content should be empty.", (Object)"", (Object)document.getDocumentContent().getSearchableContent());
        String fullContent = document.getDocumentContent().getFullContent();
        Assert.assertTrue((String)"Invalid content conversion.", (fullContent.equals(emptyContent1) || fullContent.equals(emptyContent2) ? 1 : 0) != 0);
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        document.saveDocumentData();
        Assert.assertNotNull((Object)document.getDocumentId());
        Assert.assertEquals((String)"Incorrect document id.", (Object)document.getDocumentId(), (Object)document.getDocumentContent().getDocumentId());
        Assert.assertEquals((String)"Content should be empty.", (Object)"", (Object)document.getApplicationContent());
        Assert.assertEquals((String)"Content should be empty.", (Object)"", (Object)document.getAttributeContent());
        Assert.assertEquals((String)"Content should be empty.", (Object)"", (Object)document.getDocumentContent().getSearchableContent());
        fullContent = document.getDocumentContent().getFullContent();
        Assert.assertTrue((String)"Invalid content conversion.", (fullContent.equals(emptyContent1) || fullContent.equals(emptyContent2) ? 1 : 0) != 0);
        DocumentRouteHeaderValue routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        Assert.assertTrue((String)"Invalid initial content.", (routeHeader.getDocContent().equals(emptyContent1) || routeHeader.getDocContent().equals(emptyContent2) ? 1 : 0) != 0);
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        String attributeContent = "<attribute1><id value=\"3\"/></attribute1>";
        String searchableContent = "<searchable1><data>hello</data></searchable1>";
        DocumentContentUpdate.Builder contentVO = DocumentContentUpdate.Builder.create((DocumentContent)document.getDocumentContent());
        contentVO.setAttributeContent(this.constructContent(ATTRIBUTE_CONTENT, attributeContent));
        contentVO.setSearchableContent(this.constructContent(SEARCHABLE_CONTENT, searchableContent));
        document.updateDocumentContent(contentVO.build());
        document.saveDocumentData();
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        String expectedContent = startContent + this.constructContent(ATTRIBUTE_CONTENT, attributeContent) + this.constructContent(SEARCHABLE_CONTENT, searchableContent) + endContent;
        fullContent = document.getDocumentContent().getFullContent();
        Assert.assertEquals((String)"Invalid content conversion.", (Object)StringUtils.deleteWhitespace((String)expectedContent), (Object)StringUtils.deleteWhitespace((String)fullContent));
        String testAttributeContent = new TestRuleAttribute().getDocContent();
        WorkflowAttributeDefinition attributeDefinition = WorkflowAttributeDefinition.Builder.create((String)"TestRuleAttribute").build();
        document.addAttributeDefinition(attributeDefinition);
        document.clearAttributeDefinitions();
        document.saveDocumentData();
        fullContent = document.getDocumentContent().getFullContent();
        Assert.assertEquals((String)"Invalid content conversion.", (Object)StringUtils.deleteWhitespace((String)expectedContent), (Object)StringUtils.deleteWhitespace((String)fullContent));
        document.addAttributeDefinition(attributeDefinition);
        document.saveDocumentData();
        fullContent = document.getDocumentContent().getFullContent();
        expectedContent = startContent + this.constructContent(ATTRIBUTE_CONTENT, attributeContent + testAttributeContent) + this.constructContent(SEARCHABLE_CONTENT, searchableContent) + endContent;
        Assert.assertEquals((String)"Invalid content conversion.", (Object)StringUtils.deleteWhitespace((String)expectedContent), (Object)StringUtils.deleteWhitespace((String)fullContent));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        document.addAttributeDefinition(attributeDefinition);
        document.addAttributeDefinition(attributeDefinition);
        document.saveDocumentData();
        fullContent = document.getDocumentContent().getFullContent();
        expectedContent = startContent + this.constructContent(ATTRIBUTE_CONTENT, attributeContent + testAttributeContent + testAttributeContent + testAttributeContent) + this.constructContent(SEARCHABLE_CONTENT, searchableContent) + endContent;
        Assert.assertEquals((String)"Invalid content conversion.", (Object)StringUtils.deleteWhitespace((String)expectedContent), (Object)StringUtils.deleteWhitespace((String)fullContent));
        document.clearAttributeContent();
        expectedContent = startContent + this.constructContent(SEARCHABLE_CONTENT, searchableContent) + endContent;
        fullContent = document.getDocumentContent().getFullContent();
        Assert.assertEquals((String)"Invalid content conversion.", (Object)StringUtils.deleteWhitespace((String)expectedContent), (Object)StringUtils.deleteWhitespace((String)fullContent));
        document.saveDocumentData();
        fullContent = document.getDocumentContent().getFullContent();
        Assert.assertEquals((String)"Invalid content conversion.", (Object)StringUtils.deleteWhitespace((String)expectedContent), (Object)StringUtils.deleteWhitespace((String)fullContent));
        String myRadContent = "<myRadContent>abcd</myRadContent>";
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        DocumentRouteHeaderValue documentValue = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        documentValue.setDocContent(myRadContent);
        KEWServiceLocator.getRouteHeaderService().saveRouteHeader(documentValue);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        String expected = startContent + this.constructContent(APPLICATION_CONTENT, myRadContent) + endContent;
        fullContent = document.getDocumentContent().getFullContent();
        Assert.assertEquals((String)"Backward compatibility failure.", (Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)fullContent));
    }

    private String constructContent(String type, String content) {
        if (content == null) {
            return "";
        }
        return "<" + type + ">" + content + "</" + type + ">";
    }

    @Test
    public void testDocumentContentConsistency() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        String appContent = "<app>content</app>";
        document.setApplicationContent(appContent);
        document.saveDocumentData();
        XMLAssert.assertXMLEqual((String)appContent, (String)document.getApplicationContent());
        WorkflowDocument document2 = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        XMLAssert.assertXMLEqual((String)appContent, (String)document2.getApplicationContent());
        String appContent2 = "<app>content2</app>";
        document2.setApplicationContent(appContent2);
        XMLAssert.assertXMLEqual((String)appContent2, (String)document2.getApplicationContent());
        document2.saveDocumentData();
        XMLAssert.assertXMLEqual((String)appContent, (String)document.getApplicationContent());
        document.saveDocumentData();
        XMLAssert.assertXMLEqual((String)appContent2, (String)document.getApplicationContent());
        document2.setApplicationContent("<bad>content</bad>");
        document2 = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document2.getDocumentId());
        XMLAssert.assertXMLEqual((String)appContent2, (String)document.getApplicationContent());
    }

    @Test
    public void testManualDocumentContentModification() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        document.saveDocumentData();
        DocumentContent content = KewApiServiceLocator.getWorkflowDocumentService().getDocumentContent(document.getDocumentId());
        Assert.assertTrue((String)("Should contain default content, was " + content.getFullContent()), ("<documentContent/>".equals(content.getFullContent()) || "<documentContent></documentContent>".equals(content.getFullContent()) ? 1 : 0) != 0);
        String appContent = "<abcdefg>hijklm n o p</abcdefg>";
        DocumentContentUpdate.Builder contentUpdate = DocumentContentUpdate.Builder.create((DocumentContent)content);
        contentUpdate.setApplicationContent(appContent);
        document.updateDocumentContent(contentUpdate.build());
        document.saveDocumentData();
        XMLAssert.assertXMLEqual((String)appContent, (String)document.getApplicationContent());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        XMLAssert.assertXMLEqual((String)appContent, (String)document.getApplicationContent());
    }
}

