/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.clientapp;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actions.BlanketApproveTest;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class WorkflowInfoTest
extends KEWTestCase {
    @Override
    protected void loadTestData() {
        this.loadXmlFile(BlanketApproveTest.class, "ActionsConfig.xml");
    }

    @Test
    public void testGetRouteHeader() throws Exception {
        GlobalVariables.setUserSession(null);
        String ewestfalPrincipalId = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("ewestfal").getPrincipalId();
        GlobalVariables.setUserSession((UserSession)new UserSession("ewestfal"));
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)ewestfalPrincipalId, (String)"TestDocumentType");
        String documentId = workflowDocument.getDocumentId();
        Assert.assertNotNull((Object)documentId);
        Document document = KewApiServiceLocator.getWorkflowDocumentService().getDocument(documentId);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)documentId, (Object)document.getDocumentId());
        Assert.assertEquals((Object)DocumentStatus.INITIATED, (Object)document.getStatus());
    }

    @Test
    public void testGetDocumentStatus() throws Exception {
        DocumentStatus status2;
        try {
            status2 = KewApiServiceLocator.getWorkflowDocumentService().getDocumentStatus(null);
            Assert.fail((String)("A WorkflowException should have been thrown, instead returned status: " + status2));
        }
        catch (IllegalArgumentException status2) {
            // empty catch block
        }
        try {
            status2 = KewApiServiceLocator.getWorkflowDocumentService().getDocumentStatus("-1");
            Assert.fail((String)("A IllegalStateException Should have been thrown, instead returned status: " + status2));
        }
        catch (IllegalStateException status3) {
            // empty catch block
        }
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        String documentId = document.getDocumentId();
        Assert.assertNotNull((Object)documentId);
        DocumentStatus status4 = KewApiServiceLocator.getWorkflowDocumentService().getDocumentStatus(documentId);
        Assert.assertEquals((String)"Document should be INITIATED.", (Object)"I", (Object)status4.getCode());
        document.cancel("");
        status4 = KewApiServiceLocator.getWorkflowDocumentService().getDocumentStatus(documentId);
        Assert.assertEquals((String)"Document should be CANCELED.", (Object)"X", (Object)status4.getCode());
    }

    @Test
    public void testBlanketApproverSubmitted() throws WorkflowException {
        Person blanketApprover = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("ewestfal");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)blanketApprover.getPrincipalId(), (String)"BlanketApproveParallelTest");
        document.blanketApprove("");
        String routedByPrincipalId = KewApiServiceLocator.getWorkflowDocumentService().getRoutedByPrincipalIdByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"the blanket approver should be the routed by", (Object)blanketApprover.getPrincipalId(), (Object)routedByPrincipalId);
    }

    @Test
    public void testGetAppDocId() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        document.saveDocumentData();
        String appDocId = KewApiServiceLocator.getWorkflowDocumentService().getApplicationDocumentId(document.getDocumentId());
        Assert.assertNull((String)"appDocId should be null", (Object)appDocId);
        String appDocIdValue = "1234";
        document.setApplicationDocumentId(appDocIdValue);
        document.saveDocumentData();
        appDocId = KewApiServiceLocator.getWorkflowDocumentService().getApplicationDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"Incorrect appDocId", (Object)appDocIdValue, (Object)appDocId);
    }

    @Test
    public void testGetAppDocStatus() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        document.saveDocumentData();
        String appDocStatus = KewApiServiceLocator.getWorkflowDocumentService().getApplicationDocumentStatus(document.getDocumentId());
        Assert.assertNull((String)"appDocStatus should be null", (Object)appDocStatus);
        String appDocStatusValue = "Approved";
        document.setApplicationDocumentStatus(appDocStatusValue);
        document.saveDocumentData();
        appDocStatus = KewApiServiceLocator.getWorkflowDocumentService().getApplicationDocumentStatus(document.getDocumentId());
        Assert.assertEquals((String)"Incorrect appDocStatus", (Object)appDocStatusValue, (Object)appDocStatus);
    }
}

