/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.DocumentContentUpdate;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.docsearch.DocumentSearchInternalUtils;
import org.kuali.rice.kew.docsearch.DocumentSearchTestBase;
import org.kuali.rice.kew.docsearch.SearchableAttributeDateTimeValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeFloatValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeLongValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeStringValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.docsearch.TestXMLSearchableAttributeDateTime;
import org.kuali.rice.kew.docsearch.TestXMLSearchableAttributeFloat;
import org.kuali.rice.kew.docsearch.TestXMLSearchableAttributeLong;
import org.kuali.rice.kew.docsearch.service.DocumentSearchService;
import org.kuali.rice.kew.docsearch.xml.StandardGenericXMLSearchableAttribute;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.impl.document.search.DocumentSearchCriteriaTranslatorImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.dao.DocumentRouteHeaderDAO;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class SearchableAttributeTest
extends DocumentSearchTestBase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("SearchAttributeConfig.xml");
        this.loadXmlFile("SearchableTrimTest.xml");
    }

    @Test
    public void testSearchableAttributeSearch() throws Exception {
        String documentTypeName = "SearchDocType";
        String userNetworkId = "rkirkend";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalId(userNetworkId), (String)workflowDocument.getDocumentId());
        DocumentRouteHeaderValue doc = KEWServiceLocator.getRouteHeaderService().getRouteHeader(workflowDocument.getDocumentId());
        DocumentRouteHeaderDAO dao = (DocumentRouteHeaderDAO)KEWServiceLocator.getBean((String)"enDocumentRouteHeaderDAO");
        Collection allValues = dao.findSearchableAttributeValues(workflowDocument.getDocumentId());
        Assert.assertEquals((String)"Wrong number of searchable attributes", (long)4L, (long)allValues.size());
        for (SearchableAttributeValue attributeValue : allValues) {
            SearchableAttributeStringValue realValue;
            if (attributeValue instanceof SearchableAttributeStringValue) {
                realValue = (SearchableAttributeStringValue)attributeValue;
                for (Object value : this.getRouteHeaderService().getSearchableAttributeStringValuesByKey(doc.getDocumentId(), realValue.getSearchableAttributeKey())) {
                    Assert.assertEquals((String)"Assert that the values are the same", (Object)value, (Object)attributeValue.getSearchableAttributeValue());
                }
                continue;
            }
            if (attributeValue instanceof SearchableAttributeLongValue) {
                realValue = (SearchableAttributeLongValue)attributeValue;
                for (Object value : this.getRouteHeaderService().getSearchableAttributeLongValuesByKey(doc.getDocumentId(), realValue.getSearchableAttributeKey())) {
                    Assert.assertEquals((String)"Assert that the values are the same", (Object)value, (Object)attributeValue.getSearchableAttributeValue());
                }
                continue;
            }
            if (attributeValue instanceof SearchableAttributeFloatValue) {
                realValue = (SearchableAttributeFloatValue)attributeValue;
                for (Object value : this.getRouteHeaderService().getSearchableAttributeFloatValuesByKey(doc.getDocumentId(), realValue.getSearchableAttributeKey())) {
                    Assert.assertEquals((String)"Assert that the values are the same", (Object)value, (Object)attributeValue.getSearchableAttributeValue());
                }
                continue;
            }
            if (attributeValue instanceof SearchableAttributeDateTimeValue) {
                realValue = (SearchableAttributeDateTimeValue)attributeValue;
                Assert.assertEquals((String)"The only DateTime attribute that should have been added has key 'testDateTimeKey'", (Object)"testDateTimeKey", (Object)realValue.getSearchableAttributeKey());
                Calendar testDate = Calendar.getInstance();
                testDate.setTimeInMillis(realValue.getSearchableAttributeValue().getTime());
                testDate.set(13, 0);
                testDate.set(14, 0);
                for (Timestamp value : this.getRouteHeaderService().getSearchableAttributeDateTimeValuesByKey(doc.getDocumentId(), realValue.getSearchableAttributeKey())) {
                    Calendar attributeDate = Calendar.getInstance();
                    attributeDate.setTimeInMillis(value.getTime());
                    attributeDate.set(13, 0);
                    attributeDate.set(14, 0);
                    Assert.assertEquals((String)"The month value for the searchable attribute is wrong", (long)testDate.get(2), (long)attributeDate.get(2));
                    Assert.assertEquals((String)"The date value for the searchable attribute is wrong", (long)testDate.get(5), (long)attributeDate.get(5));
                    Assert.assertEquals((String)"The year value for the searchable attribute is wrong", (long)testDate.get(1), (long)attributeDate.get(1));
                }
                continue;
            }
            Assert.fail((String)"Searchable Attribute Value base class should be one of the four checked always");
        }
    }

    protected RouteHeaderService getRouteHeaderService() {
        RouteHeaderService rRet = KEWServiceLocator.getRouteHeaderService();
        return rRet;
    }

    protected String getPrincipalId(String networkId) {
        return KimApiServiceLocator.getPersonService().getPersonByPrincipalName(networkId).getPrincipalId();
    }

    @Test
    public void testCustomSearchableAttributesWithDataType() throws Exception {
        String documentTypeName = "SearchDocType";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        String userNetworkId = "rkirkend";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalId(userNetworkId), (String)workflowDocument.getDocumentId());
        DocumentRouteHeaderValue doc = KEWServiceLocator.getRouteHeaderService().getRouteHeader(workflowDocument.getDocumentId());
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(userNetworkId);
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "givenname", "jack");
        DocumentSearchResults results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "givenname", "fred");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "fakeproperty", "doesntexist");
        try {
            docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "testLongKey", TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString());
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "testLongKey", "1111111");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "fakeymcfakefake", "99999999");
        try {
            docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "testFloatKey", TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString());
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "testFloatKey", "215.3548");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "fakeylostington", "9999.9999");
        try {
            docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "testDateTimeKey", DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)new Timestamp(TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE_IN_MILLS)));
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "testDateTimeKey", "07/06/1979");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "lastingsfakerson", "07/06/2007");
        try {
            docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSearchAttributesAcrossDocumentTypeVersions() throws Exception {
        this.loadXmlFile("testdoc0.xml");
        String documentTypeName = "SearchDoc";
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("arh14"), (String)documentTypeName);
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        doc.route("routing");
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.setDateCreatedFrom(new DateTime(2004, 1, 1, 0, 0));
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("arh14");
        DocumentSearchResults results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((long)1L, (long)results.getSearchResults().size());
        this.loadXmlFile("testdoc1.xml");
        docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("arh14"), (String)documentTypeName);
        doc.route("routing");
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.setDateCreatedFrom(new DateTime(2004, 1, 1, 0, 0));
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((long)2L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.setDateCreatedFrom(new DateTime(2004, 1, 1, 0, 0));
        this.addSearchableAttribute(criteria, "MockSearchableAttributeKey", "MockSearchableAttributeValue");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.setDateCreatedFrom(new DateTime(2004, 1, 1, 0, 0));
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((long)2L, (long)results.getSearchResults().size());
    }

    @Test
    public void testWildcardsOnSearchableAttributes() throws Exception {
        String documentTypeName = "WildcardTestDocType";
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        String principalName = "rkirkend";
        String principalId = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(principalName).getPrincipalId();
        String[][] searchableAttributeValuesAsStrings = new String[][]{{"testString", "9984", "38.1357", "06/24/2009"}, {"anotherStr", "33", "80000.65432", "07/08/2010"}, {"MoreText", "432", "-0.765", "12/12/2012"}};
        for (int i = 0; i < searchableAttributeValuesAsStrings.length; ++i) {
            WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)principalId, (String)documentTypeName);
            WorkflowAttributeDefinition.Builder wcStringXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeWildcardString");
            wcStringXMLDef.addPropertyDefinition("xmlSearchableAttributeWildcardString", searchableAttributeValuesAsStrings[i][0]);
            workflowDocument.addSearchableDefinition(wcStringXMLDef.build());
            WorkflowAttributeDefinition.Builder wcLongXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeWildcardLong");
            wcLongXMLDef.addPropertyDefinition("xmlSearchableAttributeWildcardLong", searchableAttributeValuesAsStrings[i][1]);
            workflowDocument.addSearchableDefinition(wcLongXMLDef.build());
            WorkflowAttributeDefinition.Builder wcFloatXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeWildcardFloat");
            wcFloatXMLDef.addPropertyDefinition("xmlSearchableAttributeWildcardFloat", searchableAttributeValuesAsStrings[i][2]);
            workflowDocument.addSearchableDefinition(wcFloatXMLDef.build());
            WorkflowAttributeDefinition.Builder wcDatetimeXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeWildcardDatetime");
            wcDatetimeXMLDef.addPropertyDefinition("xmlSearchableAttributeWildcardDatetime", searchableAttributeValuesAsStrings[i][3]);
            workflowDocument.addSearchableDefinition(wcDatetimeXMLDef.build());
            workflowDocument.setTitle("Search Def Test Doc " + i);
            workflowDocument.route("routing search def doc " + i);
        }
        this.assertSearchableAttributeWildcardsWork(docType, principalId, "xmlSearchableAttributeWildcardString", new String[]{"TESTSTRING|moretext", "!MoreText", "!anotherStr!testString", "!anotherStr&&!MoreText", "!SomeString", "*str*", "More????", "*e*n?", "???String", "*te*&&!????String", "!test??????", "anotherStr..MoreText", "testString..MoreText", ">=testString", "<=anotherStr|>MoreText", "<=testString&&!anotherStr", ">=abc", "<=anotherOne&&>=text", ">=More????", "<=*test*"}, new int[]{2, 2, 1, 1, 3, 2, 1, 1, 0, 1, 2, 2, -1, 1, 2, 2, 3, 0, 2, 2});
        this.assertSearchableAttributeMultiplesWork(docType, principalId, "xmlSearchableAttributeWildcardString", new String[][]{{"testString"}, {"anotherStr"}, {"MoreText"}, {"testString", "anotherStr"}, {"testString", "MoreText"}, {"anotherStr", "MoreText"}, {"testString", "anotherStr", "MoreText"}, {"monkey"}, {"monkey", "giraffe"}, {"monkey", "testString"}}, new int[]{1, 1, 1, 2, 2, 2, 3, 0, 0, 1});
        this.assertSearchableAttributeWildcardsWork(docType, principalId, "xmlSearchableAttributeWildcardLong", new String[]{"99??", "*2", "!33", "<9984", ">=433", "<34", ">=432", ">=34&&<9984", "<100000&&>=20", ">=9984&&<33", "431..<9985", "9999..1", "<432|>432", ">=9000|<=100", "!", ">=-76"}, new int[]{-1, -1, 2, 2, 1, 1, 2, 1, 3, 0, 2, -1, 2, 2, -1, 3});
        this.assertSearchableAttributeMultiplesWork(docType, principalId, "xmlSearchableAttributeWildcardLong", new String[][]{{"9984"}, {"33"}, {"432"}, {"9984", "33"}, {"9984", "432"}, {"33", "432"}, {"9984", "33", "432"}, {"7"}, {"7", "4488"}, {"7", "9984"}}, new int[]{1, 1, 1, 2, 2, 2, 3, 0, 0, 1});
        this.assertSearchableAttributeWildcardsWork(docType, principalId, "xmlSearchableAttributeWildcardFloat", new String[]{"38.1???", "!-0.765", "*80*", "<80000.65432", ">=0", "<-0.763", ">=38.1357", "<38.1358", "<-0.5|>0.5", ">=-0.765&&<=-0.765", ">=38.1358&&<80000.65432", "-50..<50", "100..10", "<38.1358|>=38.1357", ">=123.4567|<0.11", "-1.1..<38.1357&&<3.3"}, new int[]{-1, 2, -1, 2, 2, 1, 2, 2, 3, 1, 0, 2, -1, 3, 2, 1});
        this.assertSearchableAttributeMultiplesWork(docType, principalId, "xmlSearchableAttributeWildcardFloat", new String[][]{{"38.1357"}, {"80000.65432"}, {"-0.765"}, {"38.1357", "80000.65432"}, {"38.1357", "-0.765"}, {"80000.65432", "-0.765"}, {"38.1357", "80000.65432", "-0.765"}, {"3.1415928"}, {"3.1415928", "4488.0"}, {"3.1415928", "38.1357"}}, new int[]{1, 1, 1, 2, 2, 2, 3, 0, 0, 1});
        this.assertSearchableAttributeWildcardsWork(docType, principalId, "xmlSearchableAttributeWildcardDatetime", new String[]{"??/??/20??", "12/12/20*", "!07/08/2010", ">=06/25/2009", "<07/08/2010", ">=12/12/2012", "<05/06/2011", ">=06/25/2009&&<07/09/2010", ">=01/01/2001&&<06/24/2009", "11/29/1990..<12/31/2009", "12/13/2100..<08/09/1997", "<06/24/2009|>=12/12/2012", "<06/25/2009|>=07/09/2010", ">02/31/2011"}, new int[]{-1, -1, 2, 2, 1, 1, 2, 1, 0, 1, -1, 1, 2, -1});
        this.assertSearchableAttributeMultiplesWork(docType, principalId, "xmlSearchableAttributeWildcardDatetime", new String[][]{{"06/24/2009"}, {"07/08/2010"}, {"12/12/2012"}, {"06/24/2009", "07/08/2010"}, {"06/24/2009", "12/12/2012"}, {"07/08/2010", "12/12/2012"}, {"06/24/2009", "07/08/2010", "12/12/2012"}, {"12/20/2012"}, {"12/20/2012", "11/09/2009"}, {"12/20/2012", "12/12/2012"}}, new int[]{1, 1, 1, 2, 2, 2, 3, 0, 0, 1});
    }

    private void assertSearchableAttributeWildcardsWork(DocumentType docType, String principalId, String fieldDefKey, String[] searchValues, int[] resultSizes) throws Exception {
        DocumentSearchCriteria.Builder criteria = null;
        DocumentSearchResults results = null;
        DocumentSearchService docSearchService = KEWServiceLocator.getDocumentSearchService();
        for (int i = 0; i < resultSizes.length; ++i) {
            block5: {
                criteria = DocumentSearchCriteria.Builder.create();
                criteria.setDocumentTypeName(docType.getName());
                this.addSearchableAttribute(criteria, fieldDefKey, searchValues[i]);
                try {
                    results = docSearchService.lookupDocuments(principalId, criteria.build());
                    if (resultSizes[i] < 0) {
                        Assert.fail((String)(fieldDefKey + "'s search at loop index " + i + " should have thrown an exception"));
                    }
                    if (resultSizes[i] != results.getSearchResults().size()) {
                        Assert.assertEquals((String)(fieldDefKey + "'s search results at loop index " + i + " returned the wrong number of documents."), (long)resultSizes[i], (long)results.getSearchResults().size());
                    }
                }
                catch (Exception ex) {
                    if (resultSizes[i] < 0) break block5;
                    ex.printStackTrace();
                    Assert.fail((String)(fieldDefKey + "'s search at loop index " + i + " should not have thrown an exception"));
                }
            }
            GlobalVariables.clear();
        }
    }

    private void assertSearchableAttributeMultiplesWork(DocumentType docType, String principalId, String fieldDefKey, String[][] searchValues, int[] resultSizes) throws Exception {
        DocumentSearchCriteria.Builder criteria = null;
        DocumentSearchResults results = null;
        DocumentSearchService docSearchService = KEWServiceLocator.getDocumentSearchService();
        for (int i = 0; i < resultSizes.length; ++i) {
            block5: {
                criteria = DocumentSearchCriteria.Builder.create();
                criteria.setDocumentTypeName(docType.getName());
                this.addSearchableAttribute(criteria, fieldDefKey, searchValues[i]);
                try {
                    results = docSearchService.lookupDocuments(principalId, criteria.build());
                    if (resultSizes[i] < 0) {
                        Assert.fail((String)(fieldDefKey + "'s search at loop index " + i + " should have thrown an exception"));
                    }
                    if (resultSizes[i] != results.getSearchResults().size()) {
                        Assert.assertEquals((String)(fieldDefKey + "'s search results at loop index " + i + " returned the wrong number of documents."), (long)resultSizes[i], (long)results.getSearchResults().size());
                    }
                }
                catch (Exception ex) {
                    if (resultSizes[i] < 0) break block5;
                    Assert.fail((String)(fieldDefKey + "'s search at loop index " + i + " should not have thrown an exception"));
                }
            }
            GlobalVariables.clear();
        }
    }

    @Test
    public void testValidateUserSearchInputsNoCast() {
        StandardGenericXMLSearchableAttribute searchableAttribute = new StandardGenericXMLSearchableAttribute();
        ExtensionDefinition extensionDefinition = KewApiServiceLocator.getExtensionRepositoryService().getExtensionByName("SearchableAttributeVisible");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        HashMap<String, List<String>> simpleParamMap = new HashMap<String, List<String>>();
        simpleParamMap.put("givenname", Collections.singletonList("test"));
        criteria.setDocumentAttributeValues(simpleParamMap);
        List errors = new ArrayList();
        RuntimeException caughtException = null;
        try {
            errors = searchableAttribute.validateDocumentAttributeCriteria(extensionDefinition, criteria.build());
        }
        catch (RuntimeException re) {
            caughtException = re;
        }
        Assert.assertNull((String)("Found exception " + caughtException), (Object)caughtException);
        Assert.assertTrue((String)("Found errors " + errors), (errors.size() == 0 ? 1 : 0) != 0);
        HashMap listParamMap = new HashMap();
        ArrayList<String> multipleValues = new ArrayList<String>();
        multipleValues.add("testone");
        multipleValues.add("testtwo");
        listParamMap.put("givenname", multipleValues);
        criteria.setDocumentAttributeValues(listParamMap);
        errors = new ArrayList();
        caughtException = null;
        try {
            errors = searchableAttribute.validateDocumentAttributeCriteria(extensionDefinition, criteria.build());
        }
        catch (RuntimeException re) {
            caughtException = re;
        }
        Assert.assertNull((String)("Found exception " + caughtException), (Object)caughtException);
        Assert.assertTrue((String)("Found errors " + errors), (errors.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSearchableAttributeTrim() {
        RuleAttribute trimAttribute = KEWServiceLocator.getRuleAttributeService().findByName("TrimSearchableAttribute");
        assert (trimAttribute.getName().equals("TrimSearchableAttribute"));
        assert (trimAttribute.getResourceDescriptor().equals("org.kuali.rice.kew.docsearch.xml.StandardGenericXMLSearchableAttribute"));
        assert (trimAttribute.getLabel().equals("Unit111"));
        assert (trimAttribute.getType().equals("SearchableXmlAttribute"));
        assert (trimAttribute.getDescription().equals("Unit111"));
        assert (trimAttribute.getApplicationId().equals("NSTrimSearchableTest"));
    }

    @Test
    public void testXmlGeneration() {
        this.loadXmlFile("testdoc1.xml");
        WorkflowAttributeDefinition searchableDefinition = WorkflowAttributeDefinition.Builder.create((String)"SearchAttribute").build();
        DocumentContentUpdate.Builder documentContentUpdateBuilder = DocumentContentUpdate.Builder.create();
        documentContentUpdateBuilder.getSearchableDefinitions().add(searchableDefinition);
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId("ewestfal"), (String)"SearchDoc", null, (DocumentContentUpdate)documentContentUpdateBuilder.build());
        workflowDocument.route("");
        Assert.assertTrue((boolean)workflowDocument.isFinal());
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)"<searchableContent><mockContent>MockSearchableAttribute Search Content</mockContent></searchableContent>"), (Object)StringUtils.deleteWhitespace((String)workflowDocument.getDocumentContent().getSearchableContent()));
    }

    @Test
    public void testAttributeRangeFieldGeneration() {
        String documentTypeName = "SearchDocType";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        String userNetworkId = "rkirkend";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.setDateApprovedFrom(new DateTime(2010, 1, 1, 0, 0));
        criteria.setDateApprovedTo(new DateTime(2011, 1, 1, 0, 0));
        String fieldValue = ">= " + DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)new Timestamp(TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE_IN_MILLS));
        this.addSearchableAttribute(criteria, "testDateTimeKey", fieldValue);
        Map fields = new DocumentSearchCriteriaTranslatorImpl().translateCriteriaToFields(criteria.build());
        System.err.println(fields);
        String lowerBoundField = "documentAttribute.rangeLowerBoundKeyPrefix_testDateTimeKey";
        String upperBoundField = "documentAttribute.testDateTimeKey";
        Assert.assertNotNull(fields.get(lowerBoundField));
        Assert.assertNotNull(fields.get(upperBoundField));
        Assert.assertNotNull((Object)((String[])fields.get(lowerBoundField))[0]);
        Assert.assertNull((Object)((String[])fields.get(upperBoundField))[0]);
        Assert.assertEquals((Object)DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)new Timestamp(new DateTime(2007, 3, 15, 0, 0).toDateTime().getMillis())), (Object)((String[])fields.get(lowerBoundField))[0]);
    }
}

