/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch.xml;

import com.google.common.base.Function;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SQLUtils;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.docsearch.DocumentSearchInternalUtils;
import org.kuali.rice.kew.docsearch.DocumentSearchTestBase;
import org.kuali.rice.kew.docsearch.SearchableAttributeDateTimeValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeFloatValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeLongValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeStringValue;
import org.kuali.rice.kew.docsearch.TestXMLSearchableAttributeDateTime;
import org.kuali.rice.kew.docsearch.TestXMLSearchableAttributeFloat;
import org.kuali.rice.kew.docsearch.TestXMLSearchableAttributeLong;
import org.kuali.rice.kew.docsearch.service.DocumentSearchService;
import org.kuali.rice.kew.docsearch.xml.StandardGenericXMLSearchableAttribute;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;

public class StandardGenericXMLSearchableAttributeRangesTest
extends DocumentSearchTestBase {
    private DocumentSearchService docSearchService;
    private static final int EXPECT_EXCEPTION = -1;

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("XmlConfig.xml");
    }

    @Before
    public void retrieveDocSearchSvc() {
        this.docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
    }

    @Test
    public void testGetSearchingRowsUsingRangeSearches() {
        Field field;
        Field field2;
        Row row;
        int i;
        StandardGenericXMLSearchableAttribute searchAttribute = this.getAttribute("XMLSearchableAttributeStringRange");
        ExtensionDefinition ed = StandardGenericXMLSearchableAttributeRangesTest.createExtensionDefinition("XMLSearchableAttributeStringRange");
        String documentTypeName = "SearchDocType";
        List remotableAttributeFields = searchAttribute.getSearchFields(ed, documentTypeName);
        List rows = FieldUtils.convertRemotableAttributeFields((List)remotableAttributeFields);
        if (new SearchableAttributeStringValue().allowsRangeSearches()) {
            Assert.assertEquals((String)"Invalid number of search rows", (long)2L, (long)rows.size());
            for (i = 1; i <= rows.size(); ++i) {
                row = (Row)rows.get(i - 1);
                Assert.assertEquals((String)("Invalid number of fields for search row " + i), (long)1L, (long)row.getFields().size());
                field2 = row.getField(0);
                Assert.assertTrue((String)"Field should be the member of a range", (boolean)field2.isMemberOfRange());
                if (i == 1) {
                    Assert.assertTrue((String)"Field should be inclusive", (boolean)field2.isInclusive());
                } else {
                    Assert.assertFalse((String)"Field should not be inclusive", (boolean)field2.isInclusive());
                }
                Assert.assertFalse((String)"Field should not be using datepicker", (boolean)field2.isDatePicker());
            }
        } else {
            Assert.assertEquals((String)"Invalid number of search rows", (long)1L, (long)remotableAttributeFields.size());
            Row row2 = (Row)rows.get(0);
            Assert.assertEquals((String)"Invalid number of fields for search row", (long)1L, (long)row2.getFields().size());
            Assert.assertFalse((String)"Field is the member of a range when ranges are not allowed", (boolean)row2.getField(0).isMemberOfRange());
        }
        searchAttribute = this.getAttribute("XMLSearchableAttributeStdLongRange");
        ed = StandardGenericXMLSearchableAttributeRangesTest.createExtensionDefinition("XMLSearchableAttributeStdLongRange");
        remotableAttributeFields = searchAttribute.getSearchFields(ed, documentTypeName);
        rows = FieldUtils.convertRemotableAttributeFields((List)remotableAttributeFields);
        if (new SearchableAttributeLongValue().allowsRangeSearches()) {
            Assert.assertEquals((String)"Invalid number of search rows", (long)2L, (long)rows.size());
            for (i = 1; i <= rows.size(); ++i) {
                row = (Row)rows.get(i - 1);
                Assert.assertEquals((String)("Invalid number of fields for search row " + i), (long)1L, (long)row.getFields().size());
                field2 = row.getField(0);
                Assert.assertTrue((String)"Field should be the member of a range", (boolean)field2.isMemberOfRange());
                if (i == 1) {
                    Assert.assertTrue((String)"Field should be inclusive", (boolean)field2.isInclusive());
                } else {
                    Assert.assertFalse((String)"Field should not be inclusive", (boolean)field2.isInclusive());
                }
                Assert.assertFalse((String)"Field should not be using datepicker", (boolean)field2.isDatePicker());
            }
        } else {
            Assert.assertEquals((String)"Invalid number of search rows", (long)1L, (long)rows.size());
            Row row3 = (Row)rows.get(0);
            Assert.assertEquals((String)"Invalid number of fields for search row", (long)1L, (long)row3.getFields().size());
            field = row3.getField(0);
            Assert.assertFalse((String)"Field is the member of a range when ranges are not allowed", (boolean)field.isMemberOfRange());
            Assert.assertFalse((String)"Field is inclusive when ranges are not allowed", (boolean)field.isInclusive());
            Assert.assertFalse((String)"Field should not be using datepicker", (boolean)field.isDatePicker());
        }
        searchAttribute = this.getAttribute("XMLSearchableAttributeStdFloatRange");
        ed = StandardGenericXMLSearchableAttributeRangesTest.createExtensionDefinition("XMLSearchableAttributeStdFloatRange");
        remotableAttributeFields = searchAttribute.getSearchFields(ed, documentTypeName);
        rows = FieldUtils.convertRemotableAttributeFields((List)remotableAttributeFields);
        if (new SearchableAttributeFloatValue().allowsRangeSearches()) {
            Assert.assertEquals((String)"Invalid number of search rows", (long)2L, (long)rows.size());
            for (int i2 = 1; i2 <= rows.size(); ++i2) {
                row = (Row)rows.get(i2 - 1);
                Assert.assertEquals((String)("Invalid number of fields for search row " + i2), (long)1L, (long)row.getFields().size());
                field2 = row.getField(0);
                Assert.assertTrue((String)"Upper and Lower Fields should be members of a range", (boolean)field2.isMemberOfRange());
                Assert.assertFalse((String)"Upper and Lower Fields should not be inclusive", (boolean)field2.isInclusive());
                String labelValue = null;
                labelValue = field2.getPropertyName().startsWith("rangeLowerBoundKeyPrefix_") ? "starting" : "ending";
                Assert.assertEquals((String)"Field label is incorrect.", (Object)labelValue, (Object)field2.getFieldLabel());
                Assert.assertFalse((String)"Field should not be using datepicker", (boolean)field2.isDatePicker());
            }
        } else {
            Assert.assertEquals((String)"Invalid number of search rows", (long)1L, (long)rows.size());
            Row row4 = (Row)rows.get(0);
            Assert.assertEquals((String)"Invalid number of fields for search row", (long)1L, (long)row4.getFields().size());
            field = row4.getField(0);
            Assert.assertFalse((String)"Field is the member of a range when ranges are not allowed", (boolean)field.isMemberOfRange());
            Assert.assertFalse((String)"Field should not be using datepicker", (boolean)field.isDatePicker());
        }
        searchAttribute = this.getAttribute("XMLSearchableAttributeStdDateTimeRange");
        ed = StandardGenericXMLSearchableAttributeRangesTest.createExtensionDefinition("XMLSearchableAttributeStdDateTimeRange");
        remotableAttributeFields = searchAttribute.getSearchFields(ed, documentTypeName);
        Assert.assertFalse((boolean)((RemotableAttributeField)remotableAttributeFields.get(0)).getAttributeLookupSettings().isLowerDatePicker());
        Assert.assertTrue((boolean)((RemotableAttributeField)remotableAttributeFields.get(0)).getAttributeLookupSettings().isUpperDatePicker());
        rows = FieldUtils.convertRemotableAttributeFields((List)remotableAttributeFields);
        if (new SearchableAttributeDateTimeValue().allowsRangeSearches()) {
            Assert.assertEquals((String)"Invalid number of search rows", (long)2L, (long)rows.size());
            for (int i3 = 0; i3 < rows.size(); ++i3) {
                row = (Row)rows.get(i3);
                Assert.assertTrue((String)"Invalid number of fields for search row", (row.getFields().size() == 1 ? 1 : 0) != 0);
                field2 = row.getField(0);
                Assert.assertTrue((String)"Field should be the member of a range search", (boolean)field2.isRanged());
                Assert.assertTrue((String)"Field should be using datepicker field", (boolean)field2.isDatePicker());
                if (field2.getPropertyName().startsWith("rangeLowerBoundKeyPrefix_")) {
                    Assert.assertFalse((String)"Lower Field should not be inclusive", (boolean)field2.isInclusive());
                    continue;
                }
                Assert.assertTrue((String)"Upper Field should be inclusive", (boolean)field2.isInclusive());
                Assert.assertEquals((String)"Field in row should be of data type date", (Object)DataType.DATE.toString().toLowerCase(), (Object)field2.getFieldDataType());
            }
        } else {
            Assert.assertEquals((String)"Invalid number of search rows", (long)1L, (long)rows.size());
            Row row5 = (Row)rows.get(0);
            Assert.assertEquals((String)"Invalid number of fields", (long)1L, (long)row5.getFields().size());
            Assert.assertFalse((String)"Field is the member of a range when ranges are not allowed", (boolean)row5.getField(0).isMemberOfRange());
        }
    }

    @Test
    public void testValidateUserSearchRangeInputs() {
        StandardGenericXMLSearchableAttribute searchAttribute = this.getAttribute("XMLSearchableAttributeStringRange");
        ExtensionDefinition ed = StandardGenericXMLSearchableAttributeRangesTest.createExtensionDefinition("XMLSearchableAttributeStringRange");
        RemotableAttributeError error = this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "givenname", ">= jack", null);
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "givenname", "<= jack.jack", "differ on upper bound inclusivity");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "givenname", "< jack.jack", "Invalid first name");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "givenname", ">= jack*jack", null);
        searchAttribute = this.getAttribute("XMLSearchableAttributeStdLongRange");
        ed = StandardGenericXMLSearchableAttributeRangesTest.createExtensionDefinition("XMLSearchableAttributeStdLongRange");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testLongKey", "<= " + TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString(), "differ on upper bound inclusivity");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testLongKey", "< " + TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString(), null);
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testLongKey", ">= " + TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString() + ".33", "does not conform to standard validation for field type.");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testLongKey", "<= jack*jack", "differ on upper bound inclusivity");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testLongKey", "< jack*jack", "does not conform to standard validation for field type.");
        searchAttribute = this.getAttribute("XMLSearchableAttributeStdFloatRange");
        ed = StandardGenericXMLSearchableAttributeRangesTest.createExtensionDefinition("XMLSearchableAttributeStdFloatRange");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testFloatKey", ">= " + TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString(), "differ on lower bound inclusivity");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testFloatKey", "> " + TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString(), null);
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testFloatKey", "<= " + TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString() + "a", "differ on upper bound inclusivity");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testFloatKey", "< " + TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString() + "a", "does not conform to standard validation for field type.");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testFloatKey", ">= " + TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString() + "*", "differ on lower bound inclusivity");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testFloatKey", "> " + TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString() + "*", "does not conform to standard validation for field type.");
        searchAttribute = this.getAttribute("XMLSearchableAttributeStdDateTimeRange");
        ed = StandardGenericXMLSearchableAttributeRangesTest.createExtensionDefinition("XMLSearchableAttributeStdDateTimeRange");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testDateTimeKey", "<= " + DocumentSearchInternalUtils.getDisplayValueWithDateOnly((DateTime)TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE), null);
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testDateTimeKey", ">= 001/5/08", "differ on lower bound inclusivity");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testDateTimeKey", "> 001/5/08", null);
        error = this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testDateTimeKey", ">= 41/5/08", "differ on lower bound inclusivity");
        error = this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testDateTimeKey", "> 41/5/08", "does not conform to standard validation for field type.");
        error = this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testDateTimeKey", "<= 01/02/20*", "does not conform to standard validation for field type.");
    }

    protected RemotableAttributeError assertDocumentSearchCriteriaValidation(StandardGenericXMLSearchableAttribute attribute, ExtensionDefinition ed, String attrkey, String attrvalue, String expectedErrorMessage) {
        DocumentSearchCriteria.Builder dscb = DocumentSearchCriteria.Builder.create();
        dscb.addDocumentAttributeValue(attrkey, attrvalue);
        List errors = attribute.validateDocumentAttributeCriteria(ed, dscb.build());
        if (expectedErrorMessage != null) {
            Assert.assertEquals((String)"Validation should return a single error message.", (long)1L, (long)errors.size());
            if (StringUtils.isNotEmpty((String)expectedErrorMessage)) {
                Assert.assertTrue((String)"Validation error is incorrect", (boolean)((RemotableAttributeError)errors.get(0)).getMessage().contains(expectedErrorMessage));
            }
            return (RemotableAttributeError)errors.get(0);
        }
        Assert.assertEquals((String)"Validation should not have returned an error.", (long)0L, (long)errors.size());
        return null;
    }

    protected WorkflowDocument setUpSearchableDoc() {
        String documentTypeName = "SearchDocTypeRangeSearchDataType";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        String userNetworkId = "rkirkend";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(userNetworkId), (String)documentTypeName);
        WorkflowAttributeDefinition.Builder stringXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeStringRange");
        stringXMLDef.addPropertyDefinition("givenname", "jack");
        workflowDocument.addSearchableDefinition(stringXMLDef.build());
        WorkflowAttributeDefinition.Builder longXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeStdLongRangeInclusive");
        longXMLDef.addPropertyDefinition("testLongKey", TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString());
        workflowDocument.addSearchableDefinition(longXMLDef.build());
        WorkflowAttributeDefinition.Builder floatXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeStdFloatRangeInclusive");
        floatXMLDef.addPropertyDefinition("testFloatKey", TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString());
        workflowDocument.addSearchableDefinition(floatXMLDef.build());
        WorkflowAttributeDefinition.Builder dateXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeStdDateTimeRangeInclusive");
        dateXMLDef.addPropertyDefinition("testDateTimeKey", DocumentSearchInternalUtils.getDisplayValueWithDateOnly((DateTime)TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE));
        workflowDocument.addSearchableDefinition(dateXMLDef.build());
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        return WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(userNetworkId), (String)workflowDocument.getDocumentId());
    }

    protected void assertRangeSearchResults(String docType, String userId, String attrKey, String lowerBound, String upperBound, boolean upperBoundInclusive, int expected) throws WorkflowServiceErrorException {
        DocumentSearchResults results;
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(docType);
        this.addSearchableAttribute(criteria, attrKey, this.createSearchableAttributeRange(lowerBound, upperBound, upperBoundInclusive));
        try {
            results = this.docSearchService.lookupDocuments(userId, criteria.build());
            if (expected == -1) {
                Assert.fail((String)"Error should have been thrown for invalid range");
            }
        }
        catch (WorkflowServiceErrorException e) {
            if (expected == -1) {
                return;
            }
            throw e;
        }
        Assert.assertEquals((String)("Search results should have " + expected + " document(s)."), (long)expected, (long)results.getSearchResults().size());
    }

    @Test
    public void testStringRanges() throws Exception {
        WorkflowDocument doc = this.setUpSearchableDoc();
        String userId = doc.getInitiatorPrincipalId();
        String docType = doc.getDocumentTypeName();
        this.assertRangeSearchResults(docType, userId, "givenname", "jack", null, false, 1);
    }

    @Test
    public void testLongRanges() throws Exception {
        WorkflowDocument doc = this.setUpSearchableDoc();
        String userId = doc.getInitiatorPrincipalId();
        String docType = doc.getDocumentTypeName();
        String searchAttributeLongKey = "testLongKey";
        Long searchAttributeLongValue = TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.longValue();
        Long longValueToUse = null;
        longValueToUse = searchAttributeLongValue;
        this.assertRangeSearchResults(docType, userId, searchAttributeLongKey, longValueToUse.toString(), null, false, 1);
        longValueToUse = searchAttributeLongValue - 1L;
        this.assertRangeSearchResults(docType, userId, searchAttributeLongKey, longValueToUse.toString(), null, false, 1);
        longValueToUse = searchAttributeLongValue + 1L;
        this.assertRangeSearchResults(docType, userId, searchAttributeLongKey, longValueToUse.toString(), null, false, 0);
        longValueToUse = searchAttributeLongValue;
        this.assertRangeSearchResults(docType, userId, searchAttributeLongKey, null, longValueToUse.toString(), true, 1);
        longValueToUse = searchAttributeLongValue - 1L;
        this.assertRangeSearchResults(docType, userId, searchAttributeLongKey, null, longValueToUse.toString(), true, 0);
        longValueToUse = searchAttributeLongValue + 1L;
        this.assertRangeSearchResults(docType, userId, searchAttributeLongKey, null, longValueToUse.toString(), true, 1);
        this.assertRangeSearchResults(docType, userId, searchAttributeLongKey, Long.valueOf(searchAttributeLongValue).toString(), Long.valueOf(searchAttributeLongValue).toString(), true, 1);
        this.assertRangeSearchResults(docType, userId, searchAttributeLongKey, Long.valueOf(searchAttributeLongValue + 2L).toString(), Long.valueOf(searchAttributeLongValue + 4L).toString(), true, 0);
        this.assertRangeSearchResults(docType, userId, searchAttributeLongKey, Long.valueOf(searchAttributeLongValue - 2L).toString(), Long.valueOf(searchAttributeLongValue - 4L).toString(), true, -1);
        this.assertRangeSearchResults(docType, userId, searchAttributeLongKey, Long.valueOf(searchAttributeLongValue - 4L).toString(), Long.valueOf(searchAttributeLongValue - 2L).toString(), true, 0);
        this.assertRangeSearchResults(docType, userId, searchAttributeLongKey, Long.valueOf(searchAttributeLongValue - 2L).toString(), Long.valueOf(searchAttributeLongValue + 2L).toString(), true, 1);
        this.assertRangeSearchResults(docType, userId, searchAttributeLongKey, Long.valueOf(searchAttributeLongValue + 2L).toString(), Long.valueOf(searchAttributeLongValue - 2L).toString(), true, -1);
    }

    @Test
    public void testFloatRanges() throws Exception {
        WorkflowDocument doc = this.setUpSearchableDoc();
        String userId = doc.getInitiatorPrincipalId();
        String docType = doc.getDocumentTypeName();
        String searchAttributeFloatKey = "testFloatKey";
        BigDecimal searchAttributeFloatValue = TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE;
        BigDecimal floatValueToUse = null;
        floatValueToUse = searchAttributeFloatValue;
        this.assertRangeSearchResults(docType, userId, searchAttributeFloatKey, floatValueToUse.toString(), null, false, 1);
        floatValueToUse = searchAttributeFloatValue.subtract(BigDecimal.ONE);
        this.assertRangeSearchResults(docType, userId, searchAttributeFloatKey, floatValueToUse.toString(), null, false, 1);
        floatValueToUse = searchAttributeFloatValue.add(BigDecimal.ONE);
        this.assertRangeSearchResults(docType, userId, searchAttributeFloatKey, floatValueToUse.toString(), null, false, 0);
        floatValueToUse = searchAttributeFloatValue;
        this.assertRangeSearchResults(docType, userId, searchAttributeFloatKey, null, floatValueToUse.toString(), true, 1);
        floatValueToUse = searchAttributeFloatValue.subtract(BigDecimal.ONE);
        this.assertRangeSearchResults(docType, userId, searchAttributeFloatKey, null, floatValueToUse.toString(), true, 0);
        floatValueToUse = searchAttributeFloatValue.add(BigDecimal.ONE);
        this.assertRangeSearchResults(docType, userId, searchAttributeFloatKey, null, floatValueToUse.toString(), true, 1);
        this.assertRangeSearchResults(docType, userId, searchAttributeFloatKey, searchAttributeFloatValue.toString(), searchAttributeFloatValue.toString(), true, 1);
        this.assertRangeSearchResults(docType, userId, searchAttributeFloatKey, searchAttributeFloatValue.add(new BigDecimal(2)).toString(), searchAttributeFloatValue.add(new BigDecimal(4)).toString(), true, 0);
        this.assertRangeSearchResults(docType, userId, searchAttributeFloatKey, searchAttributeFloatValue.subtract(new BigDecimal(4)).toString(), searchAttributeFloatValue.subtract(new BigDecimal(2)).toString(), true, 0);
        this.assertRangeSearchResults(docType, userId, searchAttributeFloatKey, searchAttributeFloatValue.subtract(new BigDecimal(2)).toString(), searchAttributeFloatValue.add(new BigDecimal(2)).toString(), true, 1);
        this.assertRangeSearchResults(docType, userId, searchAttributeFloatKey, searchAttributeFloatValue.add(new BigDecimal(2)).toString(), searchAttributeFloatValue.subtract(new BigDecimal(2)).toString(), true, -1);
    }

    @Test
    public void testDateRanges() throws Exception {
        WorkflowDocument doc = this.setUpSearchableDoc();
        String userId = doc.getInitiatorPrincipalId();
        String docType = doc.getDocumentTypeName();
        String searchAttributeDateTimeKey = "testDateTimeKey";
        GregorianCalendar searchAttributeDateTimeValue = TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE.toGregorianCalendar();
        Calendar calendarValueToUse = null;
        calendarValueToUse = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        String valueToSearch = DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)calendarValueToUse));
        this.assertRangeSearchResults(docType, userId, searchAttributeDateTimeKey, valueToSearch, null, false, 1);
        calendarValueToUse = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        calendarValueToUse.add(5, -1);
        valueToSearch = DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)calendarValueToUse));
        this.assertRangeSearchResults(docType, userId, searchAttributeDateTimeKey, valueToSearch, null, false, 1);
        calendarValueToUse = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        calendarValueToUse.add(5, 1);
        valueToSearch = DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)calendarValueToUse));
        this.assertRangeSearchResults(docType, userId, searchAttributeDateTimeKey, valueToSearch, null, false, 0);
        calendarValueToUse = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        this.assertRangeSearchResults(docType, userId, searchAttributeDateTimeKey, null, DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)calendarValueToUse)), true, 1);
        calendarValueToUse = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        calendarValueToUse.add(5, -1);
        this.assertRangeSearchResults(docType, userId, searchAttributeDateTimeKey, null, DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)calendarValueToUse)), true, 0);
        calendarValueToUse = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        calendarValueToUse.add(5, 1);
        this.assertRangeSearchResults(docType, userId, searchAttributeDateTimeKey, null, DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)calendarValueToUse)), true, 1);
        Calendar lowerBoundValue = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        Calendar upperBoundValue = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        this.assertRangeSearchResults(docType, userId, searchAttributeDateTimeKey, DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)lowerBoundValue)), DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)upperBoundValue)), true, 1);
        lowerBoundValue = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        lowerBoundValue.add(5, 2);
        upperBoundValue = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        upperBoundValue.add(5, 4);
        this.assertRangeSearchResults(docType, userId, searchAttributeDateTimeKey, DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)lowerBoundValue)), DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)upperBoundValue)), true, 0);
        lowerBoundValue = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        lowerBoundValue.add(5, -4);
        upperBoundValue = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        upperBoundValue.add(5, -2);
        this.assertRangeSearchResults(docType, userId, searchAttributeDateTimeKey, DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)lowerBoundValue)), DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)upperBoundValue)), true, 0);
        lowerBoundValue = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        lowerBoundValue.add(5, -2);
        upperBoundValue = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        upperBoundValue.add(5, 2);
        this.assertRangeSearchResults(docType, userId, searchAttributeDateTimeKey, DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)lowerBoundValue)), DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)upperBoundValue)), true, 1);
        lowerBoundValue = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        lowerBoundValue.add(5, 2);
        upperBoundValue = (Calendar)((Calendar)searchAttributeDateTimeValue).clone();
        upperBoundValue.add(5, -2);
        this.assertRangeSearchResults(docType, userId, searchAttributeDateTimeKey, DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)lowerBoundValue)), DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)SQLUtils.convertCalendar((Calendar)upperBoundValue)), true, -1);
    }

    @Test
    public void testRangeDefinitionStringAttributes() throws Exception {
        String documentTypeName = "RangeDefinitionTestDocType";
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        String principalName = "rkirkend";
        String principalId = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(principalName).getPrincipalId();
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)principalId, (String)documentTypeName);
        WorkflowAttributeDefinition.Builder inclusiveLowerXMLDef = WorkflowAttributeDefinition.Builder.create((String)"TextFieldWithInclusiveLower");
        inclusiveLowerXMLDef.addPropertyDefinition("textFieldWithInclusiveLower", "newvalue");
        workflowDocument.addSearchableDefinition(inclusiveLowerXMLDef.build());
        WorkflowAttributeDefinition.Builder caseSensitiveXMLDef = WorkflowAttributeDefinition.Builder.create((String)"TextFieldWithCaseSensitivity");
        caseSensitiveXMLDef.addPropertyDefinition("textFieldWithCaseSensitivity", "thevalue");
        workflowDocument.addSearchableDefinition(caseSensitiveXMLDef.build());
        WorkflowAttributeDefinition.Builder overridesXMLDef = WorkflowAttributeDefinition.Builder.create((String)"TextFieldWithOverrides");
        overridesXMLDef.addPropertyDefinition("textFieldWithOverrides", "SomeVal");
        workflowDocument.addSearchableDefinition(overridesXMLDef.build());
        workflowDocument.setTitle("Range Def Test");
        workflowDocument.route("routing range def doc.");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)principalId, (String)workflowDocument.getDocumentId());
        this.assertSearchBehavesAsExpected(docType, principalId, "textFieldWithInclusiveLower", new String[]{"newvalue", "", "", "NEWVALUD", "newValuf", "newValuj", "newvaluf"}, new String[]{"", "newvalue", "Newvaluf", "NEWVALUF", "newValud", "NEWVALUK", ""}, new int[]{1, 1, 1, 1, -1, 0, 0});
        this.assertSearchBehavesAsExpected(docType, principalId, "textFieldWithCaseSensitivity", new String[]{"thevalue", "", "", "THEVALUD", "thevalud", "Thevalud", "THEVALUF"}, new String[]{"", "thevalue", "Thevalue", "THEVALUF", "THEVALUF", "Thevaluf", ""}, new int[]{1, 1, 0, 0, -1, 0, 1});
        this.assertSearchBehavesAsExpected(docType, principalId, "textFieldWithOverrides", new String[]{"> someval", "> SomeVal", "<= SOMEVAL", "<= SomeVal", "SOMEVAK>..SomeVam", "SomeVam>..SOMEVAK", "SOMEVAM>..SomeVak", "> somevak", "<= SomeVak"}, new int[]{0, 0, 1, 1, 1, -1, -1, 1, 0});
    }

    private void assertSearchBehavesAsExpected(DocumentType docType, String principalId, String fieldDefKey, final String[] lowBounds, final String[] upBounds, int[] resultSizes) throws Exception {
        this.assertSearchResults(KEWServiceLocator.getDocumentSearchService(), docType, principalId, fieldDefKey, resultSizes, new Function<Integer, String>(){

            public String apply(@Nullable Integer index) {
                return StandardGenericXMLSearchableAttributeRangesTest.this.createSearchableAttributeRange(lowBounds[index], upBounds[index], true);
            }
        });
    }

    private void assertSearchBehavesAsExpected(DocumentType docType, String principalId, String fieldDefKey, final String[] expr, int[] resultSizes) throws Exception {
        this.assertSearchResults(KEWServiceLocator.getDocumentSearchService(), docType, principalId, fieldDefKey, resultSizes, new Function<Integer, String>(){

            public String apply(@Nullable Integer index) {
                return expr[index];
            }
        });
    }

    private void assertSearchResults(DocumentSearchService docSearchService, DocumentType docType, String principalId, String fieldDefKey, int[] resultSizes, Function<Integer, String> closure) {
        DocumentSearchCriteria.Builder criteria = null;
        DocumentSearchResults results = null;
        for (int i = 0; i < resultSizes.length; ++i) {
            criteria = DocumentSearchCriteria.Builder.create();
            criteria.setDocumentTypeName(docType.getName());
            this.addSearchableAttribute(criteria, fieldDefKey, (String)closure.apply((Object)i));
            try {
                results = docSearchService.lookupDocuments(principalId, criteria.build());
                if (resultSizes[i] < 0) {
                    Assert.fail((String)(fieldDefKey + "'s search at loop index " + i + " should have thrown an exception"));
                }
                Assert.assertEquals((String)(fieldDefKey + "'s search results at loop index " + i + " returned the wrong number of documents."), (long)resultSizes[i], (long)results.getSearchResults().size());
                continue;
            }
            catch (Exception ex) {
                if (resultSizes[i] < 0) continue;
                Assert.fail((String)(fieldDefKey + "'s search at loop index " + i + " should not have thrown an exception"));
            }
        }
    }
}

