/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypePermissionService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class DocumentTypePermissionServiceTest
extends KEWTestCase {
    private DocumentTypePermissionService service;

    public void setUpInternal() throws Exception {
        super.setUpInternal();
        this.service = KEWServiceLocator.getDocumentTypePermissionService();
    }

    @Test
    public void canBlanketApprove() throws Exception {
        DocumentType testDocType = KEWServiceLocator.getDocumentTypeService().findByName("TestDocumentType");
        Principal ewestfalPrincipal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("ewestfal");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)ewestfalPrincipal.getPrincipalId(), (String)"TestDocumentType");
        document.route("routing test doc");
        Assert.assertNotNull((Object)testDocType);
        Assert.assertTrue((String)"ewestfal should be a blanket approver", (boolean)this.service.canBlanketApprove(ewestfalPrincipal.getPrincipalId(), KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId())));
    }

    @Test
    public void testCanInitiate() throws Exception {
        DocumentType testDocType = KEWServiceLocator.getDocumentTypeService().findByName("TestDocumentType");
        Principal ewestfalPrincipal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("ewestfal");
        Assert.assertNotNull((Object)testDocType);
        Assert.assertTrue((String)"ewestfal should be allowed to initiate", (boolean)this.service.canInitiate(ewestfalPrincipal.getPrincipalId(), testDocType));
    }
}

