/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.kew.messaging.exceptionhandling.DocumentMessageExceptionHandler;
import org.kuali.rice.kew.postprocessor.DefaultPostProcessor;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.api.bus.support.JavaServiceDefinition;
import org.kuali.rice.ksb.messaging.service.KSBJavaService;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class StandardWorkflowEngineTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("EngineConfig.xml");
    }

    @Test
    public void testSystemBranchState() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SimpleDocType");
        document.route("");
        Assert.assertTrue((String)"Document should be final.", (boolean)document.isFinal());
        DocumentRouteHeaderValue routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        Branch rootBranch = routeHeader.getRootBranch();
        Assert.assertNotNull((Object)rootBranch);
        BranchState processedBranchState = rootBranch.getBranchState("System.PostProcessorProcessed");
        BranchState finalBranchState = rootBranch.getBranchState("System.PostProcessorFinal");
        Assert.assertNotNull((Object)processedBranchState);
        Assert.assertNotNull((Object)finalBranchState);
        Assert.assertEquals((Object)"true", (Object)processedBranchState.getValue());
        Assert.assertEquals((Object)"true", (Object)finalBranchState.getValue());
        Assert.assertEquals((long)1L, (long)TestPostProcessor.processedCount);
        Assert.assertEquals((long)1L, (long)TestPostProcessor.finalCount);
    }

    @Test
    public void testFinalDocumentExceptionRoutingRecovery() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SimpleDocType");
        document.route("");
        Assert.assertTrue((String)"Document should be final.", (boolean)document.isFinal());
        Assert.assertEquals((long)1L, (long)TestPostProcessor.processedCount);
        Assert.assertEquals((long)1L, (long)TestPostProcessor.finalCount);
        JavaServiceDefinition serviceDef = new JavaServiceDefinition();
        serviceDef.setPriority(new Integer(1));
        serviceDef.setQueue(true);
        serviceDef.setRetryAttempts(Integer.valueOf(0));
        serviceDef.setServiceInterface(KSBJavaService.class.getName());
        serviceDef.setServiceName(new QName("KEW", "exploader"));
        serviceDef.setService((Object)new ImTheExploderProcessor());
        serviceDef.setMessageExceptionHandler(DocumentMessageExceptionHandler.class.getName());
        serviceDef.validate();
        KsbApiServiceLocator.getServiceBus().publishService((ServiceDefinition)serviceDef, true);
        DocumentRouteHeaderValue routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        String applicationId = routeHeader.getDocumentType().getApplicationId();
        KSBJavaService exploderAsService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(new QName("KEW", "exploader"), null, null, routeHeader.getDocumentId(), null);
        exploderAsService.invoke((Serializable)((Object)""));
        TestUtilities.waitForExceptionRouting();
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be in exception routing.", (boolean)document.isException());
        Assert.assertEquals((long)1L, (long)TestPostProcessor.processedCount);
        Assert.assertEquals((long)1L, (long)TestPostProcessor.finalCount);
        Assert.assertTrue((String)"ewestfal should have a complete request.", (boolean)document.isCompletionRequested());
        document.complete("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be final.", (boolean)document.isFinal());
        Assert.assertEquals((long)1L, (long)TestPostProcessor.processedCount);
        Assert.assertEquals((long)1L, (long)TestPostProcessor.finalCount);
    }

    public void tearDown() throws Exception {
        try {
            TestPostProcessor.resetProcessedCount();
            TestPostProcessor.resetFinalCount();
        }
        finally {
            super.tearDown();
        }
    }

    public static class ImTheExploderProcessor
    implements KSBJavaService {
        public void invoke(Serializable payLoad) {
            throw new WorkflowRuntimeException("I'm the Exploder!!!");
        }
    }

    public static class TestPostProcessor
    extends DefaultPostProcessor {
        public static int finalCount = 0;
        public static int processedCount = 0;

        public ProcessDocReport doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) throws Exception {
            if ("P".equals(statusChangeEvent.getNewRouteStatus())) {
                ++processedCount;
            } else if ("F".equals(statusChangeEvent.getNewRouteStatus())) {
                ++finalCount;
            }
            return new ProcessDocReport(true);
        }

        public static void resetProcessedCount() {
            processedCount = 0;
        }

        public static void resetFinalCount() {
            finalCount = 0;
        }
    }
}

