/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;

public class SubProcessRoutingTest
extends KEWTestCase {
    private static final String DOCUMENT_TYPE_NAME = "SubProcessDocType";
    private static final String SUB_PROCESS_NODE = "MySubProcess";
    private static final String ACKNOWLEDGE_NODE = "Acknowledge";
    private static final String APPROVE_NODE = "Approve";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("EngineConfig.xml");
    }

    @Test
    public void testSubProcessRoute() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DOCUMENT_TYPE_NAME);
        document.saveDocumentData();
        Assert.assertTrue((String)"Document should be initiated", (boolean)document.isInitiated());
        Assert.assertEquals((String)"Should be no action requests.", (long)0L, (long)document.getRootActionRequests().size());
        TestUtilities.assertAtNode(document, "Initial");
        document.route("");
        Assert.assertTrue((String)"Document shoule be ENROUTE.", (boolean)document.isEnroute());
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Incorrect pending action requests.", (long)2L, (long)actionRequests.size());
        boolean isAck = false;
        boolean isApprove = false;
        for (ActionRequestValue request : actionRequests) {
            RouteNodeInstance nodeInstance = request.getNodeInstance();
            Assert.assertNotNull((String)"Node instance should be non null.", (Object)nodeInstance);
            if (request.getPrincipalId().equals(this.getPrincipalIdForName("bmcgough"))) {
                isAck = true;
                Assert.assertEquals((String)"Wrong request type.", (Object)"K", (Object)request.getActionRequested());
                Assert.assertEquals((String)"Wrong node.", (Object)ACKNOWLEDGE_NODE, (Object)nodeInstance.getRouteNode().getRouteNodeName());
                Assert.assertNotNull((String)"Should be in a sub process.", (Object)nodeInstance.getProcess());
                Assert.assertEquals((String)"Wrong sub process.", (Object)SUB_PROCESS_NODE, (Object)nodeInstance.getProcess().getRouteNode().getRouteNodeName());
                Assert.assertFalse((String)"Sub process should be non-initial.", (boolean)nodeInstance.getProcess().isInitial());
                Assert.assertFalse((String)"Sub process should be non-active.", (boolean)nodeInstance.getProcess().isActive());
                Assert.assertFalse((String)"Sub process should be non-complete.", (boolean)nodeInstance.getProcess().isComplete());
                continue;
            }
            if (!request.getPrincipalId().equals(this.getPrincipalIdForName("temay"))) continue;
            isApprove = true;
            Assert.assertEquals((String)"Wrong request type.", (Object)"A", (Object)request.getActionRequested());
            Assert.assertEquals((String)"Wrong node.", (Object)APPROVE_NODE, (Object)request.getNodeInstance().getRouteNode().getRouteNodeName());
            Assert.assertNotNull((String)"Should be in a sub process.", (Object)request.getNodeInstance().getProcess());
            Assert.assertEquals((String)"Wrong sub process.", (Object)SUB_PROCESS_NODE, (Object)request.getNodeInstance().getProcess().getRouteNode().getRouteNodeName());
            Assert.assertFalse((String)"Sub process should be non-initial.", (boolean)nodeInstance.getProcess().isInitial());
            Assert.assertFalse((String)"Sub process should be non-active.", (boolean)nodeInstance.getProcess().isActive());
            Assert.assertFalse((String)"Sub process should be non-complete.", (boolean)nodeInstance.getProcess().isComplete());
        }
        Assert.assertTrue((boolean)isAck);
        Assert.assertTrue((boolean)isApprove);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have acknowledge.", (boolean)document.isAcknowledgeRequested());
        document.acknowledge("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)document.getDocumentId());
        document.approve("");
        boolean foundSubProcess = false;
        List nodeInstances = document.getRouteNodeInstances();
        for (int index = 0; index < nodeInstances.size(); ++index) {
            org.kuali.rice.kew.api.document.node.RouteNodeInstance instanceVO = (org.kuali.rice.kew.api.document.node.RouteNodeInstance)nodeInstances.get(index);
            if (!instanceVO.getName().equals(SUB_PROCESS_NODE)) continue;
            foundSubProcess = true;
            Assert.assertFalse((String)"Sub process should be non-initial.", (boolean)instanceVO.isInitial());
            Assert.assertFalse((String)"Sub process should be non-active.", (boolean)instanceVO.isActive());
            Assert.assertTrue((String)"Sub process should be complete.", (boolean)instanceVO.isComplete());
        }
        Assert.assertTrue((String)"Could not locate sub process node.", (boolean)foundSubProcess);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be final.", (boolean)document.isFinal());
    }
}

