/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.peopleflow;

import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowContract;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDefinition;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDelegate;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowMember;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowService;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class PeopleFlowServiceTest
extends KEWTestCase {
    private static final String NAMESPACE_CODE = "MyNamespace";
    private static final String NAME = "MyFlow";
    private static final String NAME2 = "MyFlowUpdate";
    private static final String DESCRIPTION = "Description after update";
    private PeopleFlowService peopleFlowService;

    @Before
    public void setupServiceUnderTest() {
        this.setPeopleFlowService(KewApiServiceLocator.getPeopleFlowService());
    }

    protected void setPeopleFlowService(PeopleFlowService peopleFlowService) {
        this.peopleFlowService = peopleFlowService;
    }

    protected PeopleFlowService getPeopleFlowService() {
        return this.peopleFlowService;
    }

    @Test
    public void testCRUD() throws Exception {
        PeopleFlowDefinition.Builder builder = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)NAME);
        PeopleFlowMember.Builder memberBuilder = PeopleFlowMember.Builder.create((String)"admin", (MemberType)MemberType.PRINCIPAL);
        memberBuilder.setPriority(1);
        builder.getMembers().add(memberBuilder);
        Group group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName("KR-WKFLW", "TestWorkgroup");
        memberBuilder = PeopleFlowMember.Builder.create((String)group.getId(), (MemberType)MemberType.GROUP);
        memberBuilder.setPriority(2);
        builder.getMembers().add(memberBuilder);
        PeopleFlowDefinition peopleFlow = this.getPeopleFlowService().createPeopleFlow(builder.build());
        this.assertPeopleFlowCreate(peopleFlow, group);
        peopleFlow = this.getPeopleFlowService().getPeopleFlow(peopleFlow.getId());
        this.assertPeopleFlowCreate(peopleFlow, group);
        peopleFlow = this.getPeopleFlowService().getPeopleFlowByName(NAMESPACE_CODE, NAME);
        this.assertPeopleFlowCreate(peopleFlow, group);
        builder = PeopleFlowDefinition.Builder.create((PeopleFlowContract)peopleFlow);
        builder.setName(NAME2);
        Iterator iterator = builder.getMembers().iterator();
        while (iterator.hasNext()) {
            PeopleFlowMember.Builder member = (PeopleFlowMember.Builder)iterator.next();
            if (member.getMemberType() != MemberType.GROUP) continue;
            iterator.remove();
        }
        PeopleFlowMember.Builder adminMember = (PeopleFlowMember.Builder)builder.getMembers().get(0);
        Assert.assertEquals((long)1L, (long)builder.getMembers().size());
        memberBuilder = PeopleFlowMember.Builder.create((String)"ewestfal", (MemberType)MemberType.PRINCIPAL);
        builder.getMembers().add(memberBuilder);
        builder.setDescription(DESCRIPTION);
        PeopleFlowDefinition updatedPeopleFlow = this.getPeopleFlowService().updatePeopleFlow(builder.build());
        updatedPeopleFlow = this.getPeopleFlowService().getPeopleFlow(updatedPeopleFlow.getId());
        Assert.assertNotNull((Object)updatedPeopleFlow);
        Assert.assertEquals((Object)NAME2, (Object)updatedPeopleFlow.getName());
        Assert.assertEquals((Object)DESCRIPTION, (Object)updatedPeopleFlow.getDescription());
        Assert.assertEquals((String)"Ids should be the same", (Object)peopleFlow.getId(), (Object)updatedPeopleFlow.getId());
        Assert.assertEquals((String)"Version number should be one higher", (Object)new Long(peopleFlow.getVersionNumber() + 1L), (Object)updatedPeopleFlow.getVersionNumber());
        Assert.assertEquals((String)"Should have 2 members", (long)2L, (long)updatedPeopleFlow.getMembers().size());
        for (PeopleFlowMember member : updatedPeopleFlow.getMembers()) {
            Assert.assertTrue((String)"should not have any delegates", (boolean)member.getDelegates().isEmpty());
            Assert.assertEquals((Object)MemberType.PRINCIPAL, (Object)member.getMemberType());
            Assert.assertEquals((long)1L, (long)member.getPriority());
            if (member.getMemberId().equals("admin") || member.getMemberId().equals("ewestfal")) continue;
            Assert.fail((String)("Encountered a member that shouldn't exist! " + member.getMemberId()));
        }
    }

    @Test
    public void testMemberAndDelegateBuilder() throws Exception {
        PeopleFlowDefinition.Builder builder = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)NAME);
        PeopleFlowMember.Builder memberBuilder = PeopleFlowMember.Builder.create((String)"admin", (MemberType)MemberType.PRINCIPAL);
        memberBuilder.setPriority(1);
        builder.getMembers().add(memberBuilder);
        Group group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName("KR-WKFLW", "TestWorkgroup");
        memberBuilder = PeopleFlowMember.Builder.create((String)group.getId(), (MemberType)MemberType.GROUP);
        memberBuilder.setPriority(2);
        builder.getMembers().add(memberBuilder);
        PeopleFlowDefinition peopleFlow = this.getPeopleFlowService().createPeopleFlow(builder.build());
        this.assertPeopleFlowCreate(peopleFlow, group);
        peopleFlow = this.getPeopleFlowService().getPeopleFlow(peopleFlow.getId());
        this.assertPeopleFlowCreate(peopleFlow, group);
        peopleFlow = this.getPeopleFlowService().getPeopleFlowByName(NAMESPACE_CODE, NAME);
        this.assertPeopleFlowCreate(peopleFlow, group);
        builder = PeopleFlowDefinition.Builder.create((PeopleFlowContract)peopleFlow);
        builder.setName(NAME2);
        Iterator iterator = builder.getMembers().iterator();
        while (iterator.hasNext()) {
            PeopleFlowMember.Builder member = (PeopleFlowMember.Builder)iterator.next();
            if (member.getMemberType() != MemberType.GROUP) continue;
            iterator.remove();
        }
        PeopleFlowMember.Builder adminMember = (PeopleFlowMember.Builder)builder.getMembers().get(0);
        Assert.assertEquals((long)1L, (long)builder.getMembers().size());
        memberBuilder = PeopleFlowMember.Builder.create((String)"ewestfal", (MemberType)MemberType.PRINCIPAL);
        PeopleFlowDelegate.Builder testMember = PeopleFlowDelegate.Builder.create((String)"test1", (MemberType)MemberType.PRINCIPAL);
        memberBuilder.setDelegates(Arrays.asList(testMember));
        builder.getMembers().add(memberBuilder);
        builder.setDescription(DESCRIPTION);
        PeopleFlowDefinition updatedPeopleFlow = this.getPeopleFlowService().updatePeopleFlow(builder.build());
        updatedPeopleFlow = this.getPeopleFlowService().getPeopleFlow(updatedPeopleFlow.getId());
        Assert.assertNotNull((Object)updatedPeopleFlow);
        Assert.assertEquals((Object)NAME2, (Object)updatedPeopleFlow.getName());
        Assert.assertEquals((Object)DESCRIPTION, (Object)updatedPeopleFlow.getDescription());
        Assert.assertEquals((String)"Ids should be the same", (Object)peopleFlow.getId(), (Object)updatedPeopleFlow.getId());
        Assert.assertEquals((String)"Version number should be one higher", (Object)new Long(peopleFlow.getVersionNumber() + 1L), (Object)updatedPeopleFlow.getVersionNumber());
        Assert.assertEquals((String)"Should have 2 members", (long)2L, (long)updatedPeopleFlow.getMembers().size());
        for (PeopleFlowMember member : updatedPeopleFlow.getMembers()) {
            if (member.getMemberId().equals("ewestfal")) {
                Assert.assertEquals((String)"should have one delegate", (long)1L, (long)member.getDelegates().size());
            } else {
                Assert.assertEquals((String)"should not have delegates", (long)0L, (long)member.getDelegates().size());
            }
            Assert.assertEquals((Object)MemberType.PRINCIPAL, (Object)member.getMemberType());
            Assert.assertEquals((long)1L, (long)member.getPriority());
            if (member.getMemberId().equals("admin") || member.getMemberId().equals("ewestfal")) continue;
            Assert.fail((String)("Encountered a member that shouldn't exist! " + member.getMemberId()));
        }
    }

    private void assertPeopleFlowCreate(PeopleFlowDefinition peopleFlow, Group groupMember) {
        Assert.assertNotNull((Object)peopleFlow);
        Assert.assertNotNull((Object)peopleFlow.getId());
        Assert.assertEquals((long)2L, (long)peopleFlow.getMembers().size());
        for (PeopleFlowMember member : peopleFlow.getMembers()) {
            Assert.assertTrue((String)"should not have any delegates", (boolean)member.getDelegates().isEmpty());
            if (MemberType.PRINCIPAL == member.getMemberType()) {
                Assert.assertEquals((long)1L, (long)member.getPriority());
                Assert.assertEquals((Object)"admin", (Object)member.getMemberId());
                continue;
            }
            if (MemberType.GROUP == member.getMemberType()) {
                Assert.assertEquals((long)2L, (long)member.getPriority());
                Assert.assertEquals((Object)groupMember.getId(), (Object)member.getMemberId());
                continue;
            }
            Assert.fail((String)"Invalid member found!");
        }
        Assert.assertTrue((String)"should have no attributes", (boolean)peopleFlow.getAttributes().isEmpty());
        Assert.assertNull((String)"description should be null", (Object)peopleFlow.getDescription());
        Assert.assertEquals((Object)NAMESPACE_CODE, (Object)peopleFlow.getNamespaceCode());
        Assert.assertEquals((Object)NAME, (Object)peopleFlow.getName());
        Assert.assertNull((Object)peopleFlow.getTypeId());
        Assert.assertTrue((boolean)peopleFlow.isActive());
        Assert.assertNotNull((String)"should have a non-null version number", (Object)peopleFlow.getVersionNumber());
    }
}

