/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.preferences;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.api.preferences.PreferencesContract;
import org.kuali.rice.kew.api.preferences.PreferencesService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.useroptions.UserOptions;
import org.kuali.rice.kew.useroptions.UserOptionsService;
import org.kuali.rice.kim.api.identity.principal.Principal;

public class PreferencesServiceTest
extends KEWTestCase {
    @Test
    public void testPreferencesDefaultSave() throws Exception {
        UserOptionsService userOptionsService = KEWServiceLocator.getUserOptionsService();
        Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipalByPrincipalName("rkirkend");
        Collection userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertTrue((String)"UserOptions should be empty", (boolean)userOptions.isEmpty());
        PreferencesService preferencesService = KewApiServiceLocator.getPreferencesService();
        Preferences preferences = preferencesService.getPreferences(principal.getPrincipalId());
        Assert.assertTrue((String)"Preferences should require a save.", (boolean)preferences.isRequiresSave());
        userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertTrue((String)"UserOptions should not empty", (boolean)userOptions.isEmpty());
        preferencesService.savePreferences(principal.getPrincipalId(), preferences);
        userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertTrue((String)"UserOptions should not be empty", (!userOptions.isEmpty() ? 1 : 0) != 0);
        preferences = preferencesService.getPreferences(principal.getPrincipalId());
        Assert.assertFalse((String)"Preferences should NOT require a save.", (boolean)preferences.isRequiresSave());
        UserOptions refreshRateOption = userOptionsService.findByOptionId("REFRESH_RATE", principal.getPrincipalId());
        Assert.assertNotNull((String)"REFRESH_RATE option should exist.", (Object)refreshRateOption);
        userOptionsService.deleteUserOptions(refreshRateOption);
        Assert.assertNull((String)"REFRESH_RATE option should no longer exist.", (Object)userOptionsService.findByOptionId("REFRESH_RATE", principal.getPrincipalId()));
        preferences = preferencesService.getPreferences(principal.getPrincipalId());
        Assert.assertTrue((String)"Preferences should now require a save again.", (boolean)preferences.isRequiresSave());
        refreshRateOption.setLockVerNbr(null);
        userOptionsService.save(refreshRateOption);
        preferences = preferencesService.getPreferences(principal.getPrincipalId());
        Assert.assertFalse((String)"Preferences should no longer require a save.", (boolean)preferences.isRequiresSave());
    }

    @Test
    public void testPreferencesMarshallingWithInvalidJson() {
        UserOptionsService userOptionsService = KEWServiceLocator.getUserOptionsService();
        Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipalByPrincipalName("ewestfal");
        Collection userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertTrue((String)"UserOptions should be empty", (boolean)userOptions.isEmpty());
        PreferencesService preferencesService = KewApiServiceLocator.getPreferencesService();
        Preferences preferences = preferencesService.getPreferences(principal.getPrincipalId());
        Assert.assertTrue((String)"Preferences should require a save.", (boolean)preferences.isRequiresSave());
        preferencesService.savePreferences(principal.getPrincipalId(), preferences);
        userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        UserOptions docSearchOrder = new UserOptions();
        docSearchOrder.setOptionId("DocSearch.LastSearch.Order");
        docSearchOrder.setWorkflowId(principal.getPrincipalId());
        docSearchOrder.setOptionVal("DocSearch.LastSearch.Holding0");
        UserOptions badJsonOption = new UserOptions();
        badJsonOption.setOptionId("DocSearch.LastSearch.Holding0");
        badJsonOption.setWorkflowId(principal.getPrincipalId());
        badJsonOption.setOptionVal("{isAdvancedSearch\":\"NO\",\"dateCreatedFrom\":1339168393063,\"documentStatuses\":[],\"documentStatusCategories\":[],\"documentAttributeValues\":{},\"additionalDocumentTypeNames\":[]}");
        userOptionsService.save(docSearchOrder);
        userOptionsService.save(badJsonOption);
        userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertTrue((String)"UserOptions should not empty", (!userOptions.isEmpty() ? 1 : 0) != 0);
        preferences = preferencesService.getPreferences(principal.getPrincipalId());
        Preferences.Builder pBuilder = Preferences.Builder.create((PreferencesContract)preferences);
        HashMap<String, String> docTypeNotification = new HashMap<String, String>();
        docTypeNotification.put("hello", "world");
        docTypeNotification.put("does_this_thing_have_a", "bookstore example");
        pBuilder.setDocumentTypeNotificationPreferences(docTypeNotification);
        String marshaledXml = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Preferences.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal((Object)pBuilder.build(), (Writer)stringWriter);
            marshaledXml = stringWriter.toString();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Preferences actual = (Preferences)unmarshaller.unmarshal((Reader)new StringReader(marshaledXml));
            junit.framework.Assert.assertEquals((Object)pBuilder.build(), (Object)actual);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testPreferencesConcurrentDefaultSave() throws Throwable {
        final UserOptionsService userOptionsService = KEWServiceLocator.getUserOptionsService();
        final Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipalByPrincipalName("rkirkend");
        Collection userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertTrue((String)"UserOptions should be empty", (boolean)userOptions.isEmpty());
        final PreferencesService preferencesService = KewApiServiceLocator.getPreferencesService();
        Runnable getPrefRunnable = new Runnable(){

            @Override
            public void run() {
                Preferences preferences = preferencesService.getPreferences(principal.getPrincipalId());
                Assert.assertTrue((String)"Preferences should require a save.", (boolean)preferences.isRequiresSave());
                Collection updatedOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
                Assert.assertTrue((String)"UserOptions should be empty", (boolean)updatedOptions.isEmpty());
            }
        };
        final ArrayList errors = new ArrayList();
        Thread.UncaughtExceptionHandler ueh = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable error) {
                errors.add(error);
            }
        };
        Thread t1 = new Thread(getPrefRunnable);
        Thread t2 = new Thread(getPrefRunnable);
        Thread t3 = new Thread(getPrefRunnable);
        t1.setUncaughtExceptionHandler(ueh);
        t2.setUncaughtExceptionHandler(ueh);
        t3.setUncaughtExceptionHandler(ueh);
        t1.start();
        t2.start();
        t3.start();
        t1.join();
        t2.join();
        t3.join();
        if (errors.size() > 0) {
            throw (Throwable)errors.iterator().next();
        }
        Preferences preferences = preferencesService.getPreferences(principal.getPrincipalId());
        Assert.assertTrue((String)"Preferences should require a save.", (boolean)preferences.isRequiresSave());
        Collection updatedOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertTrue((String)"UserOptions should be empty", (boolean)updatedOptions.isEmpty());
        preferencesService.savePreferences(principal.getPrincipalId(), preferences);
        updatedOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertTrue((String)"UserOptions should not be empty", (!updatedOptions.isEmpty() ? 1 : 0) != 0);
        t1.stop();
    }
}

