/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader;

import java.sql.Timestamp;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class RouteHeaderServiceTest
extends KEWTestCase {
    private RouteHeaderService routeHeaderService;

    @Override
    protected void setUpAfterDataLoad() throws Exception {
        super.setUpAfterDataLoad();
        this.routeHeaderService = KEWServiceLocator.getRouteHeaderService();
    }

    @Test
    public void testGetRoutedByDisplayName() {
        DocumentRouteHeaderValue document = new DocumentRouteHeaderValue();
        Assert.assertEquals((Object)"", (Object)document.getRoutedByDisplayName());
        document.setDocRouteStatus(DocumentStatus.ENROUTE.getCode());
        Assert.assertEquals((Object)"", (Object)document.getRoutedByDisplayName());
        document.setInitiatorWorkflowId(this.getPrincipalIdForName("ewestfal"));
        Assert.assertEquals((Object)"Westfall, Eric", (Object)document.getRoutedByDisplayName());
        document.setDocRouteStatus(DocumentStatus.INITIATED.getCode());
        Assert.assertEquals((Object)"", (Object)document.getRoutedByDisplayName());
        document.setRoutedByUserWorkflowId(this.getPrincipalIdForName("administrator"));
        Assert.assertEquals((Object)"administrator, administrator", (Object)document.getRoutedByDisplayName());
        document.setDocRouteStatus(DocumentStatus.ENROUTE.getCode());
        Assert.assertEquals((Object)"administrator, administrator", (Object)document.getRoutedByDisplayName());
    }

    @Test
    public void testLargeDocumentContent() throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<content>");
        for (int index = 0; index < 10000; ++index) {
            buffer.append("abcdefghijklmnopqrstuvwxyz");
        }
        buffer.append("</content>");
        DocumentRouteHeaderValue document = new DocumentRouteHeaderValue();
        document.setDocContent(buffer.toString());
        document.setDocRouteStatus("I");
        document.setDocRouteLevel(Integer.valueOf(0));
        document.setDateModified(new Timestamp(System.currentTimeMillis()));
        document.setCreateDate(new Timestamp(System.currentTimeMillis()));
        document.setInitiatorWorkflowId("1");
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName("TestDocumentType");
        Assert.assertNotNull((Object)documentType);
        document.setDocumentTypeId(documentType.getDocumentTypeId());
        document = this.routeHeaderService.saveRouteHeader(document);
        Assert.assertNotNull((String)"Document was saved, it should have an ID now.", (Object)document.getDocumentId());
        document = this.routeHeaderService.getRouteHeader(document.getDocumentId());
        String docContent = document.getDocContent();
        Assert.assertEquals((String)"Doc content should be the same size as original string buffer.", (long)buffer.length(), (long)docContent.length());
        Assert.assertTrue((String)"Should be greater than about 5000 bytes.", (docContent.getBytes().length > 5000 ? 1 : 0) != 0);
    }

    @Test
    public void testGetApplicationIdByDocumentId() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType2");
        String documentId = document.getDocumentId();
        String applicationId = this.routeHeaderService.getApplicationIdByDocumentId(documentId);
        Assert.assertEquals((String)"applicationId should be KEWNEW", (Object)"KEWNEW", (Object)applicationId);
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        documentId = document.getDocumentId();
        applicationId = this.routeHeaderService.getApplicationIdByDocumentId(documentId);
        Assert.assertEquals((String)"applicationId should be KUALI", (Object)"KUALI", (Object)applicationId);
    }

    @Test
    public void testLockRouteHeader() throws Exception {
        long timeout = 60000L;
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"TestDocumentType");
        document.saveDocumentData();
        String documentId = document.getDocumentId();
        Locker locker1 = new Locker(documentId);
        locker1.start();
        locker1.latch1.await(timeout, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)locker1.waiting);
        Assert.assertFalse((boolean)locker1.completed);
        Locker locker2 = new Locker(documentId);
        locker2.start();
        Thread.sleep(2000L);
        Assert.assertTrue((boolean)locker2.prelock);
        Assert.assertFalse((boolean)locker2.waiting);
        locker1.latch2.countDown();
        locker1.join(timeout);
        Assert.assertTrue((boolean)locker1.completed);
        Thread.sleep(2000L);
        locker2.latch2.countDown();
        locker2.join(timeout);
        Assert.assertTrue((boolean)locker2.completed);
    }

    private class Locker
    extends Thread {
        private static final long TIMEOUT = 60000L;
        String documentId;
        CountDownLatch latch1;
        CountDownLatch latch2;
        volatile boolean prelock;
        volatile boolean waiting;
        volatile boolean completed;

        Locker(String documentId) {
            this.documentId = documentId;
            this.latch1 = new CountDownLatch(1);
            this.latch2 = new CountDownLatch(1);
        }

        @Override
        public void run() {
            RouteHeaderServiceTest.this.getTransactionTemplate().execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    Locker.this.prelock = true;
                    RouteHeaderServiceTest.this.routeHeaderService.lockRouteHeader(Locker.this.documentId);
                    try {
                        Locker.this.waiting = true;
                        Locker.this.latch1.countDown();
                        Locker.this.latch2.await(60000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Shouldn't have been interrupted but was.", e);
                    }
                    return null;
                }
            });
            this.completed = true;
        }
    }
}

