/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routelog.web;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actions.AcknowledgeAction;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routelog.web.RouteLogAction;
import org.kuali.rice.kew.routelog.web.RouteLogForm;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class RouteLogActionTest
extends KEWTestCase {
    RouteLogAction routeLogAction = new RouteLogAction();

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile(AcknowledgeAction.class, "ActionsConfig.xml");
    }

    @Test
    public void testPopulateRouteLogFutureRequests_HasNoExistingRequests() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)((Object)((Object)this)).getClass().getSimpleName());
        document.route("1 - user1 route");
        this.verifyFutureRequestState(document);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        document.approve("2 - ewestfal approve");
        this.verifyFutureRequestState(document);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        document.approve("3 - user2 approve");
        this.verifyFutureRequestState(document);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user3"), (String)document.getDocumentId());
        document.acknowledge("4 - user3 acknowledge");
        this.verifyFutureRequestState(document);
    }

    private void verifyFutureRequestState(WorkflowDocument document) throws WorkflowException, Exception {
        Collection actionsTaken = KEWServiceLocator.getActionTakenService().findByDocumentId(document.getDocumentId());
        List actionsPending = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        DocumentRouteHeaderValue docRouteHeaderValue = DocumentRouteHeaderValue.from((Document)document.getDocument());
        RouteLogForm routeLogForm = new RouteLogForm();
        this.routeLogAction.populateRouteLogFutureRequests(routeLogForm, docRouteHeaderValue);
        List futureRootRequests = routeLogForm.getFutureRootRequests();
        int takenRequestCount = 0;
        for (ActionTakenValue actionTaken : actionsTaken) {
            if (actionTaken.getActionRequests() == null) continue;
            for (ActionRequestValue actionRequestTaken : actionTaken.getActionRequests()) {
                ++takenRequestCount;
                for (ActionRequestValue futureRequest : futureRootRequests) {
                    Assert.assertFalse((String)"action taken is in futureRootRequests", (boolean)futureRequest.getActionRequestId().equals(actionRequestTaken.getActionRequestId()));
                }
            }
        }
        int pendingRequestsCount = 0;
        for (ActionRequestValue pendingAction : actionsPending) {
            ++pendingRequestsCount;
            for (ActionRequestValue futureRequest : futureRootRequests) {
                Assert.assertFalse((String)"action taken is in futureRootRequests", (boolean)futureRequest.getActionRequestId().equals(pendingAction.getActionRequestId()));
            }
        }
        Assert.assertTrue((String)"taken + pending + future == 3", (takenRequestCount + pendingRequestsCount + futureRootRequests.size() == 3 ? 1 : 0) != 0);
        this.recursiveValidate(routeLogForm.getFutureRootRequests());
    }

    @Test
    public void testPopulateRouteLogFutureRequests_ZeroFutureRequests() throws Exception {
        String user1PrincipalId = this.getPrincipalIdForName("ewestfal");
        RouteLogForm routeLogForm = new RouteLogForm();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)user1PrincipalId, (String)"RouteLogActionTestTrivial");
        document.route("");
        DocumentRouteHeaderValue docRouteHeaderValue = DocumentRouteHeaderValue.from((Document)document.getDocument());
        try {
            this.routeLogAction.populateRouteLogFutureRequests(routeLogForm, docRouteHeaderValue);
        }
        catch (Exception e) {
            Assert.fail((String)"calculating future requests where there will be none should not be a problem");
        }
        Assert.assertTrue((String)"We're expecting 0 future action requests", (routeLogForm.getFutureActionRequestCount() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"We're expecting 0 future action requests", (routeLogForm.getFutureRootRequests() == null || routeLogForm.getFutureRootRequests().size() == 0 ? 1 : 0) != 0);
    }

    private void recursiveValidate(List<ActionRequestValue> actionRequestValues) {
        if (actionRequestValues != null) {
            for (ActionRequestValue actionRequestValue : actionRequestValues) {
                Assert.assertNotNull((Object)actionRequestValue.getActionRequested());
                Assert.assertNotNull((Object)actionRequestValue.getActionRequestedLabel());
                Assert.assertNotNull((Object)actionRequestValue.getNodeInstance());
                Assert.assertNotNull((Object)actionRequestValue.getNodeInstance().getName());
                Assert.assertNotNull((Object)actionRequestValue.getNodeInstance().getRouteNode());
                Assert.assertNotNull((Object)actionRequestValue.getNodeInstance().getRouteNode().getNodeType());
                this.recursiveValidate(actionRequestValue.getChildrenRequests());
            }
        }
    }
}

