/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routemanager;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.InvalidActionTakenException;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.document.DocumentProcessingQueue;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routemanager.ExceptionRoutingTestPostProcessor;
import org.kuali.rice.kew.routemanager.ExplodingRuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class ExceptionRoutingTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("RouteManagerConfig.xml");
    }

    @Override
    protected void setUpAfterDataLoad() throws Exception {
        super.setUpAfterDataLoad();
        ExceptionRoutingTestPostProcessor.THROW_DO_ACTION_TAKEN_EXCEPTION = false;
        ExceptionRoutingTestPostProcessor.THROW_ROUTE_DELETE_ROUTE_HEADER_EXCEPTION = false;
        ExceptionRoutingTestPostProcessor.THROW_ROUTE_STATUS_CHANGE_EXCEPTION = false;
        ExceptionRoutingTestPostProcessor.THROW_ROUTE_STATUS_LEVEL_EXCEPTION = false;
        ExceptionRoutingTestPostProcessor.TRANSITIONED_OUT_OF_EXCEPTION_ROUTING = false;
        ExceptionRoutingTestPostProcessor.BLOW_UP_ON_TRANSITION_INTO_EXCEPTION = false;
    }

    @Test
    public void testSequentialExceptionRouting() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"ExceptionRoutingSequentialDoc");
        try {
            doc.route("");
            Assert.fail((String)"should have thrown routing exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUtilities.getExceptionThreader().join();
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)doc.getDocumentId());
        Assert.assertEquals((String)"Document status incorrect", (Object)DocumentStatus.EXCEPTION, (Object)doc.getStatus());
        List actionRequests = KewApiServiceLocator.getWorkflowDocumentService().getRootActionRequests(doc.getDocumentId());
        Assert.assertEquals((String)"Should be a single exception request", (long)1L, (long)actionRequests.size());
        for (ActionRequest actionRequest : actionRequests) {
            Group group = KimApiServiceLocator.getGroupService().getGroup(actionRequest.getGroupId());
            Assert.assertTrue((String)("Request should be an exception request." + actionRequest), (boolean)actionRequest.isExceptionRequest());
            Assert.assertEquals((String)"Complete should be requested", (Object)ActionRequestType.COMPLETE, (Object)actionRequest.getActionRequested());
            Assert.assertEquals((String)"Request should be a workgroup request", (Object)RecipientType.GROUP, (Object)actionRequest.getRecipientType());
            Assert.assertEquals((String)"Request should be to 'ExceptionRoutingGroup'", (Object)"ExceptionRoutingGroup", (Object)group.getName());
            Assert.assertNotNull((String)"annotation cannot be null", (Object)actionRequest.getAnnotation());
            Assert.assertFalse((String)"annotation cannot be empty", (boolean)"".equals(actionRequest.getAnnotation()));
        }
    }

    @Test
    public void testInvalidActionsInExceptionRouting() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"ExceptionRoutingSequentialDoc");
        try {
            doc.route("");
            Assert.fail((String)"should have thrown routing exception");
        }
        catch (Exception e) {
            this.log.info((Object)("Expected exception occurred: " + e));
        }
        TestUtilities.getExceptionThreader().join();
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)doc.getDocumentId());
        Assert.assertTrue((String)"Document should be in exception status", (boolean)doc.isException());
        try {
            doc.route("routing a document that is in exception routing");
            Assert.fail((String)"Succeeded in routing document that is in exception routing");
        }
        catch (InvalidActionTakenException iate) {
            this.log.info((Object)("Expected exception occurred: " + (Object)((Object)iate)));
        }
    }

    @Test
    public void testParallelExceptionRouting() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"ExceptionRoutingParallelDoc");
        doc.route("");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)doc.getDocumentId());
        Assert.assertTrue((String)"User should have an approve request", (boolean)doc.isApprovalRequested());
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)doc.getDocumentId());
        Assert.assertTrue((String)"User should have an approve request", (boolean)doc.isApprovalRequested());
        List nodes = KewApiServiceLocator.getWorkflowDocumentService().getActiveRouteNodeInstances(doc.getDocumentId());
        Assert.assertEquals((String)"There should be two active nodes", (long)2L, (long)nodes.size());
        TestUtilities.assertAtNode(doc, "RouteNode1");
        TestUtilities.assertAtNode(doc, "RouteNode3");
        try {
            doc.approve("");
            Assert.fail((String)"should have generated routing exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUtilities.getExceptionThreader().join();
        List actionRequests = KewApiServiceLocator.getWorkflowDocumentService().getRootActionRequests(doc.getDocumentId());
        Object routeNode1 = null;
        for (Object nodeInstanceVO : nodes) {
            if (!nodeInstanceVO.getName().equals("RouteNode1")) continue;
            routeNode1 = nodeInstanceVO;
        }
        Assert.assertNotNull((String)"Could not locate the routeNode1 node instance.", routeNode1);
        boolean hasCompleteRequest = false;
        for (ActionRequest actionRequest : actionRequests) {
            if (!actionRequest.isCompleteRequest()) continue;
            Group group = KimApiServiceLocator.getGroupService().getGroup(actionRequest.getGroupId());
            Assert.assertTrue((String)"Complete should be requested", (boolean)actionRequest.isCompleteRequest());
            Assert.assertTrue((String)"Request should be a workgroup request", (boolean)actionRequest.isGroupRequest());
            Assert.assertNull((String)"For exception routing, node instance should have a null id.", (Object)actionRequest.getRouteNodeInstanceId());
            Assert.assertEquals((String)"Request should be to 'ExceptionRoutingGroup'", (Object)"ExceptionRoutingGroup", (Object)group.getName());
            hasCompleteRequest = true;
        }
        Assert.assertTrue((String)"Document should have had a complete request", (boolean)hasCompleteRequest);
        ExplodingRuleAttribute.dontExplode = true;
        Collection actionItems = KEWServiceLocator.getActionListService().findByDocumentId(doc.getDocumentId());
        Assert.assertEquals((String)"There should only be action items for the member of our exception workgroup", (long)1L, (long)actionItems.size());
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user3"), (String)doc.getDocumentId());
        Assert.assertTrue((String)"Document should be routing for completion to member of exception workgroup", (boolean)doc.isCompletionRequested());
        Assert.assertTrue((String)"Document should be in exception status", (boolean)doc.isException());
        doc.complete("");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)doc.getDocumentId());
        doc.approve("");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)doc.getDocumentId());
        doc.approve("");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)doc.getDocumentId());
        doc.approve("");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)doc.getDocumentId());
        doc.approve("");
        Assert.assertTrue((String)"Document should be final", (boolean)doc.isFinal());
    }

    @Test
    public void testExceptionInTransitionFromStart() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"AdhocTransitionTestDocument");
        ExceptionRoutingTestPostProcessor.THROW_ROUTE_STATUS_LEVEL_EXCEPTION = true;
        try {
            doc.route("");
            Assert.fail((String)"We should be in exception routing");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUtilities.getExceptionThreader().join();
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)doc.getDocumentId());
        Assert.assertEquals((String)"document should be in exception routing", (Object)DocumentStatus.EXCEPTION, (Object)doc.getStatus());
    }

    @Test
    public void testRequeueOfExceptionDocument() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"AdhocTransitionTestDocument");
        document.route("");
        Assert.assertFalse((String)"Document should not be in exception routing.", (boolean)document.isException());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Jhopf should have an approve.", (boolean)document.isApprovalRequested());
        ExceptionRoutingTestPostProcessor.THROW_ROUTE_STATUS_CHANGE_EXCEPTION = true;
        try {
            document.approve("");
            Assert.fail((String)"We should be in exception routing");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUtilities.waitForExceptionRouting();
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertEquals((String)"document should be in exception routing", (Object)DocumentStatus.EXCEPTION, (Object)document.getStatus());
        ExceptionRoutingTestPostProcessor.THROW_ROUTE_STATUS_CHANGE_EXCEPTION = false;
        Assert.assertFalse((String)"Should not have transitioned out of exception routing yet.", (boolean)ExceptionRoutingTestPostProcessor.TRANSITIONED_OUT_OF_EXCEPTION_ROUTING);
        DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        String applicationId = routeHeaderValue.getDocumentType().getApplicationId();
        DocumentProcessingQueue documentProcessingQueue = KewApiServiceLocator.getDocumentProcessingQueue((String)document.getDocumentId(), (String)applicationId);
        documentProcessingQueue.process(String.valueOf(document.getDocumentId()));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertEquals((String)"document should be in exception routing", (Object)DocumentStatus.EXCEPTION, (Object)document.getStatus());
        Assert.assertFalse((String)"document shouldn't have transitioned out of exception routing.", (boolean)ExceptionRoutingTestPostProcessor.TRANSITIONED_OUT_OF_EXCEPTION_ROUTING);
        ExceptionRoutingTestPostProcessor.THROW_ROUTE_STATUS_CHANGE_EXCEPTION = false;
        Assert.assertTrue((String)"rkirkend should be in the exception workgroup.", (boolean)document.isCompletionRequested());
        document.complete("Completing out of exception routing.");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((String)"Document should be FINAL.", (boolean)document.isFinal());
        Assert.assertTrue((String)"Document should have transitioned out of exception routing.", (boolean)ExceptionRoutingTestPostProcessor.TRANSITIONED_OUT_OF_EXCEPTION_ROUTING);
    }
}

