/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routemodule;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class RoutingReportServiceTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("RouteModuleConfig.xml");
    }

    @Test
    public void testReportSequential() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqDocType");
        document.route("");
        List activeNodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        List requests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"Should be one active node.", (long)1L, (long)activeNodeInstances.size());
        String activeNodeId = ((RouteNodeInstance)activeNodeInstances.iterator().next()).getRouteNodeInstanceId();
        Assert.assertEquals((String)"Should be 2 pending requests.", (long)2L, (long)requests.size());
        RoutingReportCriteria criteria = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId()).build();
        long start = System.currentTimeMillis();
        DocumentDetail documentDetail = KewApiServiceLocator.getWorkflowDocumentActionsService().executeSimulation(criteria);
        long end = System.currentTimeMillis();
        System.out.println("Time to run routing report: " + (end - start) + " milliseconds.");
        Assert.assertEquals((String)"There should be 5 requests.", (long)5L, (long)documentDetail.getActionRequests().size());
        boolean approveToBmcgough = false;
        boolean approveToRkirkend = false;
        boolean approveToPmckown = false;
        boolean ackToTemay = false;
        boolean ackToJhopf = false;
        for (ActionRequest requestVO : documentDetail.getActionRequests()) {
            String netId = this.getPrincipalNameForId(requestVO.getPrincipalId());
            if (netId.equals("bmcgough")) {
                Assert.assertEquals((String)"Should be approve.", (Object)"A", (Object)requestVO.getActionRequested().getCode());
                Assert.assertEquals((String)"Should be activated.", (Object)ActionRequestStatus.ACTIVATED, (Object)requestVO.getStatus());
                Assert.assertEquals((String)"Wrong node name", (Object)"WorkflowDocument", (Object)requestVO.getNodeName());
                approveToBmcgough = true;
            } else if (netId.equals("rkirkend")) {
                Assert.assertEquals((String)"Should be approve.", (Object)"A", (Object)requestVO.getActionRequested().getCode());
                Assert.assertEquals((String)"Should be activated.", (Object)ActionRequestStatus.ACTIVATED, (Object)requestVO.getStatus());
                Assert.assertEquals((String)"Wrong node name", (Object)"WorkflowDocument", (Object)requestVO.getNodeName());
                approveToRkirkend = true;
            } else if (netId.equals("pmckown")) {
                Assert.assertEquals((String)"Should be approve.", (Object)"A", (Object)requestVO.getActionRequested().getCode());
                Assert.assertEquals((String)"Should be initialized.", (Object)ActionRequestStatus.INITIALIZED, (Object)requestVO.getStatus());
                Assert.assertEquals((String)"Wrong node name", (Object)"WorkflowDocument2", (Object)requestVO.getNodeName());
                approveToPmckown = true;
            } else if (netId.equals("temay")) {
                Assert.assertEquals((String)"Should be acknowledge.", (Object)"K", (Object)requestVO.getActionRequested().getCode());
                Assert.assertEquals((String)"Should be initialized.", (Object)ActionRequestStatus.INITIALIZED, (Object)requestVO.getStatus());
                Assert.assertEquals((String)"Wrong node name", (Object)"Acknowledge1", (Object)requestVO.getNodeName());
                ackToTemay = true;
            } else if (netId.equals("jhopf")) {
                Assert.assertEquals((String)"Should be acknowledge.", (Object)"K", (Object)requestVO.getActionRequested().getCode());
                Assert.assertEquals((String)"Should be initialized.", (Object)ActionRequestStatus.INITIALIZED, (Object)requestVO.getStatus());
                Assert.assertEquals((String)"Wrong node name", (Object)"Acknowledge2", (Object)requestVO.getNodeName());
                ackToJhopf = true;
            }
            Assert.assertNotNull((Object)requestVO.getId());
        }
        Assert.assertTrue((String)"There should be an approve to bmcgough", (boolean)approveToBmcgough);
        Assert.assertTrue((String)"There should be an approve to rkirkend", (boolean)approveToRkirkend);
        Assert.assertTrue((String)"There should be an approve to pmckown", (boolean)approveToPmckown);
        Assert.assertTrue((String)"There should be an ack to temay", (boolean)ackToTemay);
        Assert.assertTrue((String)"There should be an ack to jhopf", (boolean)ackToJhopf);
        activeNodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        requests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"Should be one active node.", (long)1L, (long)activeNodeInstances.size());
        Assert.assertEquals((String)"Should be at the same node.", (Object)activeNodeId, (Object)((RouteNodeInstance)activeNodeInstances.iterator().next()).getRouteNodeInstanceId());
        Assert.assertEquals((String)"Should be 2 pending requests.", (long)2L, (long)requests.size());
        criteria = RoutingReportCriteria.Builder.createByDocumentIdAndTargetNodeName((String)document.getDocumentId(), (String)"Acknowledge1").build();
        documentDetail = KewApiServiceLocator.getWorkflowDocumentActionsService().executeSimulation(criteria);
        Assert.assertEquals((String)"There should be 4 requets.", (long)4L, (long)documentDetail.getActionRequests().size());
        for (ActionRequest requestVO : documentDetail.getActionRequests()) {
            if (!requestVO.getPrincipalId().equals(this.getPrincipalIdForName("jhopf"))) continue;
            Assert.fail((String)"There should be no request to jhopf");
        }
    }

    private static class DynSetup {
        public static final String DOCUMENT_TYPE_NAME = "DynChartOrgDocType";
        public static final String INITIAL_NODE = "Initial";
        public static final String CHART_ORG_NODE = "ChartOrg";
        public static final String SPLIT_NODE_NAME = "Organization Split";
        public static final String JOIN_NODE_NAME = "Organization Join";
        public static final String REQUEST_NODE_NAME = "Organization Request";

        private DynSetup() {
        }
    }

    private static class SeqSetup {
        public static final String DOCUMENT_TYPE_NAME = "SeqDocType";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
        public static final String WORKFLOW_DOCUMENT_2_NODE = "WorkflowDocument2";
        public static final String ACKNOWLEDGE_1_NODE = "Acknowledge1";
        public static final String ACKNOWLEDGE_2_NODE = "Acknowledge2";

        private SeqSetup() {
        }
    }
}

