/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routing;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class RoutingWithEmptyWorkGroupTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("RoutingWithEmptyGroupConfig.xml");
    }

    @Test
    public void testRoutingToEmptyWorkgroup() throws Exception {
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        String user2PrincipalId = this.getPrincipalIdForName("user2");
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)user1PrincipalId, (String)"EmptyWorkgroupDocType");
        doc = WorkflowDocumentFactory.loadDocument((String)"user1", (String)doc.getDocumentId());
        doc.route("");
        doc = WorkflowDocumentFactory.loadDocument((String)user2PrincipalId, (String)doc.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute", (boolean)doc.isEnroute());
        TestUtilities.assertAtNode(doc, "Node3");
        TestUtilities.assertInActionList(user2PrincipalId, doc.getDocumentId());
        List actionRequests = doc.getRootActionRequests();
        for (ActionRequest actionRequest : actionRequests) {
            if (!"Node2".equals(actionRequest.getNodeName())) continue;
            Assert.assertTrue((String)"action request should be for a group", (boolean)actionRequest.isGroupRequest());
            Assert.assertTrue((String)"action request should be marked as \"done\"", (boolean)actionRequest.isDone());
            Assert.assertTrue((String)"Group should have no members.", (boolean)KimApiServiceLocator.getGroupService().getMemberPrincipalIds(actionRequest.getGroupId()).isEmpty());
        }
    }
}

