/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;

public class MockWorkflowAttribute
implements WorkflowRuleAttribute {
    private static final String MOCK_VALUE_ELEMENT = "mockValue";
    private String value;

    public MockWorkflowAttribute() {
    }

    public MockWorkflowAttribute(String value) {
        this.setValue(value);
    }

    public String getDocContent() {
        if (this.value == null) {
            return "";
        }
        return "<mockValue>" + this.value + "</" + MOCK_VALUE_ELEMENT + ">";
    }

    public List parseDocContent(String docContent) {
        try {
            Document doc = XmlHelper.buildJDocument((Reader)new StringReader(docContent));
            Collection elements = XmlHelper.findElements((Element)doc.getRootElement(), (String)MOCK_VALUE_ELEMENT);
            Element mockValueElement = (Element)elements.iterator().next();
            ArrayList<MockWorkflowAttribute> attributes = new ArrayList<MockWorkflowAttribute>();
            if (mockValueElement != null) {
                attributes.add(new MockWorkflowAttribute(mockValueElement.getText()));
            }
            return attributes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getIdFieldName() {
        return null;
    }

    public String getLockFieldName() {
        return null;
    }

    public List getRoutingDataRows() {
        return null;
    }

    public List getRuleExtensionValues() {
        return null;
    }

    public List getRuleRows() {
        return null;
    }

    public boolean isMatch(DocumentContent docContent, List ruleExtensions) {
        return false;
    }

    public boolean isRequired() {
        return false;
    }

    public void setRequired(boolean required) {
    }

    public List<RemotableAttributeError> validateRoutingData(Map paramMap) {
        return null;
    }

    public List<RemotableAttributeError> validateRuleData(Map paramMap) {
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

