/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.api.validation.RuleValidationContext;
import org.kuali.rice.kew.framework.validation.RuleValidationAttributeExporterService;
import org.kuali.rice.kew.rule.RuleValidationAttribute;
import org.kuali.rice.kew.rule.TestRuleValidationAttribute;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.validation.RuleValidationAttributeResolver;
import org.kuali.rice.ksb.messaging.resourceloader.ServiceBusResourceLoader;

public class RuleValidationAttributeRemotingTest
extends KEWTestCase {
    private static RuleValidationAttributeResolver resolver;
    private static ServiceBusResourceLoader bus;
    private static final QName EXPORTER_SOAP_SERVICE_NAME;
    private static final Predicate RULE_VALIDATION_ATTRIB_PREDICATE;

    private static final ServiceBusResourceLoader getServiceBusResourceLoader(ResourceLoader loader) {
        if (loader instanceof ServiceBusResourceLoader) {
            return (ServiceBusResourceLoader)loader;
        }
        for (ResourceLoader rl : loader.getResourceLoaders()) {
            if (rl instanceof ServiceBusResourceLoader) {
                return (ServiceBusResourceLoader)rl;
            }
            ServiceBusResourceLoader rl0 = RuleValidationAttributeRemotingTest.getServiceBusResourceLoader(rl);
            if (rl0 == null) continue;
            return rl0;
        }
        return null;
    }

    @Before
    public void obtainServices() {
        resolver = KEWServiceLocator.getRuleValidationAttributeResolver();
        bus = RuleValidationAttributeRemotingTest.getServiceBusResourceLoader(GlobalResourceLoader.getResourceLoader());
        Assert.assertNotNull((String)"could not find service bus resource loader", (Object)bus);
    }

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("RuleTemplateAttributeTestConfig.xml");
    }

    @Test
    public void test_resolver() throws Exception {
        TestRuleValidationAttribute.invocations = 0;
        int invocations = 0;
        for (RuleAttribute attrib : CollectionUtils.select((Collection)KEWServiceLocator.getRuleAttributeService().findAll(), (Predicate)RULE_VALIDATION_ATTRIB_PREDICATE)) {
            RuleValidationAttribute rva = resolver.resolveRuleValidationAttribute(attrib.getName(), null);
            Assert.assertNotNull((String)"RuleValidationAttribute resolution failed", (Object)rva);
            RuleValidationContext ctx = RuleValidationContext.Builder.create((RuleContract)Rule.Builder.create().build()).build();
            Assert.assertNotNull((String)"RuleValidationAttribute returned null result", (Object)rva.validate(ctx));
            ++invocations;
        }
        Assert.assertEquals((String)"Actual TestRuleValidationAttribute invocations did not match expected invocations", (long)invocations, (long)TestRuleValidationAttribute.invocations);
    }

    @Test
    public void test_exporter() throws Exception {
        RuleValidationAttributeExporterService exporter = (RuleValidationAttributeExporterService)bus.getService(EXPORTER_SOAP_SERVICE_NAME);
        Assert.assertNotNull((String)"Could not find the RuleValidationAttributeExporterService SOAP endpoint on the bus!", (Object)exporter);
        TestRuleValidationAttribute.invocations = 0;
        int invocations = 0;
        for (RuleAttribute attrib : CollectionUtils.select((Collection)KEWServiceLocator.getRuleAttributeService().findAll(), (Predicate)RULE_VALIDATION_ATTRIB_PREDICATE)) {
            RuleValidationContext ctx = RuleValidationContext.Builder.create((RuleContract)Rule.Builder.create().build()).build();
            Assert.assertNotNull((String)"RuleValidationAttributeExporterService return value was null", (Object)exporter.validate(attrib.getName(), ctx));
            ++invocations;
        }
        Assert.assertEquals((String)"Actual TestRuleValidationAttribute invocations did not match expected invocations", (long)invocations, (long)TestRuleValidationAttribute.invocations);
    }

    static {
        EXPORTER_SOAP_SERVICE_NAME = new QName("http://rice.kuali.org/kew/v2_0", "ruleValidationAttributeExporterService");
        RULE_VALIDATION_ATTRIB_PREDICATE = new Predicate(){

            public boolean evaluate(Object attrib) {
                return "RuleValidationAttribute".equals(((RuleAttribute)attrib).getType());
            }
        };
    }
}

