/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.server;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.api.document.DocumentContentUpdate;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.dto.DTOConverter;
import org.kuali.rice.kew.rule.TestRuleAttribute;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class DTOConverterTest
extends KEWTestCase {
    private static final String DOCUMENT_CONTENT = "documentContent";
    private static final String ATTRIBUTE_CONTENT = "attributeContent";
    private static final String SEARCHABLE_CONTENT = "searchableContent";
    private static final String APPLICATION_CONTENT = "applicationContent";

    @Test
    public void testConvertDocumentContent() throws Exception {
        String attributeContent = null;
        String searchableContent = null;
        String applicationContent = null;
        String xmlContent = this.constructContent(attributeContent, searchableContent, applicationContent);
        DocumentContent.Builder builder = DocumentContent.Builder.create((String)"-1234");
        builder.setApplicationContent(applicationContent);
        builder.setAttributeContent(attributeContent);
        builder.setSearchableContent(searchableContent);
        DocumentContent content = builder.build();
        Assert.assertFalse((String)"Content cannot be empty.", (boolean)StringUtils.isEmpty((String)content.getFullContent()));
        Assert.assertEquals((String)"Attribute content is invalid.", null, (Object)content.getAttributeContent());
        Assert.assertEquals((String)"Searchable content is invalid.", null, (Object)content.getSearchableContent());
        Assert.assertEquals((String)"Application content is invalid.", null, (Object)content.getApplicationContent());
        Assert.assertEquals((String)"Should have fake document id.", (Object)"-1234", (Object)content.getDocumentId());
        attributeContent = "";
        searchableContent = "";
        applicationContent = "";
        builder = DocumentContent.Builder.create((String)"testId");
        builder.setApplicationContent(applicationContent);
        builder.setAttributeContent(attributeContent);
        builder.setSearchableContent(searchableContent);
        content = builder.build();
        this.assertContent(content, attributeContent, searchableContent, applicationContent);
        attributeContent = "<iEnjoyFlexContent><id>1234</id></iEnjoyFlexContent>";
        searchableContent = "<thisIdBeWarrenG>Warren G</thisIdBeWarrenG><whatsMyName>Snoop</whatsMyName>";
        applicationContent = "<thisIsTotallyRad><theCoolestContentInTheWorld qualify=\"iSaidSo\">it's marvelous!</theCoolestContentInTheWorld></thisIsTotallyRad>";
        builder = DocumentContent.Builder.create((String)"testId");
        builder.setApplicationContent(applicationContent);
        builder.setAttributeContent(attributeContent);
        builder.setSearchableContent(searchableContent);
        content = builder.build();
        this.assertContent(content, attributeContent, searchableContent, applicationContent);
    }

    private void assertContent(DocumentContent contentVO, String attributeContent, String searchableContent, String applicationContent) throws Exception {
        Assert.assertFalse((String)"Content cannot be empty.", (boolean)StringUtils.isEmpty((String)contentVO.getFullContent()));
        Assert.assertEquals((String)"Attribute content is invalid.", (Object)attributeContent.replaceAll("\n", ""), (Object)contentVO.getAttributeContent().replaceAll("\n", ""));
        Assert.assertEquals((String)"Searchable content is invalid.", (Object)searchableContent.replaceAll("\n", ""), (Object)contentVO.getSearchableContent().replaceAll("\n", ""));
        Assert.assertEquals((String)"Application content is invalid.", (Object)applicationContent.replaceAll("\n", ""), (Object)contentVO.getApplicationContent().replaceAll("\n", ""));
    }

    @Test
    public void testBuildUpdatedDocumentContent() throws Exception {
        String startContent = "<documentContent>";
        String endContent = "</documentContent>";
        DocumentContentUpdate contentUpdate = DocumentContentUpdate.Builder.create().build();
        String content = DTOConverter.buildUpdatedDocumentContent((String)"<documentContent/>", (DocumentContentUpdate)contentUpdate, null);
        Assert.assertEquals((String)"Invalid content conversion.", (Object)StringUtils.deleteWhitespace((String)"<documentContent/>"), (Object)StringUtils.deleteWhitespace((String)content));
        String attributeContent = "<attribute1><id value=\"3\"/></attribute1>";
        String searchableContent = "<searchable1><data>hello</data></searchable1>";
        DocumentContentUpdate.Builder contentUpdateBuilder = DocumentContentUpdate.Builder.create();
        contentUpdateBuilder.setAttributeContent(this.constructContent(ATTRIBUTE_CONTENT, attributeContent));
        contentUpdateBuilder.setSearchableContent(this.constructContent(SEARCHABLE_CONTENT, searchableContent));
        content = DTOConverter.buildUpdatedDocumentContent((String)"<documentContent/>", (DocumentContentUpdate)contentUpdateBuilder.build(), null);
        String fullContent = startContent + "\n" + this.constructContent(ATTRIBUTE_CONTENT, attributeContent) + "\n" + this.constructContent(SEARCHABLE_CONTENT, searchableContent) + "\n" + endContent;
        Assert.assertEquals((String)"Invalid content conversion.", (Object)StringUtils.deleteWhitespace((String)fullContent), (Object)StringUtils.deleteWhitespace((String)content));
        String testAttributeContent = new TestRuleAttribute().getDocContent();
        WorkflowAttributeDefinition attributeDefinition = WorkflowAttributeDefinition.Builder.create((String)"TestRuleAttribute").build();
        contentUpdateBuilder.getAttributeDefinitions().add(attributeDefinition);
        content = DTOConverter.buildUpdatedDocumentContent((String)"<documentContent/>", (DocumentContentUpdate)contentUpdateBuilder.build(), null);
        fullContent = startContent + this.constructContent(ATTRIBUTE_CONTENT, attributeContent + testAttributeContent) + this.constructContent(SEARCHABLE_CONTENT, searchableContent) + endContent;
        Assert.assertEquals((String)"Invalid content conversion.", (Object)StringUtils.deleteWhitespace((String)fullContent), (Object)StringUtils.deleteWhitespace((String)content));
    }

    private String constructContent(String type, String content) {
        if (StringUtils.isEmpty((String)content)) {
            return "";
        }
        return "<" + type + ">" + content + "</" + type + ">";
    }

    private String constructContent(String attributeContent, String searchableContent, String applicationContent) {
        return "<documentContent>" + this.constructContent(ATTRIBUTE_CONTENT, attributeContent) + this.constructContent(SEARCHABLE_CONTENT, searchableContent) + this.constructContent(APPLICATION_CONTENT, applicationContent) + "</" + DOCUMENT_CONTENT + ">";
    }

    @Test
    public void testConvertActionItem() throws Exception {
        String testWorkgroupName = "TestWorkgroup";
        Group testWorkgroup = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName("KR-WKFLW", testWorkgroupName);
        String testWorkgroupId = testWorkgroup.getId();
        Assert.assertTrue((String)("Test workgroup '" + testWorkgroupName + "' should have at least one user"), (KimApiServiceLocator.getGroupService().getDirectMemberPrincipalIds(testWorkgroup.getId()).size() > 0 ? 1 : 0) != 0);
        String workflowId = (String)KimApiServiceLocator.getGroupService().getDirectMemberPrincipalIds(testWorkgroup.getId()).get(0);
        Assert.assertNotNull((String)"User from workgroup should not be null", (Object)workflowId);
        String actionRequestCd = "K";
        String actionRequestId = "4";
        String docName = "dummy";
        String roleName = "fakeRole";
        String documentId = "23";
        Timestamp dateAssigned = new Timestamp(new Date().getTime());
        String docHandlerUrl = "http://this.is.not.us";
        String docTypeLabel = "Label Me";
        String docTitle = "Title me";
        String responsibilityId = "35";
        DelegationType delegationType = DelegationType.PRIMARY;
        ActionItem actionItem = new ActionItem();
        actionItem.setActionRequestCd(actionRequestCd);
        actionItem.setActionRequestId(actionRequestId);
        actionItem.setDocName(docName);
        actionItem.setRoleName(roleName);
        actionItem.setPrincipalId(workflowId);
        actionItem.setDocumentId(documentId);
        actionItem.setDateAssigned(dateAssigned);
        actionItem.setDocHandlerURL(docHandlerUrl);
        actionItem.setDocLabel(docTypeLabel);
        actionItem.setDocTitle(docTitle);
        actionItem.setGroupId(testWorkgroupId);
        actionItem.setResponsibilityId(responsibilityId);
        actionItem.setDelegationType(delegationType);
        actionItem.setDelegatorPrincipalId(workflowId);
        actionItem.setDelegatorGroupId(testWorkgroupId);
        org.kuali.rice.kew.api.action.ActionItem actionItemVO = ActionItem.to((ActionItem)actionItem);
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)actionRequestCd, (Object)actionItemVO.getActionRequestCd());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)actionRequestId, (Object)actionItemVO.getActionRequestId());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)docName, (Object)actionItemVO.getDocName());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)roleName, (Object)actionItemVO.getRoleName());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)workflowId, (Object)actionItemVO.getPrincipalId());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)documentId, (Object)actionItemVO.getDocumentId());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)new DateTime(dateAssigned.getTime()), (Object)actionItemVO.getDateTimeAssigned());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)docHandlerUrl, (Object)actionItemVO.getDocHandlerURL());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)docTypeLabel, (Object)actionItemVO.getDocLabel());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)docTitle, (Object)actionItemVO.getDocTitle());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)("" + testWorkgroupId), (Object)actionItemVO.getGroupId());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)responsibilityId, (Object)actionItemVO.getResponsibilityId());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)delegationType, (Object)actionItemVO.getDelegationType());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)workflowId, (Object)actionItemVO.getDelegatorPrincipalId());
        Assert.assertEquals((String)"Action Item VO object has incorrect value", (Object)testWorkgroupId, (Object)actionItemVO.getDelegatorGroupId());
    }
}

