/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.test.web;

import javax.servlet.ServletContext;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.springframework.mock.web.MockHttpServletRequest;

public class WorkflowServletRequest
extends MockHttpServletRequest {
    public WorkflowServletRequest() {
    }

    public WorkflowServletRequest(ServletContext context, String method, String requestURI) {
        super(context, method, requestURI);
    }

    public WorkflowServletRequest(ServletContext context) {
        super(context);
    }

    public WorkflowServletRequest(String method, String requestURI) {
        super(method, requestURI);
    }

    public WorkflowServletRequest(String user) {
        this.setUser(user);
    }

    public void setUser(String user) {
        Principal wfuser = user == null ? null : KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(user);
        this.setWorkflowUser(wfuser);
    }

    public String getUser() {
        Principal user = this.getWorkflowUser();
        if (user == null) {
            return null;
        }
        return user.getPrincipalName();
    }

    public void setBackdoorId(String backdoorId) {
        UserSession session = this.getUserSession();
        if (session == null) {
            throw new IllegalStateException("Session must be set before backdoor id is set");
        }
        session.setBackdoorUser(backdoorId);
    }

    public void setWorkflowUser(Principal user) {
        if (user == null) {
            this.setUserSession(null);
        } else {
            this.setUserSession(new UserSession(user.getPrincipalName()));
        }
    }

    public Principal getWorkflowUser() {
        UserSession session = this.getUserSession();
        if (session == null) {
            return null;
        }
        return KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(session.getLoggedInUserPrincipalName());
    }

    public String getBackdoorPrincipalId() {
        UserSession session = this.getUserSession();
        if (session == null) {
            return null;
        }
        return session.getPrincipalId();
    }

    public void setUserSession(UserSession userSession) {
        this.getSession().setAttribute("UserSession", (Object)userSession);
    }

    public UserSession getUserSession() {
        return (UserSession)this.getSession().getAttribute("UserSession");
    }
}

