/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.workgroup;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class GroupXmlImportTest
extends KEWTestCase {
    @Test
    public void testGroupImportXml() throws Exception {
        this.loadXmlFile("GroupXmlImportTest.xml");
        IdentityService identityService = KimApiServiceLocator.getIdentityService();
        GroupService groupService = KimApiServiceLocator.getGroupService();
        Group group = groupService.getGroupByNamespaceCodeAndName("KR-WKFLW", "TestUserGroup");
        Assert.assertNotNull((Object)group);
        List members = groupService.getMemberPrincipalIds(group.getId());
        List groups = groupService.getMemberGroupIds(group.getId());
        Assert.assertTrue((boolean)groupService.isMemberOfGroup(identityService.getPrincipalByPrincipalName("ewestfal").getPrincipalId(), group.getId()));
        Assert.assertTrue((boolean)groupService.isMemberOfGroup(identityService.getPrincipalByPrincipalName("rkirkend").getPrincipalId(), group.getId()));
        Assert.assertTrue((boolean)groupService.isMemberOfGroup("2015", group.getId()));
        Assert.assertTrue((boolean)KimApiServiceLocator.getGroupService().isGroupMemberOfGroup(groupService.getGroupByNamespaceCodeAndName("KR-WKFLW", "TestWorkgroup").getId(), group.getId()));
    }
}

