/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.io.StringReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.test.BaseRiceTestCase;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathTest
extends BaseRiceTestCase {
    private static final String XSTREAM_SAFE_PREFIX = "wf:xstreamsafe('";
    private static final String XSTREAM_SAFE_SUFFIX = "')";
    public static final String XSTREAM_MATCH_ANYWHERE_PREFIX = "//";
    public static final String XSTREAM_MATCH_RELATIVE_PREFIX = "./";
    private static final String TEST_DOC = "<root name=\"root\">\n  <child name=\"child1\">\n    <child_1 name=\"child1_1\">\n      <closedSimple/>\n      <emptySimple></emptySimple>\n      <textSimple>some text 1</textSimple>\n    </child_1>\n  </child>\n  <child name=\"child2\">\n    <child_2 name=\"child2_1\">\n      <closedSimple/>\n      <emptySimple></emptySimple>\n      <textSimple>some text 2</textSimple>\n    </child_2>\n  </child>\n</root>";
    private static final String TEST_ATTRIBUTE_DOC = "<root name=\"root\">\n  <field name=\"one\" type=\"ALL\"/>\n  <field name=\"two\" type=\"REPORT\"/>\n  <field name=\"three\"/>\n</root>";
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();

    private static final InputSource getTestInputSource() {
        return new InputSource(new StringReader(TEST_DOC));
    }

    @Test
    public void testAttributeAbsence() throws XPathExpressionException {
        NodeList nodes = (NodeList)XPATH.evaluate("/root/child[not(@nonExistentAttribute)]", XPathTest.getTestInputSource(), XPathConstants.NODESET);
        Assert.assertEquals((long)2L, (long)nodes.getLength());
        Assert.assertEquals((Object)"child1", (Object)nodes.item(0).getAttributes().getNamedItem("name").getNodeValue());
        Assert.assertEquals((Object)"child2", (Object)nodes.item(1).getAttributes().getNamedItem("name").getNodeValue());
        nodes = (NodeList)XPATH.evaluate("/root/*[local-name(.) = 'child' or (@nonExistentAttribute)]", XPathTest.getTestInputSource(), XPathConstants.NODESET);
        Assert.assertEquals((long)2L, (long)nodes.getLength());
        Assert.assertEquals((Object)"child1", (Object)nodes.item(0).getAttributes().getNamedItem("name").getNodeValue());
        Assert.assertEquals((Object)"child2", (Object)nodes.item(1).getAttributes().getNamedItem("name").getNodeValue());
        nodes = (NodeList)XPATH.evaluate("/root/child[not(@name)]", XPathTest.getTestInputSource(), XPathConstants.NODE);
        Assert.assertNull((Object)nodes);
        nodes = (NodeList)XPATH.evaluate("/root/field[@type='ALL' or not(@type)]", new InputSource(new StringReader(TEST_ATTRIBUTE_DOC)), XPathConstants.NODESET);
        Assert.assertEquals((long)2L, (long)nodes.getLength());
        Assert.assertEquals((Object)"one", (Object)nodes.item(0).getAttributes().getNamedItem("name").getNodeValue());
        Assert.assertEquals((Object)"three", (Object)nodes.item(1).getAttributes().getNamedItem("name").getNodeValue());
    }

    @Test
    public void testSelectJustChilds() throws XPathExpressionException {
        NodeList nodes = (NodeList)XPATH.evaluate("/root/child", XPathTest.getTestInputSource(), XPathConstants.NODESET);
        Assert.assertEquals((long)2L, (long)nodes.getLength());
        Assert.assertEquals((Object)"child1", (Object)nodes.item(0).getAttributes().getNamedItem("name").getNodeValue());
        Assert.assertEquals((Object)"child2", (Object)nodes.item(1).getAttributes().getNamedItem("name").getNodeValue());
    }

    @Test
    public void testSelectAbsoluteChild() throws XPathExpressionException {
        Node node = (Node)XPATH.evaluate("/root/child", XPathTest.getTestInputSource(), XPathConstants.NODE);
        Assert.assertEquals((Object)"child1", (Object)node.getAttributes().getNamedItem("name").getNodeValue());
    }

    @Test
    public void testSelectAnyChild() throws XPathExpressionException {
        Node anyNode = (Node)XPATH.evaluate("//child", XPathTest.getTestInputSource(), XPathConstants.NODE);
        Assert.assertEquals((Object)"child1", (Object)anyNode.getAttributes().getNamedItem("name").getNodeValue());
    }

    @Test
    public void testNonexistent() throws XPathExpressionException {
        String expr = "//child/child_1/nonExistent";
        Node nonexistent = (Node)XPATH.evaluate("//child/child_1/nonExistent", XPathTest.getTestInputSource(), XPathConstants.NODE);
        Assert.assertNull((Object)nonexistent);
        String valueOfNonexistentElement = (String)XPATH.evaluate("//child/child_1/nonExistent", XPathTest.getTestInputSource(), XPathConstants.STRING);
        Assert.assertEquals((Object)"", (Object)valueOfNonexistentElement);
    }

    @Test
    public void testClosedSimple() throws XPathExpressionException {
        String expr = "//child/child_1/closedSimple";
        Node closedSimple = (Node)XPATH.evaluate("//child/child_1/closedSimple", XPathTest.getTestInputSource(), XPathConstants.NODE);
        Assert.assertNotNull((Object)closedSimple);
        Assert.assertNull((Object)closedSimple.getFirstChild());
        String valueOfClosedTag = (String)XPATH.evaluate("//child/child_1/closedSimple", XPathTest.getTestInputSource(), XPathConstants.STRING);
        Assert.assertEquals((Object)"", (Object)valueOfClosedTag);
    }

    @Test
    public void testEmptySimple() throws XPathExpressionException {
        String expr = "//child/child_1/emptySimple";
        Node emptySimple = (Node)XPATH.evaluate("//child/child_1/emptySimple", XPathTest.getTestInputSource(), XPathConstants.NODE);
        Assert.assertNotNull((Object)emptySimple);
        Assert.assertNull((Object)emptySimple.getFirstChild());
        String valueOfEmptyTag = (String)XPATH.evaluate("//child/child_1/emptySimple", XPathTest.getTestInputSource(), XPathConstants.STRING);
        Assert.assertEquals((Object)"", (Object)valueOfEmptyTag);
    }

    @Test
    public void testText() throws XPathExpressionException {
        String expr = "//child/child_2[@name='child2_1']/textSimple";
        String expected = "some text 2";
        Node textSimple = (Node)XPATH.evaluate("//child/child_2[@name='child2_1']/textSimple", XPathTest.getTestInputSource(), XPathConstants.NODE);
        Assert.assertNotNull((Object)textSimple);
        Assert.assertNotNull((Object)textSimple.getFirstChild());
        String valueOfTextTag = (String)XPATH.evaluate("//child/child_2[@name='child2_1']/textSimple", XPathTest.getTestInputSource(), XPathConstants.STRING);
        Assert.assertEquals((Object)"some text 2", (Object)valueOfTextTag);
    }

    private String constructXpathExpression(String valueForTrue, String valueForFalse, String booleanXPathExpression) {
        String[] xpathElementsToInsert = new String[]{"concat( substring('" + valueForTrue + "', number(not(", "))*string-length('" + valueForTrue + "')+1), substring('" + valueForFalse + "', number(", ")*string-length('" + valueForFalse + "')+1))"};
        StringBuffer returnableString = new StringBuffer();
        for (int i = 0; i < xpathElementsToInsert.length; ++i) {
            String newXpathElement = xpathElementsToInsert[i];
            returnableString.append(newXpathElement);
            if (i + 1 == xpathElementsToInsert.length && xpathElementsToInsert.length != 1) continue;
            returnableString.append(booleanXPathExpression);
        }
        return returnableString.toString();
    }
}

