/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml.export;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.xml.export.XmlExporterTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class RuleAttributeXmlExporterTest
extends XmlExporterTestCase {
    @Test
    public void testExport() throws Exception {
        this.loadXmlFile("RuleAttributeExportConfig.xml");
        this.assertExport();
    }

    @Override
    protected void assertExport() throws Exception {
        List oldRuleAttributes = KEWServiceLocator.getRuleAttributeService().findAll();
        KewExportDataSet dataSet = new KewExportDataSet();
        dataSet.getRuleAttributes().addAll(oldRuleAttributes);
        byte[] xmlBytes = CoreApiServiceLocator.getXmlExporterService().export(dataSet.createExportDataSet());
        Assert.assertTrue((String)"XML should be non empty.", (xmlBytes != null && xmlBytes.length > 0 ? 1 : 0) != 0);
        this.loadXmlStream(new BufferedInputStream(new ByteArrayInputStream(xmlBytes)));
        List newRuleAttributes = KEWServiceLocator.getRuleAttributeService().findAll();
        Assert.assertEquals((String)"Should have same number of old and new RuleAttributes.", (long)oldRuleAttributes.size(), (long)newRuleAttributes.size());
        for (RuleAttribute oldRuleAttribute : oldRuleAttributes) {
            boolean foundAttribute = false;
            for (RuleAttribute newRuleAttribute : newRuleAttributes) {
                if (!oldRuleAttribute.getName().equals(newRuleAttribute.getName())) continue;
                this.assertRuleAttributeExport(oldRuleAttribute, newRuleAttribute);
                foundAttribute = true;
            }
            Assert.assertTrue((String)("Could not locate the new rule attribute for name " + oldRuleAttribute.getName()), (boolean)foundAttribute);
        }
    }

    private void assertRuleAttributeExport(RuleAttribute oldRuleAttribute, RuleAttribute newRuleAttribute) {
        Assert.assertEquals((String)"Ids should be the same.", (Object)oldRuleAttribute.getId(), (Object)newRuleAttribute.getId());
        Assert.assertFalse((String)"Version numbers should be different.", (boolean)oldRuleAttribute.getVersionNumber().equals(newRuleAttribute.getVersionNumber()));
        Assert.assertEquals((Object)oldRuleAttribute.getDescription(), (Object)newRuleAttribute.getDescription());
        Assert.assertEquals((Object)oldRuleAttribute.getName(), (Object)newRuleAttribute.getName());
        Assert.assertEquals((Object)oldRuleAttribute.getLabel(), (Object)newRuleAttribute.getLabel());
        Assert.assertEquals((Object)oldRuleAttribute.getType(), (Object)newRuleAttribute.getType());
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)oldRuleAttribute.getXmlConfigData()), (Object)StringUtils.deleteWhitespace((String)newRuleAttribute.getXmlConfigData()));
        this.assertRuleTemplateAttributes(oldRuleAttribute.getRuleTemplateAttributes(), newRuleAttribute.getRuleTemplateAttributes());
    }

    private void assertRuleTemplateAttributes(List oldRuleTemplateAttributes, List newRuleTemplateAttributes) {
        Assert.assertEquals((long)oldRuleTemplateAttributes.size(), (long)newRuleTemplateAttributes.size());
        for (RuleTemplateAttributeBo oldAttribute : oldRuleTemplateAttributes) {
            boolean foundAttribute = false;
            for (RuleTemplateAttributeBo newAttribute : oldRuleTemplateAttributes) {
                if (!oldAttribute.getRuleAttribute().getName().equals(newAttribute.getRuleAttribute().getName())) continue;
                Assert.assertEquals((Object)oldAttribute.getRequired(), (Object)newAttribute.getRequired());
                foundAttribute = true;
            }
            Assert.assertTrue((String)"Could not locate new attribute.", (boolean)foundAttribute);
        }
    }
}

