/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml.export;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kew.rule.RuleTemplateOptionBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.xml.export.XmlExporterTestCase;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.ClearDatabaseLifecycle;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class RuleTemplateXmlExporterTest
extends XmlExporterTestCase {
    @Test
    public void testExport() throws Exception {
        new ClearDatabaseLifecycle(this.getPerTestTablesToClear(), this.getPerTestTablesNotToClear()).start();
        this.loadXmlFile("RuleTemplateExportConfig.xml");
        this.assertExport();
    }

    @Override
    protected void assertExport() throws Exception {
        List oldRuleTemplates = KEWServiceLocator.getRuleTemplateService().findAll();
        KewExportDataSet dataSet = new KewExportDataSet();
        dataSet.getRuleTemplates().addAll(oldRuleTemplates);
        dataSet.getRuleAttributes().addAll(KEWServiceLocator.getRuleAttributeService().findAll());
        byte[] xmlBytes = CoreApiServiceLocator.getXmlExporterService().export(dataSet.createExportDataSet());
        Assert.assertTrue((String)"XML should be non empty.", (xmlBytes != null && xmlBytes.length > 0 ? 1 : 0) != 0);
        new ClearDatabaseLifecycle(this.getPerTestTablesToClear(), this.getPerTestTablesNotToClear()).start();
        this.loadXmlStream(new BufferedInputStream(new ByteArrayInputStream(xmlBytes)));
        List newRuleTemplates = KEWServiceLocator.getRuleTemplateService().findAll();
        Assert.assertEquals((String)"Should have same number of old and new RuleTemplates.", (long)oldRuleTemplates.size(), (long)newRuleTemplates.size());
        for (RuleTemplateBo oldRuleTemplate : oldRuleTemplates) {
            boolean foundTemplate = false;
            for (RuleTemplateBo newRuleTemplate : newRuleTemplates) {
                if (!oldRuleTemplate.getName().equals(newRuleTemplate.getName())) continue;
                this.assertRuleTemplateExport(oldRuleTemplate, newRuleTemplate);
                foundTemplate = true;
            }
            Assert.assertTrue((String)("Could not locate the new rule template for name " + oldRuleTemplate.getName()), (boolean)foundTemplate);
        }
    }

    private void assertRuleTemplateExport(RuleTemplateBo oldRuleTemplate, RuleTemplateBo newRuleTemplate) {
        Assert.assertFalse((String)"Ids should be different.", (boolean)oldRuleTemplate.getId().equals(newRuleTemplate.getId()));
        Assert.assertEquals((Object)oldRuleTemplate.getDescription(), (Object)newRuleTemplate.getDescription());
        Assert.assertEquals((Object)oldRuleTemplate.getName(), (Object)newRuleTemplate.getName());
        if (oldRuleTemplate.getDelegationTemplate() != null) {
            this.assertRuleTemplateExport(oldRuleTemplate.getDelegationTemplate(), newRuleTemplate.getDelegationTemplate());
        } else {
            Assert.assertNull((Object)newRuleTemplate.getDelegationTemplate());
        }
        this.assertAttributes(oldRuleTemplate.getRuleTemplateAttributes(), newRuleTemplate.getRuleTemplateAttributes(), "attribute");
        this.assertAttributes(oldRuleTemplate.getActiveRuleTemplateAttributes(), newRuleTemplate.getActiveRuleTemplateAttributes(), "active attribute");
        this.assertOptions(oldRuleTemplate.getRuleTemplateOptions(), newRuleTemplate.getRuleTemplateOptions());
    }

    private void assertAttributes(List oldAttributes, List newAttributes, String errorMessageAttributeLabel) {
        Assert.assertEquals((long)oldAttributes.size(), (long)newAttributes.size());
        for (RuleTemplateAttributeBo oldAttribute : oldAttributes) {
            boolean foundAttribute = false;
            for (RuleTemplateAttributeBo newAttribute : newAttributes) {
                if (!oldAttribute.getRuleAttribute().getName().equals(newAttribute.getRuleAttribute().getName())) continue;
                Assert.assertEquals((Object)oldAttribute.getRequired(), (Object)newAttribute.getRequired());
                foundAttribute = true;
            }
            Assert.assertTrue((String)("Could not locate " + errorMessageAttributeLabel + " with name '" + oldAttribute.getRuleAttribute().getName() + "' in new attributes list."), (boolean)foundAttribute);
        }
    }

    private void assertOptions(List oldTemplateOptions, List newTemplateOptions) {
        Assert.assertEquals((long)oldTemplateOptions.size(), (long)newTemplateOptions.size());
        for (RuleTemplateOptionBo oldOption : oldTemplateOptions) {
            boolean foundOption = false;
            for (RuleTemplateOptionBo newOption : newTemplateOptions) {
                if (!oldOption.getCode().equals(newOption.getCode())) continue;
                Assert.assertEquals((Object)oldOption.getValue(), (Object)newOption.getValue());
                foundOption = true;
            }
            Assert.assertTrue((String)"Could not locate rule template option.", (boolean)foundOption);
        }
    }
}

