/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml.export;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jdom.Document;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.style.Style;
import org.kuali.rice.coreservice.impl.style.StyleBo;
import org.kuali.rice.coreservice.impl.style.StyleExportDataSet;
import org.kuali.rice.kew.xml.export.XmlExporterTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class StyleXmlExporterTest
extends XmlExporterTestCase {
    @Override
    public void testExportActionConfig() throws Exception {
    }

    @Override
    public void testExportEngineConfig() throws Exception {
    }

    @Test
    public void testExport() throws Exception {
        this.loadXmlFile("StyleExportConfig.xml");
        this.assertExport();
    }

    @Override
    protected void assertExport() throws Exception {
        List oldStyleNames = CoreServiceApiServiceLocator.getStyleService().getAllStyleNames();
        StyleExportDataSet dataSet = new StyleExportDataSet();
        for (String oldStyleName : oldStyleNames) {
            Style oldStyle = CoreServiceApiServiceLocator.getStyleService().getStyle(oldStyleName);
            Assert.assertNotNull((Object)oldStyle);
            dataSet.getStyles().add(StyleBo.from((Style)oldStyle));
        }
        byte[] xmlBytes = CoreApiServiceLocator.getXmlExporterService().export(dataSet.createExportDataSet());
        Assert.assertTrue((String)"XML should be non empty.", (xmlBytes != null && xmlBytes.length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"XML does not contain exported style", (boolean)new String(xmlBytes).contains("<styles "));
        Assert.assertTrue((String)"XML does not contain exported style", (boolean)new String(xmlBytes).contains("<style name=\"an_arbitrary_style\">"));
        this.loadXmlStream(new BufferedInputStream(new ByteArrayInputStream(xmlBytes)));
        List newStyleNames = CoreServiceApiServiceLocator.getStyleService().getAllStyleNames();
        Assert.assertEquals((String)"Should have same number of old and new Styles.", (long)oldStyleNames.size(), (long)newStyleNames.size());
        for (String oldStyleName : oldStyleNames) {
            Style oldStyleEntry = CoreServiceApiServiceLocator.getStyleService().getStyle(oldStyleName);
            Assert.assertNotNull((Object)oldStyleEntry);
            boolean foundAttribute = false;
            for (String newStyleName : newStyleNames) {
                if (!oldStyleEntry.getName().equals(newStyleName)) continue;
                Style newStyleEntry = CoreServiceApiServiceLocator.getStyleService().getStyle(newStyleName);
                Assert.assertNotNull((Object)newStyleEntry);
                Assert.assertEquals((Object)this.canonicalize(oldStyleEntry.getXmlContent()), (Object)this.canonicalize(newStyleEntry.getXmlContent()));
                foundAttribute = true;
            }
            Assert.assertTrue((String)("Could not locate the new style for name " + oldStyleEntry.getName()), (boolean)foundAttribute);
        }
    }

    private String canonicalize(String xml) throws Exception {
        Document document = XmlHelper.buildJDocument((Reader)new StringReader(xml));
        return XmlJotter.jotDocument((Document)document);
    }
}

