/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.impl.style;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.impex.xml.XmlIngestionException;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.style.Style;
import org.kuali.rice.coreservice.api.style.StyleService;
import org.kuali.rice.coreservice.impl.CoreServiceImplServiceLocator;
import org.kuali.rice.coreservice.impl.style.StyleXmlParser;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class StyleServiceImplTest
extends KEWTestCase {
    private static final Logger LOG = LogManager.getLogger(StyleServiceImplTest.class);

    @Test
    public void testLoadXML() throws FileNotFoundException {
        this.loadXmlFile("style.xml");
        StyleService styleService = CoreServiceApiServiceLocator.getStyleService();
        Assert.assertNotNull((String)"Style 'an_arbitrary_style' not found", (Object)styleService.getStyle("an_arbitrary_style"));
        Style style = styleService.getStyle("an_arbitrary_style");
        Assert.assertNotNull((String)"'an_arbitrary_style' style not found", (Object)style);
        Assert.assertEquals((Object)"an_arbitrary_style", (Object)style.getName());
        Assert.assertTrue((boolean)style.isActive());
        Assert.assertNotNull((Object)style.getXmlContent());
    }

    @Test
    public void testLoadingFromConfiguredFile() {
        StyleService styleService = CoreServiceApiServiceLocator.getStyleService();
        String notThereStyle = "gidgets";
        String isThereStyle = "widgets";
        List styleNames = styleService.getAllStyleNames();
        Assert.assertFalse((String)("Style should not exist in database: " + notThereStyle), (boolean)styleNames.contains(notThereStyle));
        Assert.assertFalse((String)("Style should not exist in database: " + isThereStyle), (boolean)styleNames.contains(isThereStyle));
        try {
            styleService.getStyle(notThereStyle);
            Assert.fail((String)("should have thrown " + RiceRuntimeException.class.getSimpleName()));
        }
        catch (RiceRuntimeException e) {
            LOG.info("^^^ CAUGHT EXPECTED EXCEPTION ^^^");
        }
        catch (Exception e) {
            Assert.fail((String)("Wrong exception type '" + e.getClass() + "', should have been '" + RiceRuntimeException.class.getCanonicalName() + "'"));
        }
        Style style = styleService.getStyle("widgets");
        Assert.assertNotNull((Object)style);
    }

    @Test
    public void testInclusions() throws FileNotFoundException, TransformerConfigurationException, TransformerException {
        this.loadXmlFile("style.xml");
        StyleService styleService = CoreServiceApiServiceLocator.getStyleService();
        StringWriter w = new StringWriter();
        StreamResult result = new StreamResult(w);
        Templates t = styleService.getStyleAsTranslet("test_includer2");
        t.newTransformer().transform(new StreamSource(new StringReader("<a/>")), result);
        Assert.assertEquals((Object)"oneoneoneoneone", (Object)((Object)w).toString());
        w = new StringWriter();
        result = new StreamResult(w);
        t.newTransformer().transform(new StreamSource(new StringReader("<b/>")), result);
        Assert.assertEquals((Object)"22222", (Object)((Object)w).toString());
        w = new StringWriter();
        result = new StreamResult(w);
        t = styleService.getStyleAsTranslet("test_importer");
        t.newTransformer().transform(new StreamSource(new StringReader("<a/>")), result);
        Assert.assertEquals((Object)"aaaaa", (Object)((Object)w).toString());
        w = new StringWriter();
        result = new StreamResult(w);
        t.newTransformer().transform(new StreamSource(new StringReader("<b/>")), result);
        Assert.assertEquals((Object)"BBBBB", (Object)((Object)w).toString());
        w = new StringWriter();
        result = new StreamResult(w);
        t.newTransformer().transform(new StreamSource(new StringReader("<c/>")), result);
        Assert.assertEquals((Object)"CCCCC", (Object)((Object)w).toString());
    }

    @Test
    public void testLoadBadDefinition() throws FileNotFoundException {
        StyleXmlParser xmlLoader = CoreServiceImplServiceLocator.getStyleXmlLoader();
        try {
            xmlLoader.loadXml(TestUtilities.loadResource(((Object)((Object)this)).getClass(), "badstyle.xml"), null);
            Assert.fail((String)"BadDefinition was successfully parsed.");
        }
        catch (XmlIngestionException re) {
            Assert.assertTrue((String)("Wrong exception occurred: " + (Object)((Object)re)), (boolean)re.getMessage().contains("Style 'style' element must contain a 'xsl:stylesheet' child element"));
        }
    }

    @Test
    public void testStoreStyle() {
        StyleService styleService = CoreServiceApiServiceLocator.getStyleService();
        StyleXmlParser xmlLoader = CoreServiceImplServiceLocator.getStyleXmlLoader();
        String styleXml = "<data xmlns=\"ns:workflow\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"ns:workflow resource:WorkflowData\"><styles xmlns=\"ns:workflow/Style\" xsi:schemaLocation=\"ns:workflow/Style resource:Style\"><style></style></styles></data>";
        try {
            xmlLoader.loadXml((InputStream)new ByteArrayInputStream(styleXml.getBytes()), null);
            Assert.fail((String)"Storing style with no name succeeded");
        }
        catch (XmlIngestionException xmlIngestionException) {
            // empty catch block
        }
        styleXml = "<data xmlns=\"ns:workflow\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"ns:workflow resource:WorkflowData\"><styles xmlns=\"ns:workflow/Style\" xsi:schemaLocation=\"ns:workflow/Style resource:Style\"><style name=\"test\"></style></styles></data>";
        try {
            xmlLoader.loadXml((InputStream)new ByteArrayInputStream(styleXml.getBytes()), null);
            Assert.fail((String)"Storing style with no xsl:stylesheet element succeeded");
        }
        catch (XmlIngestionException xmlIngestionException) {
            // empty catch block
        }
        styleXml = "<data xmlns=\"ns:workflow\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"ns:workflow resource:WorkflowData\"><styles xmlns=\"ns:workflow/Style\" xsi:schemaLocation=\"ns:workflow/Style resource:Style\"><style name=\"test\"><xsl:stylesheet></xsl:stylesheet></style></styles></data>";
        xmlLoader.loadXml((InputStream)new ByteArrayInputStream(styleXml.getBytes()), null);
        Style style = styleService.getStyle("test");
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((Object)"test", (Object)style.getName());
        Assert.assertNotNull((Object)style);
        Assert.assertNotNull((Object)style.getXmlContent());
    }

    @Override
    protected List<String> getPerTestTablesToClear() {
        List<String> tablesToClear = super.getPerTestTablesToClear();
        tablesToClear.add("KRCR_STYLE_T");
        return tablesToClear;
    }
}

