/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mocks.MockDocumentRefreshQueueImpl;
import mocks.MockEmailNotificationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.service.impl.NotificationSuppression;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestContract;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class NotificationSuppressionTest
extends KEWTestCase {
    private static final String TEST_RULE_TEMPLATE = "WorkflowDocumentTemplate";
    private static final String TEST_DOC_TYPE = "NotificationSuppressionTestDocType";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("NotificationSuppressionTestConfig.xml");
    }

    @Test
    public void testNotificationSuppressionKeys() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)TEST_DOC_TYPE);
        document.route("");
        List requests = document.getRootActionRequests();
        Assert.assertTrue((String)"there must be ActionRequestDTOs to test!", (requests != null && requests.size() > 0 ? 1 : 0) != 0);
        NotificationSuppression notificationSuppression = new NotificationSuppression();
        boolean atLeastOne = false;
        for (ActionRequest reqDTO : requests) {
            if (reqDTO.getParentActionRequestId() != null) continue;
            atLeastOne = true;
            ActionRequestValue reqVal = ActionRequestValue.from((ActionRequest)reqDTO);
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)notificationSuppression.getSuppressNotifyNodeStateKeys(reqVal), (Collection)notificationSuppression.getSuppressNotifyNodeStateKeys(reqDTO)));
            ActionRequest.Builder builder = ActionRequest.Builder.create((ActionRequestContract)reqDTO);
            builder.setPrincipalId("asdf");
            reqDTO = builder.build();
            Assert.assertFalse((boolean)CollectionUtils.isEqualCollection((Collection)notificationSuppression.getSuppressNotifyNodeStateKeys(reqVal), (Collection)notificationSuppression.getSuppressNotifyNodeStateKeys(reqDTO)));
        }
        Assert.assertTrue((boolean)atLeastOne);
    }

    @Test
    public void testActionItemFiltering() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)TEST_DOC_TYPE);
        document.route("");
        List requests = document.getRootActionRequests();
        Assert.assertTrue((String)"there must be ActionRequestDTOs to test!", (requests != null && requests.size() > 0 ? 1 : 0) != 0);
        NotificationSuppression notificationSuppression = new NotificationSuppression();
        boolean atLeastOne = false;
        for (ActionRequest reqDTO : requests) {
            if (reqDTO.getParentActionRequestId() != null) continue;
            atLeastOne = true;
            ActionRequestValue reqVal = ActionRequestValue.from((ActionRequest)reqDTO);
            ArrayList<ActionItem> actionItems = new ArrayList<ActionItem>();
            actionItems.add(KEWServiceLocator.getActionListService().createActionItemForActionRequest(reqVal));
            RouteNodeInstance routeNodeInstance = new RouteNodeInstance();
            int actionItemsCount = actionItems.size();
            notificationSuppression.filterNotificationSuppressedActionItems(actionItems, routeNodeInstance);
            Assert.assertTrue((actionItemsCount == actionItems.size() ? 1 : 0) != 0);
            notificationSuppression.addNotificationSuppression(routeNodeInstance, reqVal);
            notificationSuppression.filterNotificationSuppressedActionItems(actionItems, routeNodeInstance);
            Assert.assertTrue((actionItems.size() == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)atLeastOne);
    }

    @Test
    public void testSuppression() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)TEST_DOC_TYPE);
        document.route("");
        Assert.assertTrue((String)"the responsible party should have been notified", (1 == this.getMockEmailService().immediateReminderEmailsSent("user1", document.getDocumentId(), "C") ? 1 : 0) != 0);
        this.getMockEmailService().resetReminderCounts();
        List existingRules = KEWServiceLocator.getRuleService().fetchAllCurrentRulesForTemplateDocCombination(TEST_RULE_TEMPLATE, TEST_DOC_TYPE);
        Assert.assertNotNull((Object)existingRules);
        Assert.assertEquals((long)1L, (long)existingRules.size());
        RuleBaseValues originalRule = (RuleBaseValues)existingRules.get(0);
        Assert.assertTrue((String)"Original rule should be current.", (boolean)originalRule.getCurrentInd());
        List originalResps = originalRule.getRuleResponsibilities();
        Assert.assertEquals((long)1L, (long)originalResps.size());
        RuleResponsibilityBo originalResp = (RuleResponsibilityBo)originalResps.get(0);
        RuleTemplateBo ruleTemplate = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(TEST_RULE_TEMPLATE);
        Assert.assertNotNull((Object)ruleTemplate);
        Assert.assertNotNull((Object)ruleTemplate.getId());
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)ruleTemplate.getName()));
        RuleDelegationBo ruleDelegation = new RuleDelegationBo();
        ruleDelegation.setResponsibilityId(originalResp.getResponsibilityId());
        ruleDelegation.setDelegationType(DelegationType.PRIMARY);
        RuleBaseValues rule = new RuleBaseValues();
        ruleDelegation.setDelegationRule(rule);
        rule.setDelegateRule(Boolean.valueOf(true));
        rule.setActive(true);
        rule.setCurrentInd(Boolean.valueOf(true));
        rule.setDocTypeName(originalRule.getDocTypeName());
        rule.setRuleTemplateId(ruleTemplate.getDelegationTemplateId());
        rule.setRuleTemplate(ruleTemplate);
        rule.setDescription("Description of this delegate rule");
        rule.setForceAction(true);
        RuleResponsibilityBo delegationResponsibility = new RuleResponsibilityBo();
        rule.getRuleResponsibilities().add(delegationResponsibility);
        delegationResponsibility.setRuleBaseValues(rule);
        delegationResponsibility.setRuleResponsibilityName("user2");
        delegationResponsibility.setRuleResponsibilityType("F");
        this.getMockEmailService().resetReminderCounts();
        MockDocumentRefreshQueueImpl.clearRequeuedDocumentIds();
        KEWServiceLocator.getRuleService().saveRuleDelegation(ruleDelegation, true);
        Assert.assertTrue((String)"document should have been requeued", (boolean)MockDocumentRefreshQueueImpl.getRequeuedDocumentIds().contains(document.getDocumentId()));
        Assert.assertTrue((String)"should have notified user2", (1 == this.getMockEmailService().immediateReminderEmailsSent("user2", document.getDocumentId(), "C") ? 1 : 0) != 0);
        Assert.assertTrue((String)"the responsible party that is delegating should not be notified", (0 == this.getMockEmailService().immediateReminderEmailsSent("user1", document.getDocumentId(), "C") ? 1 : 0) != 0);
        this.getMockEmailService().resetReminderCounts();
        MockDocumentRefreshQueueImpl.clearRequeuedDocumentIds();
        String applicationId = KEWServiceLocator.getRouteHeaderService().getApplicationIdByDocumentId(document.getDocumentId());
        KewApiServiceLocator.getDocumentRequeuerService((String)(applicationId != null ? applicationId : CoreConfigHelper.getApplicationId()), (String)document.getDocumentId(), (long)0L).refreshDocument(document.getDocumentId());
        Assert.assertTrue((String)"nobody should have been notified", (0 == this.getMockEmailService().immediateReminderEmailsSent("user2", document.getDocumentId(), "C") ? 1 : 0) != 0);
        Assert.assertTrue((String)"nobody should have been notified", (0 == this.getMockEmailService().immediateReminderEmailsSent("user1", document.getDocumentId(), "C") ? 1 : 0) != 0);
        this.getMockEmailService().resetReminderCounts();
    }

    private MockEmailNotificationService getMockEmailService() {
        return (MockEmailNotificationService)KEWServiceLocator.getActionListEmailService();
    }
}

