/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.AdHocToPrincipal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class AdHocRouteTest
extends KEWTestCase {
    private static final String ADHOC_DOC = "AdhocRouteTest";
    private static final String ADHOC_NO_NODE_DOC = "AdHocNoNodeTest";
    private static final String ADHOC_PRIORITY_PARALLEL_DOC = "AdhocRouteTest-PriorityParallel";
    private String docId;

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testRequestLabel() throws Exception {
        String note = "test note";
        Person per = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("rkirkend");
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)per.getPrincipalId(), (String)ADHOC_DOC);
        this.docId = doc.getDocumentId();
        doc.adHocToPrincipal(ActionRequestType.FYI, "AdHoc", "annotation1", this.getPrincipalIdForName("dewey"), "respDesc1", false, note);
        doc = this.getDocument(per.getPrincipalId(), this.docId);
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(this.docId);
        for (ActionRequestValue arv : actionRequests) {
            Assert.assertTrue((String)("The note we passed in should equal the one we get out. note=[" + note + "]"), (boolean)note.equals(arv.getRequestLabel()));
        }
    }

    @Test
    public void testParallelAdHocRouting() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)ADHOC_DOC);
        this.docId = doc.getDocumentId();
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "annotation1", this.getPrincipalIdForName("dewey"), "respDesc1", false);
        doc = this.getDocument("dewey");
        Assert.assertFalse((String)"User andlee should not have an approve request yet.  Document not yet routed.", (boolean)doc.isApprovalRequested());
        doc.adHocToGroup(ActionRequestType.APPROVE, "AdHoc", "annotation2", this.getGroupIdForName("KR-WKFLW", "WorkflowAdmin"), "respDesc2", true);
        doc = this.getDocument("quickstart");
        Assert.assertFalse((String)"User should not have approve request yet.  Document not yet routed.", (boolean)doc.isApprovalRequested());
        doc = this.getDocument("rkirkend");
        doc.route("");
        List actionRequests = doc.getRootActionRequests();
        for (ActionRequest actionRequest : actionRequests) {
            Assert.assertTrue((String)"Request should be an adhoc request.", (boolean)actionRequest.isAdHocRequest());
        }
        WorkflowDocument deweyDoc = this.getDocument("dewey");
        Assert.assertTrue((String)"Dewey should have an approve request", (boolean)deweyDoc.isApprovalRequested());
        doc = this.getDocument("ewestfal");
        Assert.assertTrue((String)"WorkflowAdmin should have an approve request", (boolean)doc.isApprovalRequested());
        deweyDoc.approve("");
        doc.approve("");
        doc = this.getDocument("user1");
        doc.approve("");
        Assert.assertTrue((String)"The document should be final", (boolean)doc.isFinal());
    }

    @Test
    public void testAdHocToInitiator() throws Exception {
        String ADHOC_NODE = "AdHoc";
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)ADHOC_DOC);
        this.docId = doc.getDocumentId();
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "annotation1", this.getPrincipalIdForName("rkirkend"), "", true);
        doc.route("");
        Assert.assertTrue((boolean)doc.isEnroute());
        doc = this.getDocument("rkirkend");
        Assert.assertTrue((String)"rkirkend should have an approval request on the document", (boolean)doc.isApprovalRequested());
        TestUtilities.assertAtNodeNew(doc, "AdHoc");
        doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)ADHOC_DOC);
        this.docId = doc.getDocumentId();
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "annotation1", this.getPrincipalIdForName("rkirkend"), "", false);
        doc.route("");
        Assert.assertTrue((boolean)doc.isEnroute());
        doc = this.getDocument("rkirkend");
        Assert.assertFalse((String)"rkirkend should NOT have an approval request on the document", (boolean)doc.isApprovalRequested());
        TestUtilities.assertAtNodeNew(doc, "One");
        doc = this.getDocument("user1");
        Assert.assertTrue((String)"user1 should have an approval request on the document", (boolean)doc.isApprovalRequested());
    }

    @Test
    public void testSerialAdHocRouting() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)ADHOC_DOC);
        this.docId = doc.getDocumentId();
        doc.route("");
        doc = this.getDocument("user1");
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "One", "annotation1", this.getPrincipalIdForName("user2"), "", false);
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "One", "annotation1", this.getPrincipalIdForName("rkirkend"), "", true);
        doc.approve("");
        doc = this.getDocument("rkirkend");
        Assert.assertFalse((String)"rkirkend should not have the document at this point 'S' activation", (boolean)doc.isApprovalRequested());
        doc = this.getDocument("user2");
        Assert.assertTrue((String)"user2 should have an approve request", (boolean)doc.isApprovalRequested());
        doc.approve("");
        doc = this.getDocument("rkirkend");
        doc.approve("");
        Assert.assertTrue((String)"The document should be final", (boolean)doc.isFinal());
    }

    @Test
    public void testRepeatedAdHocRouting() throws Exception {
        String ADHOC_NODE = "AdHoc";
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)ADHOC_DOC);
        this.docId = doc.getDocumentId();
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "annotation1", this.getPrincipalIdForName("user2"), "", false);
        doc.route("");
        doc = this.getDocument("rkirkend");
        Assert.assertFalse((String)"rkirkend should NOT have an approval request on the document", (boolean)doc.isApprovalRequested());
        doc = this.getDocument("user1");
        Assert.assertFalse((String)"user1 should NOT have an approval request on the document", (boolean)doc.isApprovalRequested());
        doc = this.getDocument("user2");
        Assert.assertTrue((String)"user2 should have an approval request on document", (boolean)doc.isApprovalRequested());
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "annotation1", this.getPrincipalIdForName("user3"), "", false);
        doc.approve("");
        doc = this.getDocument("user2");
        Assert.assertFalse((String)"user2 should NOT have an approval request on the document", (boolean)doc.isApprovalRequested());
        doc = this.getDocument("user3");
        Assert.assertTrue((String)"user3 should have an approval request on document", (boolean)doc.isApprovalRequested());
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "annotation1", this.getPrincipalIdForName("rkirkend"), "", true);
        doc.approve("");
        doc = this.getDocument("user3");
        Assert.assertFalse((String)"user3 should NOT have an approval request on the document", (boolean)doc.isApprovalRequested());
        doc = this.getDocument("rkirkend");
        Assert.assertTrue((String)"rkirkend should have an approval request on document", (boolean)doc.isApprovalRequested());
        doc.approve("");
        doc = this.getDocument("rkirkend");
        Assert.assertFalse((String)"rkirkend should NOT have an approval request on the document", (boolean)doc.isApprovalRequested());
        doc = this.getDocument("user1");
        Assert.assertTrue((String)"user1 should have an approval request on document", (boolean)doc.isApprovalRequested());
        doc.approve("");
        doc = this.getDocument("user1");
        Assert.assertFalse((String)"user1 should NOT have an approval request on the document", (boolean)doc.isApprovalRequested());
        doc = this.getDocument("rkirkend");
        Assert.assertFalse((String)"rkirkend should NOT have an approval request on the document", (boolean)doc.isApprovalRequested());
        doc = this.getDocument("user2");
        Assert.assertFalse((String)"user2 should NOT have an approval request on the document", (boolean)doc.isApprovalRequested());
        doc = this.getDocument("user3");
        Assert.assertFalse((String)"user3 should NOT have an approval request on the document", (boolean)doc.isApprovalRequested());
        Assert.assertTrue((String)"The document should be final", (boolean)doc.isFinal());
    }

    @Test
    public void testAdHocWhenDocumentIsInitiated() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TakeWorkgroupAuthorityDoc");
        document.saveDocumentData();
        Assert.assertTrue((boolean)document.isInitiated());
        document.adHocToPrincipal(ActionRequestType.APPROVE, "My Annotation", this.getPrincipalIdForName("rkirkend"), "", true);
        document.adHocToPrincipal(ActionRequestType.FYI, "My Annotation", this.getPrincipalIdForName("user1"), "", true);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertFalse((boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)document.getDocumentId());
        Assert.assertFalse((boolean)document.isFYIRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isFYIRequested());
    }

    @Test
    public void testAdHocWhenDocumentIsFinal() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TakeWorkgroupAuthorityDoc");
        document.route("");
        TestUtilities.assertAtNodeNew(document, "WorkgroupByDocument");
        try {
            document.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "", this.getPrincipalIdForName("ewestfal"), "", true);
            Assert.fail((String)"document should not be allowed to route to nodes that are complete");
        }
        catch (Exception exception) {
            // empty catch block
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have request", (boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((String)"Document should be final", (boolean)document.isFinal());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)document.getDocumentId());
        List requests = document.getRootActionRequests();
        for (ActionRequest request : requests) {
            if (!request.isActivated()) continue;
            Assert.fail((String)"Active requests should not be present on a final document");
        }
        try {
            document.adHocToPrincipal(ActionRequestType.APPROVE, "WorkgroupByDocument", "", this.getPrincipalIdForName("ewestfal"), "", true);
            Assert.fail((String)"Should not be allowed to adhoc approve to a final document.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertFalse((String)"rkirkend should not have an FYI request.", (boolean)document.isFYIRequested());
        document.adHocToPrincipal(ActionRequestType.FYI, "WorkgroupByDocument", "", this.getPrincipalIdForName("rkirkend"), "", true);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have an FYI request", (boolean)document.isFYIRequested());
    }

    @Test
    public void testAdHocWhenDocumentIsSaved() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TakeWorkgroupAuthorityDoc");
        document.saveDocument("");
        Assert.assertTrue((String)"Document should be saved.", (boolean)document.isSaved());
        document.adHocToPrincipal(ActionRequestType.FYI, "AdHoc", "", this.getPrincipalIdForName("rkirkend"), "", true);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have an FYI request", (boolean)document.isFYIRequested());
    }

    @Test
    public void testAdHocFieldsSavedCorrectly() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)ADHOC_DOC);
        this.docId = doc.getDocumentId();
        doc.route("");
        ArrayList<String> oldRequestIds = new ArrayList<String>();
        Iterator iterator = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(doc.getDocumentId()).iterator();
        while (iterator.hasNext()) {
            oldRequestIds.add(((ActionRequestValue)iterator.next()).getActionRequestId());
        }
        doc = this.getDocument("user1");
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "One", "annotation1", this.getPrincipalIdForName("user2"), "respDesc", false);
        ActionRequestValue request = null;
        for (ActionRequestValue actionRequest : KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(doc.getDocumentId())) {
            if (oldRequestIds.contains(actionRequest.getActionRequestId())) continue;
            request = actionRequest;
            break;
        }
        Assert.assertNotNull((String)"Could not find adhoc routed action request", request);
        Assert.assertEquals((String)"wrong person", (Object)request.getPrincipalId(), (Object)this.getPrincipalIdForName("user2"));
        Assert.assertEquals((String)"annotation incorrect", (Object)"annotation1", (Object)request.getAnnotation());
        Assert.assertEquals((String)"action requested code incorrect", (Object)request.getActionRequested(), (Object)ActionRequestType.APPROVE.getCode());
        Assert.assertEquals((String)"responsibility desc incorrect", (Object)request.getResponsibilityDesc(), (Object)"respDesc");
        Assert.assertEquals((String)"wrong force action", (Object)request.getForceAction(), (Object)Boolean.FALSE);
    }

    @Test
    public void testAdHocDissaprovedDocument() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)ADHOC_DOC);
        this.docId = doc.getDocumentId();
        doc.route("");
        doc = this.getDocument("user1");
        TestUtilities.assertAtNodeNew(doc, "One");
        doc.disapprove("");
        TestUtilities.assertAtNodeNew(doc, "One");
        doc.adHocToPrincipal(ActionRequestType.FYI, "One", "", this.getPrincipalIdForName("rkirkend"), "", true);
        doc.adHocToPrincipal(ActionRequestType.ACKNOWLEDGE, "One", "", this.getPrincipalIdForName("user2"), "", true);
        doc = this.getDocument("rkirkend");
        Assert.assertTrue((boolean)doc.isFYIRequested());
        doc.fyi();
        doc = this.getDocument("user2");
        Assert.assertTrue((boolean)doc.isAcknowledgeRequested());
        doc.acknowledge("");
        doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)ADHOC_DOC);
        this.docId = doc.getDocumentId();
        doc.route("");
        doc = this.getDocument("user1");
        doc.disapprove("");
        try {
            doc.adHocToPrincipal(ActionRequestType.APPROVE, "One", "", this.getPrincipalIdForName("rkirkend"), "", true);
            Assert.fail((String)"should have thrown exception cant adhoc approvals on dissaproved documents");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            doc.adHocToPrincipal(ActionRequestType.COMPLETE, "One", "", this.getPrincipalIdForName("rkirkend"), "", true);
            Assert.fail((String)"should have thrown exception cant ad hoc completes on dissaproved documents");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            doc.adHocToPrincipal(ActionRequestType.ACKNOWLEDGE, "", this.getPrincipalIdForName("user1"), "", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"should have thrown exception cant ad hoc completes on dissaproved documents");
        }
        try {
            doc.adHocToPrincipal(ActionRequestType.FYI, "", this.getPrincipalIdForName("user1"), "", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"should have thrown exception cant ad hoc completes on dissaproved documents");
        }
    }

    @Test
    public void testAdHocNoNodeName() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)ADHOC_DOC);
        this.docId = doc.getDocumentId();
        doc.adHocToPrincipal(ActionRequestType.APPROVE, "", this.getPrincipalIdForName("jitrue"), "", false);
        doc.adHocToGroup(ActionRequestType.APPROVE, "", this.getGroupIdForName("KR-WKFLW", "NonSIT"), "", false);
        doc.route("");
        doc = this.getDocument("user1");
        Assert.assertFalse((boolean)doc.isApprovalRequested());
        doc = this.getDocument("jitrue");
        Assert.assertTrue((boolean)doc.isApprovalRequested());
        TestUtilities.assertAtNodeNew(doc, "AdHoc");
        doc = this.getDocument("jitrue");
        TestUtilities.assertAtNodeNew(doc, "AdHoc");
        doc.disapprove("");
        TestUtilities.assertAtNodeNew(doc, "AdHoc");
        Assert.assertTrue((boolean)doc.isDisapproved());
        doc.adHocToPrincipal(ActionRequestType.FYI, "", this.getPrincipalIdForName("rkirkend"), "", true);
        doc.adHocToPrincipal(ActionRequestType.ACKNOWLEDGE, "", this.getPrincipalIdForName("user2"), "", true);
        doc.adHocToGroup(ActionRequestType.ACKNOWLEDGE, "", this.getGroupIdForName("KR-WKFLW", "NonSIT"), "", true);
        doc = this.getDocument("rkirkend");
        Assert.assertTrue((boolean)doc.isFYIRequested());
        doc.fyi();
        doc = this.getDocument("user3");
        Assert.assertTrue((boolean)doc.isAcknowledgeRequested());
        doc = this.getDocument("user2");
        Assert.assertTrue((boolean)doc.isAcknowledgeRequested());
        doc.acknowledge("");
        doc = this.getDocument("user3");
        Assert.assertFalse((boolean)doc.isAcknowledgeRequested());
        doc = this.getDocument("user1");
        Assert.assertTrue((boolean)doc.isAcknowledgeRequested());
        doc.acknowledge("");
        TestUtilities.assertNumberOfPendingRequests(doc.getDocumentId(), 0);
        try {
            doc.adHocToPrincipal(ActionRequestType.APPROVE, "", this.getPrincipalIdForName("rkirkend"), "", true);
            Assert.fail((String)"should have thrown exception cant adhoc approvals on dissaproved documents");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            doc.adHocToPrincipal(ActionRequestType.COMPLETE, "", this.getPrincipalIdForName("rkirkend"), "", true);
            Assert.fail((String)"should have thrown exception cant ad hoc completes on dissaproved documents");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAdHocWithRequestLabel_ToPrincipal() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)ADHOC_DOC);
        String label = "MY PRINCIPAL LABEL";
        doc.adHocToPrincipal(ActionRequestType.APPROVE, null, "", this.getPrincipalIdForName("ewestfal"), "", true, label);
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(doc.getDocumentId());
        Assert.assertEquals((String)"Shoudl have 1 request.", (long)1L, (long)actionRequests.size());
        ActionRequestValue actionRequest = (ActionRequestValue)actionRequests.get(0);
        Assert.assertEquals((String)"Should be an approve request", (Object)ActionRequestType.APPROVE.getCode(), (Object)actionRequest.getActionRequested());
        Assert.assertEquals((String)"Invalid request label", (Object)label, (Object)actionRequest.getRequestLabel());
        Assert.assertEquals((String)"Request should be initialized", (Object)ActionRequestStatus.INITIALIZED.getCode(), (Object)actionRequest.getStatus());
        doc.route("");
        Collection actionItems = KEWServiceLocator.getActionListService().getActionListForSingleDocument(doc.getDocumentId());
        Assert.assertEquals((String)"Should have 1 action item.", (long)1L, (long)actionItems.size());
        ActionItem actionItem = (ActionItem)actionItems.iterator().next();
        Assert.assertEquals((String)"ActionItem should be constructed from request.", (Object)actionRequest.getActionRequestId(), (Object)actionItem.getActionRequestId());
        Assert.assertEquals((String)"ActionItem should have same label", (Object)label, (Object)actionItem.getRequestLabel());
    }

    @Test
    public void testAdHocWithRequestLabel_ToGroup() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)ADHOC_DOC);
        String label = "MY GROUP LABEL";
        Group workflowAdmin = KEWServiceLocator.getIdentityHelperService().getGroupByName("KR-WKFLW", "WorkflowAdmin");
        doc.adHocToGroup(ActionRequestType.APPROVE, null, "", workflowAdmin.getId(), "", true, label);
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(doc.getDocumentId());
        Assert.assertEquals((String)"Should have 1 request.", (long)1L, (long)actionRequests.size());
        ActionRequestValue actionRequest = (ActionRequestValue)actionRequests.get(0);
        Assert.assertEquals((String)"Should be an approve request", (Object)ActionRequestType.APPROVE.getCode(), (Object)actionRequest.getActionRequested());
        Assert.assertEquals((String)"Invalid request label", (Object)label, (Object)actionRequest.getRequestLabel());
        Assert.assertEquals((String)"Request should be initialized", (Object)ActionRequestStatus.INITIALIZED.getCode(), (Object)actionRequest.getStatus());
        doc.route("");
        Collection actionItems = KEWServiceLocator.getActionListService().getActionListForSingleDocument(doc.getDocumentId());
        Assert.assertTrue((String)"Should have more than 1 action item.", (actionItems.size() > 1 ? 1 : 0) != 0);
        for (ActionItem actionItem : actionItems) {
            Assert.assertEquals((String)"ActionItem should be constructed from request.", (Object)actionRequest.getActionRequestId(), (Object)actionItem.getActionRequestId());
            Assert.assertEquals((String)"ActionItem should have same label", (Object)label, (Object)actionItem.getRequestLabel());
        }
    }

    @Test
    public void testAdHocWithNoNodes() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)ADHOC_NO_NODE_DOC);
        String label = "MY PRINCIPAL LABEL";
        doc.adHocToPrincipal(ActionRequestType.FYI, null, "", this.getPrincipalIdForName("ewestfal"), "", true, label);
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(doc.getDocumentId());
        Assert.assertEquals((String)"Should have 1 request.", (long)1L, (long)actionRequests.size());
        ActionRequestValue actionRequest = (ActionRequestValue)actionRequests.get(0);
        Assert.assertEquals((String)"Should be a FYI request", (Object)ActionRequestType.FYI.getCode(), (Object)actionRequest.getActionRequested());
        Assert.assertEquals((String)"Invalid request label", (Object)label, (Object)actionRequest.getRequestLabel());
        Assert.assertEquals((String)"Request should be initialized", (Object)ActionRequestStatus.INITIALIZED.getCode(), (Object)actionRequest.getStatus());
        doc.route("");
        Collection actionItems = KEWServiceLocator.getActionListService().getActionListForSingleDocument(doc.getDocumentId());
        Assert.assertEquals((String)"Should have 0 action item.", (long)0L, (long)actionItems.size());
    }

    @Test
    public void testAdHocWithPriorityParallelActivation() throws Exception {
        String user1 = this.getPrincipalIdForName("user1");
        String user2 = this.getPrincipalIdForName("user2");
        String user3 = this.getPrincipalIdForName("user3");
        String testuser1 = this.getPrincipalIdForName("testuser1");
        String testuser2 = this.getPrincipalIdForName("testuser2");
        String testuser3 = this.getPrincipalIdForName("testuser3");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)user1, (String)ADHOC_PRIORITY_PARALLEL_DOC);
        AdHocToPrincipal.Builder adHocToPrincipal = AdHocToPrincipal.Builder.create((ActionRequestType)ActionRequestType.ACKNOWLEDGE, null, (String)user2);
        adHocToPrincipal.setPriority(Integer.valueOf(1));
        document.adHocToPrincipal(adHocToPrincipal.build(), "");
        adHocToPrincipal.setPriority(Integer.valueOf(2));
        adHocToPrincipal.setActionRequested(ActionRequestType.APPROVE);
        adHocToPrincipal.setTargetPrincipalId(user3);
        document.adHocToPrincipal(adHocToPrincipal.build(), "");
        adHocToPrincipal.setTargetPrincipalId(testuser1);
        document.adHocToPrincipal(adHocToPrincipal.build(), "");
        adHocToPrincipal.setActionRequested(ActionRequestType.ACKNOWLEDGE);
        adHocToPrincipal.setTargetPrincipalId(testuser2);
        document.adHocToPrincipal(adHocToPrincipal.build(), "");
        adHocToPrincipal.setPriority(Integer.valueOf(3));
        adHocToPrincipal.setActionRequested(ActionRequestType.FYI);
        adHocToPrincipal.setTargetPrincipalId(testuser3);
        document.adHocToPrincipal(adHocToPrincipal.build(), "");
        document.route("");
        Assert.assertTrue((boolean)document.isEnroute());
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should have 5 root action requests", (long)5L, (long)rootActionRequests.size());
        ActionRequest user2Request = null;
        ActionRequest user3Request = null;
        ActionRequest testuser1Request = null;
        ActionRequest testuser2Request = null;
        ActionRequest testuser3Request = null;
        for (ActionRequest actionRequest : rootActionRequests) {
            if (user2.equals(actionRequest.getPrincipalId())) {
                user2Request = actionRequest;
                continue;
            }
            if (user3.equals(actionRequest.getPrincipalId())) {
                user3Request = actionRequest;
                continue;
            }
            if (testuser1.equals(actionRequest.getPrincipalId())) {
                testuser1Request = actionRequest;
                continue;
            }
            if (testuser2.equals(actionRequest.getPrincipalId())) {
                testuser2Request = actionRequest;
                continue;
            }
            if (!testuser3.equals(actionRequest.getPrincipalId())) continue;
            testuser3Request = actionRequest;
        }
        Assert.assertNotNull(user2Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user2Request.getStatus());
        Assert.assertNotNull(user3Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user3Request.getStatus());
        Assert.assertNotNull(testuser1Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)testuser1Request.getStatus());
        Assert.assertNotNull(testuser2Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)testuser2Request.getStatus());
        Assert.assertNotNull(testuser3Request);
        Assert.assertEquals((Object)ActionRequestStatus.INITIALIZED, (Object)testuser3Request.getStatus());
        document.switchPrincipal(user3);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        document.switchPrincipal(testuser3);
        Assert.assertFalse((boolean)document.isFYIRequested());
        document.switchPrincipal(testuser1);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isProcessed());
        document.switchPrincipal(testuser3);
        Assert.assertTrue((boolean)document.isFYIRequested());
        document.fyi();
        Assert.assertTrue((boolean)document.isProcessed());
        document.switchPrincipal(user2);
        Assert.assertTrue((boolean)document.isAcknowledgeRequested());
        document.acknowledge("");
        Assert.assertTrue((boolean)document.isProcessed());
        document.switchPrincipal(testuser2);
        Assert.assertTrue((boolean)document.isAcknowledgeRequested());
        document.acknowledge("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    private WorkflowDocument getDocument(String netid) throws WorkflowException {
        return WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(netid), (String)this.docId);
    }

    private WorkflowDocument getDocument(String principalId, String docId) throws WorkflowException {
        return WorkflowDocumentFactory.loadDocument((String)principalId, (String)docId);
    }
}

