/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.test.KEWTestCase;

public class ClearFYIActionTest
extends KEWTestCase {
    private String getSavedStatusDisplayValue() {
        return (String)KewApiConstants.DOCUMENT_STATUSES.get("S");
    }

    @Test
    public void testSavedDocumentAdhocRequest() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"TestDocumentType");
        doc.saveDocument("");
        doc.adHocToPrincipal(ActionRequestType.FYI, "annotation1", this.getPrincipalIdForName("dewey"), "respDesc1", false);
        String userId = this.getPrincipalIdForName("dewey");
        doc = WorkflowDocumentFactory.loadDocument((String)userId, (String)doc.getDocumentId());
        Assert.assertTrue((String)("FYI should be requested of user " + userId), (boolean)doc.isFYIRequested());
        try {
            doc.fyi();
        }
        catch (Exception e) {
            Assert.fail((String)("A non-initator with an FYI request should be allowed to take the FYI action on a " + this.getSavedStatusDisplayValue() + " document"));
        }
        Assert.assertTrue((String)("Document should be " + this.getSavedStatusDisplayValue()), (boolean)doc.isSaved());
        String workgroupUserId = this.getPrincipalIdForName("dewey");
        doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"TestDocumentType");
        doc.saveDocument("");
        doc.adHocToGroup(ActionRequestType.FYI, "annotation1", this.getGroupIdForName("KR-WKFLW", "NonSIT"), "respDesc1", false);
        doc = WorkflowDocumentFactory.loadDocument((String)workgroupUserId, (String)doc.getDocumentId());
        Assert.assertTrue((String)("FYI should be requested of user " + workgroupUserId), (boolean)doc.isFYIRequested());
        try {
            doc.fyi();
        }
        catch (Exception e) {
            Assert.fail((String)("A non-initator with an FYI request should be allowed to take the FYI action on a " + this.getSavedStatusDisplayValue() + " document"));
        }
        Assert.assertTrue((String)("Document should be " + this.getSavedStatusDisplayValue()), (boolean)doc.isSaved());
    }
}

