/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionlist.ActionListFilter;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.RoutingReportActionToTake;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.TestRuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.util.FutureRequestDocumentStateManager;

public class FutureRequestsTest
extends KEWTestCase {
    @Test
    public void testSavingFutureRequestsStatuses() throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.getPrincipalIdForName("user1"));
        TestRuleAttribute.setRecipientPrincipalIds("TestRole", "TestRole-user1", ids);
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)rkirkendPrincipalId, (String)"TestDocumentType");
        document.setReceiveFutureRequests();
        document.route("");
        DocumentRouteHeaderValue routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        FutureRequestDocumentStateManager futRequestStateMan = new FutureRequestDocumentStateManager(routeHeader, rkirkendPrincipalId);
        Assert.assertTrue((boolean)futRequestStateMan.isReceiveFutureRequests());
        Assert.assertFalse((boolean)futRequestStateMan.isClearFutureRequestState());
        Assert.assertFalse((boolean)futRequestStateMan.isDoNotReceiveFutureRequests());
        document = WorkflowDocumentFactory.createDocument((String)rkirkendPrincipalId, (String)"TestDocumentType");
        document.setDoNotReceiveFutureRequests();
        document.route("");
        routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        futRequestStateMan = new FutureRequestDocumentStateManager(routeHeader, rkirkendPrincipalId);
        Assert.assertFalse((boolean)futRequestStateMan.isReceiveFutureRequests());
        Assert.assertFalse((boolean)futRequestStateMan.isClearFutureRequestState());
        Assert.assertTrue((boolean)futRequestStateMan.isDoNotReceiveFutureRequests());
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        document.setClearFutureRequests();
        document.approve("");
        routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        futRequestStateMan = new FutureRequestDocumentStateManager(routeHeader, rkirkendPrincipalId);
        Assert.assertFalse((boolean)futRequestStateMan.isReceiveFutureRequests());
        Assert.assertTrue((boolean)futRequestStateMan.isClearFutureRequestState());
        Assert.assertFalse((boolean)futRequestStateMan.isDoNotReceiveFutureRequests());
        routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        int deactivatedCount = 0;
        for (BranchState state : routeHeader.getRootBranchState()) {
            if (state.getKey().contains("var::_receive_future_requests")) {
                Assert.fail((String)"state clearing should have removed all future request vars");
                continue;
            }
            if (!state.getKey().contains("var::_deactivated_future_requests")) continue;
            ++deactivatedCount;
        }
        Assert.assertEquals((long)2L, (long)deactivatedCount);
        document = WorkflowDocumentFactory.createDocument((String)rkirkendPrincipalId, (String)"TestDocumentType");
        document.route("");
        routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        futRequestStateMan = new FutureRequestDocumentStateManager(routeHeader, rkirkendPrincipalId);
        Assert.assertFalse((boolean)futRequestStateMan.isReceiveFutureRequests());
        Assert.assertFalse((boolean)futRequestStateMan.isClearFutureRequestState());
        Assert.assertFalse((boolean)futRequestStateMan.isDoNotReceiveFutureRequests());
    }

    @Test
    public void testFutureRequestsWithRouting() throws Exception {
        this.loadXmlFile(((Object)((Object)this)).getClass(), "FutureRequestsConfig.xml");
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        String user2PrincipalId = this.getPrincipalIdForName("user2");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)user1PrincipalId, (String)"FutureRequestsDoc");
        document.setDoNotReceiveFutureRequests();
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)user1PrincipalId, (String)document.getDocumentId());
        Assert.assertFalse((boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)user2PrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.setReceiveFutureRequests();
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)user2PrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        Assert.assertEquals((long)1L, (long)KEWServiceLocator.getActionListService().getActionList(user2PrincipalId, new ActionListFilter()).size());
        Assert.assertEquals((long)1L, (long)KEWServiceLocator.getActionListService().getActionList(user1PrincipalId, new ActionListFilter()).size());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)user2PrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
    }

    @Test
    public void testFutureRequestsWithRoutingAndWorkflowInfoActionRequestCheck() throws Exception {
        this.loadXmlFile(((Object)((Object)this)).getClass(), "FutureRequestsConfig.xml");
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        String user2PrincipalId = this.getPrincipalIdForName("user2");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)user1PrincipalId, (String)"FutureRequestsDoc");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)user1PrincipalId, (String)document.getDocumentId());
        WorkflowDocumentActionsService actionService = KewApiServiceLocator.getWorkflowDocumentActionsService();
        RoutingReportCriteria.Builder reportCriteria = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        reportCriteria.setTargetPrincipalIds(Collections.singletonList(user1PrincipalId));
        String actionToTakeNode = "Node1";
        reportCriteria.setActionsToTake(Collections.singletonList(RoutingReportActionToTake.Builder.create((String)"A", (String)user1PrincipalId, (String)actionToTakeNode)));
        Assert.assertTrue((String)("User " + user1PrincipalId + " should have approval requests on the document"), (boolean)actionService.documentWillHaveAtLeastOneActionRequest(reportCriteria.build(), Collections.singletonList("A"), false));
        reportCriteria = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        reportCriteria.setTargetPrincipalIds(Collections.singletonList(user1PrincipalId));
        actionToTakeNode = "Node1";
        reportCriteria.setActionsToTake(Collections.singletonList(RoutingReportActionToTake.Builder.create((String)"A", (String)user1PrincipalId, (String)actionToTakeNode)));
        DocumentDetail documentVO = KewApiServiceLocator.getWorkflowDocumentActionsService().executeSimulation(reportCriteria.build());
        Assert.assertTrue((String)("User " + user1PrincipalId + " should have one or more approval requests on the document"), (documentVO.getActionRequests().size() > 0 ? 1 : 0) != 0);
        reportCriteria = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        String delyeaPrincipalId = this.getPrincipalIdForName("delyea");
        reportCriteria.setTargetPrincipalIds(Collections.singletonList(user1PrincipalId));
        actionToTakeNode = "Node1";
        reportCriteria.setActionsToTake(Collections.singletonList(RoutingReportActionToTake.Builder.create((String)"A", (String)user1PrincipalId, (String)actionToTakeNode)));
        documentVO = actionService.executeSimulation(reportCriteria.build());
        Assert.assertTrue((String)("User " + delyeaPrincipalId + " should not have any requests on the document but executeSimulation() method should return all action requests anyway"), (documentVO.getActionRequests().size() > 0 ? 1 : 0) != 0);
        document = WorkflowDocumentFactory.createDocument((String)user1PrincipalId, (String)"FutureRequestsDoc");
        document.setDoNotReceiveFutureRequests();
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)user1PrincipalId, (String)document.getDocumentId());
        Assert.assertFalse((boolean)document.isApprovalRequested());
        reportCriteria = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        reportCriteria.setTargetPrincipalIds(Collections.singletonList(user1PrincipalId));
        Assert.assertFalse((String)("User " + user1PrincipalId + " should not have any approval request on the document"), (boolean)actionService.documentWillHaveAtLeastOneActionRequest(reportCriteria.build(), Collections.singletonList("A"), false));
        reportCriteria = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        reportCriteria.setTargetPrincipalIds(Collections.singletonList(user2PrincipalId));
        Assert.assertTrue((String)("User " + user2PrincipalId + " should have any approval request on the document"), (boolean)actionService.documentWillHaveAtLeastOneActionRequest(reportCriteria.build(), Collections.singletonList("A"), false));
    }

    @Test
    public void testFutureRequestsWithDuplicateNodesSplit() throws Exception {
        this.testFutureRequestsWithDuplicateNodesImpl("FutureRequestsConfig2.xml");
    }

    @Test
    public void testFutureRequestsWithDuplicateNodesStraight() throws Exception {
        this.testFutureRequestsWithDuplicateNodesImpl("FutureRequestsConfig3.xml");
    }

    private void testFutureRequestsWithDuplicateNodesImpl(String fileName) throws Exception {
        this.loadXmlFile(((Object)((Object)this)).getClass(), fileName);
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        String user2PrincipalId = this.getPrincipalIdForName("user2");
        String user3PrincipalId = this.getPrincipalIdForName("earl");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)user1PrincipalId, (String)"FutureRequestsDoc");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)user3PrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"should have approval status", (boolean)document.isApprovalRequested());
        document.setReceiveFutureRequests();
        document.saveDocumentData();
        document.approve("route node 1");
        document = WorkflowDocumentFactory.loadDocument((String)user1PrincipalId, (String)document.getDocumentId());
        Assert.assertFalse((String)"should not have approval status 1", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)user2PrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"should have approval status 2", (boolean)document.isApprovalRequested());
        document.approve("routing node 2");
        document = WorkflowDocumentFactory.loadDocument((String)user3PrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"should have approval status 3", (boolean)document.isApprovalRequested());
        document.approve("routing node 3");
    }
}

