/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actions.TakeWorkgroupAuthorityTest;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class ReleaseWorkgroupAuthorityTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testReleaseWorkgroupAuthority() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"TakeWorkgroupAuthorityDoc");
        doc.route("");
        String groupId = this.getGroupIdForName("KR-WKFLW", "TestWorkgroup");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)doc.getDocumentId());
        doc.takeGroupAuthority("", groupId);
        ActionListService aiService = KEWServiceLocator.getActionListService();
        Collection actionItems = aiService.findByDocumentId(doc.getDocumentId());
        Assert.assertEquals((String)"There should be only one action item", (long)1L, (long)actionItems.size());
        ActionItem ai = (ActionItem)actionItems.iterator().next();
        Assert.assertEquals((String)"action item should be to rkirkend", (Object)this.getPrincipalIdForName("rkirkend"), (Object)ai.getPrincipalId());
        Assert.assertEquals((String)"action item should be to group", (Object)groupId, (Object)ai.getGroupId());
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)doc.getDocumentId());
        doc.releaseGroupAuthority("", groupId);
        actionItems = aiService.findByDocumentId(doc.getDocumentId());
        Assert.assertTrue((String)"There should be more than one action item", (actionItems.size() > 1 ? 1 : 0) != 0);
        for (ActionItem actionItem : actionItems) {
            Assert.assertTrue((String)"Action Item not to workgroup member", (boolean)TakeWorkgroupAuthorityTest.WORKGROUP_MEMBERS.contains(this.getPrincipalNameForId(actionItem.getPrincipalId())));
        }
    }
}

