/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.InvalidActionTakenException;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class RouteDocumentTest
extends KEWTestCase {
    public static final String DOCUMENT_TYPE_NAME = "BlanketApproveSequentialTest";
    public static final String DOCUMENT_TYPE_POLICY_TEST_NAME = "BlanketApprovePolicyTest";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testRouteAlreadyRoutedDocument() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)DOCUMENT_TYPE_NAME);
        document.route("");
        Assert.assertTrue((String)"Document should be ENROUTE.", (boolean)document.isEnroute());
        Assert.assertFalse((String)"There should not be a request to ewestfal.", (boolean)document.isApprovalRequested());
        Collection actionTakens = KEWServiceLocator.getActionTakenService().findByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should be only 1 action taken.", (long)1L, (long)actionTakens.size());
        try {
            document.route("");
            Assert.fail((String)"A WorkflowException should have been thrown.");
        }
        catch (InvalidActionTakenException e) {
            e.printStackTrace();
        }
        actionTakens = KEWServiceLocator.getActionTakenService().findByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should still be only 1 action taken.", (long)1L, (long)actionTakens.size());
    }

    @Test
    public void testRouteDocumentAsNonInitiatorUser() throws Exception {
        WorkflowDocument firstDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)DOCUMENT_TYPE_POLICY_TEST_NAME);
        WorkflowDocument document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)firstDocument.getDocumentId());
        try {
            document.route("");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Exception thrown but should not have have been... Exception was of type " + e.getClass().getName() + " and message was " + e.getMessage()));
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)firstDocument.getDocumentId());
        Assert.assertEquals((String)"Document should be in Enroute status.", (Object)DocumentStatus.ENROUTE, (Object)document.getStatus());
        Collection actionTakens = KEWServiceLocator.getActionTakenService().findByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should be 1 action taken.", (long)1L, (long)actionTakens.size());
    }

    @Test
    public void testRouteDefaultDocumentAsNonInitiatorUser() throws Exception {
        WorkflowDocument firstDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)DOCUMENT_TYPE_NAME);
        WorkflowDocument document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)firstDocument.getDocumentId());
        try {
            document.route("");
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.assertFalse((String)"Document should not be ENROUTE.", (boolean)document.isEnroute());
    }
}

