/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.edl.framework.util.EDLFunctions;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class RouteLogAuthenticationTest
extends KEWTestCase {
    public static final String DOCUMENT_TYPE_NAME = "BlanketApproveSequentialTest";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testUserRouteLogAuthenticated() throws Exception {
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)user1PrincipalId, (String)DOCUMENT_TYPE_NAME);
        document.route("");
        GlobalVariables.setUserSession(null);
        Assert.assertFalse((boolean)EDLFunctions.isUserRouteLogAuthenticated((String)(document.getDocumentId() + "")));
        GlobalVariables.setUserSession((UserSession)new UserSession("user1"));
        Assert.assertTrue((boolean)EDLFunctions.isUserRouteLogAuthenticated((String)(document.getDocumentId() + "")));
        GlobalVariables.setUserSession((UserSession)new UserSession("bmcgough"));
        Assert.assertTrue((boolean)EDLFunctions.isUserRouteLogAuthenticated((String)(document.getDocumentId() + "")));
        GlobalVariables.setUserSession((UserSession)new UserSession("user2"));
        Assert.assertFalse((boolean)EDLFunctions.isUserRouteLogAuthenticated((String)(document.getDocumentId() + "")));
    }
}

