/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class SuperUserActionRequestApproveEventTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testSuperUserActionsOnEnroute() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NotificationTest");
        document.adHocToPrincipal(ActionRequestType.FYI, "", this.getPrincipalIdForName("rkirkend"), "", true);
        document.adHocToPrincipal(ActionRequestType.APPROVE, "", this.getPrincipalIdForName("jhopf"), "", true);
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have an FYI request.", (boolean)document.isFYIRequested());
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllValidRequests(rkirkendPrincipalId, document.getDocumentId(), "F");
        Assert.assertEquals((String)"There should only be 1 fyi request to rkirkend.", (long)1L, (long)actionRequests.size());
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        document.superUserTakeRequestedAction(((ActionRequestValue)actionRequests.get(0)).getActionRequestId().toString(), "");
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        Assert.assertFalse((String)"rkirkend should no longer have an FYI request.", (boolean)document.isFYIRequested());
        Assert.assertTrue((String)"Document should still be ENROUTE", (boolean)document.isEnroute());
    }

    @Test
    public void testSuperUserActionsOnFinal() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SuperUserApproveActionRequestFyiTest");
        document.adHocToPrincipal(ActionRequestType.FYI, "", this.getPrincipalIdForName("rkirkend"), "", true);
        document.route("");
        Assert.assertEquals((String)"Document should be FINAL", (Object)DocumentStatus.FINAL, (Object)document.getStatus());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have an FYI request.", (boolean)document.isFYIRequested());
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllValidRequests(rkirkendPrincipalId, document.getDocumentId(), "F");
        Assert.assertEquals((String)"There should only be 1 fyi request to rkirkend.", (long)1L, (long)actionRequests.size());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        document.superUserTakeRequestedAction(((ActionRequestValue)actionRequests.get(0)).getActionRequestId().toString(), "");
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        Assert.assertFalse((String)"rkirkend should no longer have an FYI request.", (boolean)document.isFYIRequested());
    }

    @Test
    public void testSuperUserActionsOnProcessed() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SuperUserApproveActionRequestFyiTest");
        document.adHocToPrincipal(ActionRequestType.ACKNOWLEDGE, "", this.getPrincipalIdForName("jhopf"), "", true);
        document.adHocToPrincipal(ActionRequestType.FYI, "", this.getPrincipalIdForName("rkirkend"), "", true);
        document.route("");
        Assert.assertEquals((String)"Document should be PROCESSED", (Object)DocumentStatus.PROCESSED, (Object)document.getStatus());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have an FYI request.", (boolean)document.isFYIRequested());
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        List fyiActionRequests = KEWServiceLocator.getActionRequestService().findAllValidRequests(rkirkendPrincipalId, document.getDocumentId(), "F");
        Assert.assertEquals((String)"There should only be 1 fyi request to rkirkend.", (long)1L, (long)fyiActionRequests.size());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        document.superUserTakeRequestedAction(((ActionRequestValue)fyiActionRequests.get(0)).getActionRequestId().toString(), "");
        document = WorkflowDocumentFactory.loadDocument((String)rkirkendPrincipalId, (String)document.getDocumentId());
        Assert.assertFalse((String)"rkirkend should no longer have an FYI request.", (boolean)document.isFYIRequested());
        Assert.assertEquals((String)"Document should be PROCESSED", (Object)DocumentStatus.PROCESSED, (Object)document.getStatus());
        String jhopfPrincipalId = this.getPrincipalIdForName("jhopf");
        List ackActionRequests = KEWServiceLocator.getActionRequestService().findAllValidRequests(jhopfPrincipalId, document.getDocumentId(), "K");
        Assert.assertEquals((String)"There should only be 1 ACK request to jhopf.", (long)1L, (long)ackActionRequests.size());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        document.superUserTakeRequestedAction(((ActionRequestValue)ackActionRequests.get(0)).getActionRequestId().toString(), "");
        document = WorkflowDocumentFactory.loadDocument((String)jhopfPrincipalId, (String)document.getDocumentId());
        Assert.assertFalse((String)"jhopf should no longer have an ACK request.", (boolean)document.isAcknowledgeRequested());
        Assert.assertEquals((String)"Document should be FINAL", (Object)DocumentStatus.FINAL, (Object)document.getStatus());
    }

    @Test
    public void testSuperUserActionRoutesDocumentToEnroute() throws Exception {
        String documentId = this.testSuperUserActionRoutesDocument("SuperUserApproveActionRequestApproveTest");
        WorkflowDocument document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)documentId);
        Assert.assertEquals((String)"Document should be ENROUTE", (Object)DocumentStatus.ENROUTE, (Object)document.getStatus());
    }

    @Test
    public void testSuperUserActionRoutesDocumentToFinal() throws Exception {
        String documentId = this.testSuperUserActionRoutesDocument("SuperUserApproveActionRequestFyiTest");
        WorkflowDocument document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)documentId);
        Assert.assertEquals((String)"Document should be FINAL", (Object)DocumentStatus.FINAL, (Object)document.getStatus());
    }

    private String testSuperUserActionRoutesDocument(String documentType) throws Exception {
        String ewestfalPrincipalId = this.getPrincipalIdForName("ewestfal");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)ewestfalPrincipalId, (String)documentType);
        document.saveDocument("");
        Assert.assertEquals((String)"Document should be SAVED", (Object)DocumentStatus.SAVED, (Object)document.getStatus());
        document = WorkflowDocumentFactory.loadDocument((String)ewestfalPrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"ewestfal should have Complete request", (boolean)document.isCompletionRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertFalse((String)"rkirkend should not have Complete request", (boolean)document.isCompletionRequested());
        Assert.assertFalse((String)"rkirkend should not have Approve request", (boolean)document.isApprovalRequested());
        Assert.assertTrue((String)"rkirkend should be a super user of the document", (boolean)document.isValidAction(ActionType.SU_APPROVE));
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllValidRequests(ewestfalPrincipalId, document.getDocumentId(), "C");
        Assert.assertEquals((String)"There should only be 1 complete request to ewestfal as result of the save.", (long)1L, (long)actionRequests.size());
        document.superUserTakeRequestedAction(((ActionRequestValue)actionRequests.get(0)).getActionRequestId().toString(), "");
        document = WorkflowDocumentFactory.loadDocument((String)ewestfalPrincipalId, (String)document.getDocumentId());
        Assert.assertFalse((String)"ewestfal should not have Complete request", (boolean)document.isCompletionRequested());
        return document.getDocumentId();
    }

    @Test
    public void testSavedDocumentSuperUserAdhocActionsApprove() throws Exception {
        String initiatorNetworkId = "ewestfal";
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(initiatorNetworkId), (String)"SuperUserApproveActionRequestFyiTest");
        String adhocActionUserNetworkId = "jhopf";
        document.adHocToPrincipal(ActionRequestType.APPROVE, "", this.getPrincipalIdForName(adhocActionUserNetworkId), "", true);
        document.saveDocument("");
        Assert.assertEquals((String)"Document should be SAVED", (Object)DocumentStatus.SAVED, (Object)document.getStatus());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"ewestfal should have Complete request", (boolean)document.isCompletionRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertFalse((String)"rkirkend should not have Complete request", (boolean)document.isCompletionRequested());
        Assert.assertFalse((String)"rkirkend should not have Approve request", (boolean)document.isApprovalRequested());
        Assert.assertTrue((String)"rkirkend should be a super user of the document", (boolean)document.isValidAction(ActionType.SU_APPROVE));
        String adhocPrincipalId = this.getPrincipalIdForName(adhocActionUserNetworkId);
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllValidRequests(adhocPrincipalId, document.getDocumentId(), ActionRequestType.APPROVE.getCode());
        Assert.assertEquals((String)("There should only be 1 approve request to " + adhocActionUserNetworkId + "."), (long)1L, (long)actionRequests.size());
        document.superUserTakeRequestedAction(((ActionRequestValue)actionRequests.get(0)).getActionRequestId().toString(), "");
        document = WorkflowDocumentFactory.loadDocument((String)adhocPrincipalId, (String)document.getDocumentId());
        Assert.assertFalse((String)(adhocPrincipalId + " should not have approve request"), (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(initiatorNetworkId), (String)document.getDocumentId());
        Assert.assertTrue((String)(initiatorNetworkId + " should not have complete request"), (boolean)document.isCompletionRequested());
        Assert.assertEquals((String)"Document should be SAVED", (Object)DocumentStatus.SAVED, (Object)document.getStatus());
    }
}

