/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.test.KEWTestCase;

public class VariablesTest
extends KEWTestCase {
    private static final Logger LOG = LogManager.getLogger(VariablesTest.class);

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    private void dumpInfoAboutDoc(WorkflowDocument doc) throws WorkflowException {
        LOG.info("\tDoc: class=" + doc.getDocumentTypeName() + " title=" + doc.getTitle() + " status=" + doc.getStatus());
        LOG.info("\tActionRequests:");
        for (ActionRequest ar : doc.getRootActionRequests()) {
            LOG.info("\t\tId: " + ar.getId() + " PrincipalId: " + ar.getPrincipalId() + " ActionRequested: " + ar.getActionRequested() + " ActionTaken: " + (ar.getActionTaken() != null ? ar.getActionTaken().getActionTaken() : null) + " NodeName: " + ar.getNodeName() + " Status:" + ar.getStatus());
        }
        LOG.info("\tActionTakens:");
        for (ActionTaken at : doc.getActionsTaken()) {
            LOG.info("\t\tId: " + at.getId() + " PrincipalId: " + at.getPrincipalId() + " ActionTaken: " + at.getActionTaken());
        }
        LOG.info("\tNodeNames:");
        for (String name : doc.getNodeNames()) {
            LOG.info("\t\t" + name);
        }
    }

    public void dumpBranch(Branch b) {
        LOG.info("Branch: " + b.getBranchId() + " " + b.getName());
        for (BranchState bs : b.getBranchState()) {
            LOG.info(bs.getBranchStateId() + " " + bs.getKey() + " " + bs.getValue());
        }
    }

    @Test
    public void testVariables() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"VariablesTest");
        doc.route("");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)doc.getDocumentId());
        this.dumpInfoAboutDoc(doc);
        doc.setVariable("myexcellentvariable", "righton");
        doc.approve("");
        Assert.assertEquals((Object)"startedVariableValue", (Object)doc.getVariableValue("started"));
        Assert.assertEquals((Object)"startedVariableValue", (Object)doc.getVariableValue("copiedVar"));
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)doc.getDocumentId());
        Assert.assertEquals((Object)"righton", (Object)doc.getVariableValue("myexcellentvariable"));
        doc.setVariable("vartwo", "two");
        doc.setVariable("myexcellentvariable", "ichangedit");
        doc.acknowledge("");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user3"), (String)doc.getDocumentId());
        Assert.assertEquals((Object)"ichangedit", (Object)doc.getVariableValue("myexcellentvariable"));
        Assert.assertEquals((Object)"two", (Object)doc.getVariableValue("vartwo"));
        doc.setVariable("another", "another");
        doc.setVariable("vartwo", null);
        doc.complete("");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)doc.getDocumentId());
        Assert.assertEquals((Object)"ichangedit", (Object)doc.getVariableValue("myexcellentvariable"));
        Assert.assertEquals(null, (Object)doc.getVariableValue("vartwo"));
        Assert.assertEquals((Object)"another", (Object)doc.getVariableValue("another"));
        doc.approve("");
        Assert.assertEquals((Object)"endedVariableValue", (Object)doc.getVariableValue("ended"));
        Assert.assertNotNull((Object)doc.getVariableValue("google"));
        LOG.info(doc.getVariableValue("google"));
        Assert.assertEquals((Object)"documentContentendedVariableValue", (Object)doc.getVariableValue("xpath"));
        LOG.info(doc.getVariableValue("xpath"));
        Assert.assertEquals((Object)"aNewStartedVariableValue", (Object)doc.getVariableValue("started"));
        Assert.assertTrue((String)"the document should be final", (boolean)doc.isFinal());
    }
}

