/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.batch;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.upload.FormFile;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.util.ClasspathOrFileResourceLoader;
import org.kuali.rice.core.web.impex.IngesterAction;
import org.kuali.rice.core.web.impex.IngesterForm;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.web.MockFormFile;
import org.kuali.rice.kew.test.web.WorkflowServletRequest;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.filter.UserLoginFilter;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockHttpServletResponse;

public class IngesterActionTest
extends KEWTestCase {
    private static final Logger LOG = LogManager.getLogger(IngesterActionTest.class);
    private static final String TRANSACTION_FAILED_REGEX = "(?i)^Ingestion failed$";
    private static final String SUCCESS_MESSAGE_REGEX_PRE = "(?ism)^Ingested xml doc.*";
    private static final String SUCCESS_MESSAGE_REGEX_POST = ".*";
    private static final String FAILURE_MESSAGE_REGEX_PRE = "(?ism)^((Failed to ingest xml doc)|(Rolled back doc)).*";
    private static final String FAILURE_MESSAGE_REGEX_POST = ".*";

    private static final String escape(String fileName) {
        return fileName.replaceAll("\\.", "\\\\.");
    }

    private static final String getSuccessRegex(String fileName) {
        return SUCCESS_MESSAGE_REGEX_PRE + IngesterActionTest.escape(fileName) + ".*";
    }

    private static final String getFailureRegex(String fileName) {
        return FAILURE_MESSAGE_REGEX_PRE + IngesterActionTest.escape(fileName) + ".*";
    }

    private boolean findMessage(List messages, String regex) {
        Pattern p = Pattern.compile(regex);
        Iterator it = messages.iterator();
        LOG.error(regex);
        while (it.hasNext()) {
            String message = (String)it.next();
            LOG.error(message);
            if (!p.matcher(message).matches()) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testSuccessfulIngestion() throws Exception {
        this.testIngestion("IngesterActionTest_success.txt", true);
    }

    @Test
    public void testFailedIngestion() throws Exception {
        this.testIngestion("IngesterActionTest_failure.txt", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIngestion(String config, boolean shouldSucceed) throws Exception {
        boolean failed;
        IngesterForm form = new IngesterForm();
        Properties filesToIngest = new Properties();
        filesToIngest.load(((Object)((Object)this)).getClass().getResourceAsStream(config));
        LinkedList<String> shouldPass = new LinkedList<String>();
        LinkedList<String> shouldFail = new LinkedList<String>();
        ClasspathOrFileResourceLoader rl = new ClasspathOrFileResourceLoader();
        Iterator<Map.Entry<Object, Object>> entries = filesToIngest.entrySet().iterator();
        int i = 0;
        while (entries.hasNext()) {
            Map.Entry<Object, Object> entry = entries.next();
            Resource resource = rl.getResource(entry.getKey().toString());
            File resourceFile = resource.getFile();
            String fileName = resourceFile.getName();
            if (Boolean.valueOf(entry.getValue().toString()).booleanValue()) {
                shouldPass.add(fileName);
            } else {
                shouldFail.add(fileName);
            }
            MockFormFile file = new MockFormFile(resourceFile);
            form.setFile(i, (FormFile)file);
            Assert.assertTrue((form.getFiles().size() == i + 1 ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertTrue((form.getFiles().size() > 0 ? 1 : 0) != 0);
        IngesterAction action = new IngesterAction();
        ActionMapping mapping = new ActionMapping();
        mapping.addForwardConfig((ForwardConfig)new ActionForward("view", "/nowhere", false));
        WorkflowServletRequest request = new WorkflowServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setUser("admin");
        new UserLoginFilter().doFilter((ServletRequest)request, (ServletResponse)response, new FilterChain(){

            public void doFilter(ServletRequest req, ServletResponse res) {
            }
        });
        request.setMethod("post");
        try {
            UserSession userSession = (UserSession)request.getSession().getAttribute("UserSession");
            Assert.assertNotNull((String)"UserSession should have been established.", (Object)userSession);
            GlobalVariables.setUserSession((UserSession)userSession);
            action.execute(mapping, (ActionForm)form, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        finally {
            GlobalVariables.setUserSession(null);
        }
        List messages = (List)request.getAttribute("messages");
        Assert.assertNotNull((Object)messages);
        Iterator it = shouldFail.iterator();
        while (it.hasNext()) {
            String file = it.next().toString();
            LOG.error("file: " + file);
            LOG.error("file replaced: " + IngesterActionTest.escape(file));
            Assert.assertTrue((boolean)this.findMessage(messages, IngesterActionTest.getFailureRegex(file)));
        }
        boolean bl = failed = shouldFail.size() > 0;
        if (failed && shouldSucceed) {
            Assert.fail((String)"Ingestation failed but should have succeeded");
        } else if (!failed && !shouldSucceed) {
            Assert.fail((String)"Ingestation succeeded but should have failed");
        }
        if (failed) {
            Assert.assertTrue((boolean)this.findMessage(messages, TRANSACTION_FAILED_REGEX));
        }
        it = shouldPass.iterator();
        while (it.hasNext()) {
            if (failed) {
                Assert.assertTrue((boolean)this.findMessage(messages, IngesterActionTest.getFailureRegex(it.next().toString())));
                continue;
            }
            Assert.assertTrue((boolean)this.findMessage(messages, IngesterActionTest.getSuccessRegex(it.next().toString())));
        }
    }
}

