/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.clientapp;

import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.test.KEWTestCase;

public class WorkflowDocumentTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ClientAppConfig.xml");
    }

    @Test
    public void testDirtyContent() {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"UnitTestDocument");
        document.setApplicationContent("application content");
        document.setAttributeContent("attribute content");
        document.setSearchableContent("searchable content");
        Assert.assertEquals((Object)"application content", (Object)document.getApplicationContent());
        Assert.assertEquals((Object)"application content", (Object)document.getDocumentContent().getApplicationContent());
        Assert.assertEquals((Object)"attribute content", (Object)document.getAttributeContent());
        Assert.assertEquals((Object)"attribute content", (Object)document.getDocumentContent().getAttributeContent());
        Assert.assertEquals((Object)"searchable content", (Object)document.getDocumentContent().getSearchableContent());
    }

    @Test
    public void testLoadNonExistentDocument() throws Exception {
        try {
            WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"123456789");
            Assert.fail((String)"load of non-existent document should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWorkflowDocument() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"UnitTestDocument");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        document.approve("");
        boolean containsInitiated = false;
        boolean containsTemplate1 = false;
        boolean containsTemplate2 = false;
        for (RouteNodeInstance routeNodeInstance : document.getRouteNodeInstances()) {
            if (routeNodeInstance.getName().equals("Initiated")) {
                containsInitiated = true;
                continue;
            }
            if (routeNodeInstance.getName().equals("Template1")) {
                containsTemplate1 = true;
                continue;
            }
            if (!routeNodeInstance.getName().equals("Template2")) continue;
            containsTemplate2 = true;
        }
        Assert.assertTrue((String)"Should have gone through initiated node", (boolean)containsInitiated);
        Assert.assertTrue((String)"Should have gone through template1 node", (boolean)containsTemplate1);
        Assert.assertTrue((String)"Should have gone through template2 node", (boolean)containsTemplate2);
    }

    @Test
    public void testReturnToPreviousCorrectlyUpdatingDocumentStatus() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"UnitTestDocument");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        document.returnToPreviousNode("", "Initiated");
        Assert.assertFalse((String)"ewestfal should no longer have approval status", (boolean)document.isApprovalRequested());
        Assert.assertFalse((String)"ewestfal should no long have blanket approve status", (boolean)document.isBlanketApproveCapable());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should now have an approve request", (boolean)document.isApprovalRequested());
    }

    @Test
    public void testGetPreviousRouteNodeNames() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"UnitTestDocument");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        List previousNodeNames = document.getPreviousNodeNames();
        Assert.assertEquals((String)"Should have 2 previous Node Names", (long)2L, (long)previousNodeNames.size());
        Assert.assertEquals((String)"Last node name should be the first visisted", (Object)"Initiated", previousNodeNames.get(0));
        Assert.assertEquals((String)"First node name should be last node visited", (Object)"Template1", previousNodeNames.get(1));
        Set currentNodes = document.getNodeNames();
        Assert.assertEquals((String)"Should have 1 current node name", (long)1L, (long)currentNodes.size());
        Assert.assertEquals((String)"Current node name incorrect", (Object)"Template2", currentNodes.iterator().next());
        document.returnToPreviousNode("", "Template1");
        previousNodeNames = document.getPreviousNodeNames();
        Assert.assertEquals((String)"Should have 1 previous Node Name", (long)1L, (long)previousNodeNames.size());
        Assert.assertEquals((String)"Previous Node name incorrect", (Object)"Initiated", previousNodeNames.get(0));
    }

    @Test
    public void testIsRouteCapable() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"UnitTestDocument");
        this.verifyIsRouteCapable(false, this.getPrincipalIdForName("ewestfal"), doc.getDocumentId());
        this.verifyIsRouteCapable(false, "2001", doc.getDocumentId());
        this.verifyIsRouteCapable(true, this.getPrincipalIdForName("rkirkend"), doc.getDocumentId());
        this.verifyIsRouteCapable(true, "2002", doc.getDocumentId());
        doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"NonInitiatorCanRouteDocument");
        this.verifyIsRouteCapable(true, this.getPrincipalIdForName("ewestfal"), doc.getDocumentId());
        this.verifyIsRouteCapable(true, "2001", doc.getDocumentId());
        this.verifyIsRouteCapable(true, this.getPrincipalIdForName("rkirkend"), doc.getDocumentId());
        this.verifyIsRouteCapable(true, "2002", doc.getDocumentId());
    }

    private void verifyIsRouteCapable(boolean routeCapable, String userId, String docId) throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.loadDocument((String)userId, (String)docId);
        Assert.assertEquals((Object)routeCapable, (Object)doc.isRouteCapable());
    }
}

