/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.framework.document.security.DocumentSecurityAttribute;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class CustomSecurityFilterAttribute
implements DocumentSecurityAttribute {
    private static final long serialVersionUID = -8487944372203594080L;
    public static final Map<String, String> VIEWERS_BY_STATUS = new HashMap<String, String>();

    public boolean isAuthorizedForDocument(String principalId, Document document) {
        try {
            WorkflowDocument doc = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
            String networkId = VIEWERS_BY_STATUS.get(doc.getStatus().getCode());
            String principalName = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalId).getPrincipalName();
            return StringUtils.isNotBlank((String)networkId) && networkId.equals(principalName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to process custom security filter attribute", e);
        }
    }

    static {
        VIEWERS_BY_STATUS.put("S", "user3");
        VIEWERS_BY_STATUS.put("R", "dewey");
        VIEWERS_BY_STATUS.put("P", "jitrue");
        VIEWERS_BY_STATUS.put("F", "user2");
    }
}

