/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch.xml;

import java.io.BufferedReader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.api.document.DocumentWithContent;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.docsearch.DocumentSearchInternalUtils;
import org.kuali.rice.kew.docsearch.DocumentSearchTestBase;
import org.kuali.rice.kew.docsearch.SearchableAttributeLongValue;
import org.kuali.rice.kew.docsearch.TestXMLSearchableAttributeDateTime;
import org.kuali.rice.kew.docsearch.TestXMLSearchableAttributeFloat;
import org.kuali.rice.kew.docsearch.TestXMLSearchableAttributeLong;
import org.kuali.rice.kew.docsearch.service.DocumentSearchService;
import org.kuali.rice.kew.docsearch.xml.StandardGenericXMLSearchableAttribute;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.test.BaselineTestCase;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class StandardGenericXMLSearchableAttributeTest
extends DocumentSearchTestBase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("XmlConfig.xml");
    }

    @Test
    public void testXMLStandardSearchableAttributeWithInvalidValue() throws Exception {
        String documentTypeName = "SearchDocTypeStandardSearchDataType";
        String userNetworkId = "rkirkend";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(userNetworkId), (String)documentTypeName);
        WorkflowAttributeDefinition.Builder longXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeStdLong");
        longXMLDef.addPropertyDefinition("testLongKey", "123x23");
        workflowDocument.addSearchableDefinition(longXMLDef.build());
        workflowDocument.setTitle("Routing style");
        try {
            workflowDocument.route("routing this document.");
            Assert.fail((String)"Document should be unroutable with invalid searchable attribute value");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TestUtilities.waitForExceptionRouting();
    }

    @Test
    public void testXMLStandardSearchableAttributesWithDataType() throws Exception {
        String documentTypeName = "SearchDocTypeStandardSearchDataType";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        String userNetworkId = "rkirkend";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(userNetworkId), (String)documentTypeName);
        int i = 0;
        ++i;
        WorkflowAttributeDefinition.Builder stringXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttribute");
        stringXMLDef.addPropertyDefinition("givenname", "jack");
        workflowDocument.addSearchableDefinition(stringXMLDef.build());
        ++i;
        WorkflowAttributeDefinition.Builder longXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeStdLong");
        longXMLDef.addPropertyDefinition("testLongKey", TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString());
        workflowDocument.addSearchableDefinition(longXMLDef.build());
        ++i;
        WorkflowAttributeDefinition.Builder floatXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeStdFloat");
        floatXMLDef.addPropertyDefinition("testFloatKey", TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString());
        workflowDocument.addSearchableDefinition(floatXMLDef.build());
        ++i;
        WorkflowAttributeDefinition.Builder dateXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeStdDateTime");
        dateXMLDef.addPropertyDefinition("testDateTimeKey", DocumentSearchInternalUtils.getDisplayValueWithDateOnly((DateTime)TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE));
        workflowDocument.addSearchableDefinition(dateXMLDef.build());
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(userNetworkId), (String)workflowDocument.getDocumentId());
        DocumentRouteHeaderValue doc = KEWServiceLocator.getRouteHeaderService().getRouteHeader(workflowDocument.getDocumentId());
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(userNetworkId);
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "givenname", "jack");
        DocumentSearchResults results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        DocumentSearchCriteria.Builder criteria2 = DocumentSearchCriteria.Builder.create();
        criteria2.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria2, "givenname", "fred");
        DocumentSearchResults results2 = docSearchService.lookupDocuments(user.getPrincipalId(), criteria2.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results2.getSearchResults().size());
        DocumentSearchCriteria.Builder criteria3 = DocumentSearchCriteria.Builder.create();
        criteria3.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria3, "fakeproperty", "doesntexist");
        try {
            docSearchService.lookupDocuments(user.getPrincipalId(), criteria3.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("LookupException"));
        }
        criteria = null;
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "testLongKey", TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString());
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria2 = null;
        criteria2 = DocumentSearchCriteria.Builder.create();
        criteria2.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria2, "testLongKey", "1111111");
        results2 = docSearchService.lookupDocuments(user.getPrincipalId(), criteria2.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results2.getSearchResults().size());
        criteria3 = null;
        criteria3 = DocumentSearchCriteria.Builder.create();
        criteria3.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria3, "fakeymcfakefake", "99999999");
        try {
            docSearchService.lookupDocuments(user.getPrincipalId(), criteria3.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("LookupException"));
        }
        criteria = null;
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "testFloatKey", TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString());
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria2 = null;
        criteria2 = DocumentSearchCriteria.Builder.create();
        criteria2.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria2, "testFloatKey", "215.3548");
        results2 = docSearchService.lookupDocuments(user.getPrincipalId(), criteria2.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results2.getSearchResults().size());
        criteria3 = null;
        criteria3 = DocumentSearchCriteria.Builder.create();
        criteria3.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria3, "fakeylostington", "9999.9999");
        try {
            docSearchService.lookupDocuments(user.getPrincipalId(), criteria3.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException wsee) {
            Assert.assertTrue((boolean)wsee.getMessage().contains("LookupException"));
        }
        criteria = null;
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "testDateTimeKey", DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)new Timestamp(TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE_IN_MILLS)));
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria2 = null;
        criteria2 = DocumentSearchCriteria.Builder.create();
        criteria2.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria2, "testDateTimeKey", "07/06/1979");
        results2 = docSearchService.lookupDocuments(user.getPrincipalId(), criteria2.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results2.getSearchResults().size());
        criteria3 = null;
        criteria3 = DocumentSearchCriteria.Builder.create();
        criteria3.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria3, "lastingsfakerson", "07/06/2007");
        try {
            docSearchService.lookupDocuments(user.getPrincipalId(), criteria3.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException wsee) {
            Assert.assertTrue((boolean)wsee.getMessage().contains("LookupException"));
        }
    }

    @Test
    public void testRouteDocumentWithSearchableAttribute() throws Exception {
        String documentTypeName = "SearchDocType";
        String key = "givenname";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)documentTypeName);
        WorkflowAttributeDefinition.Builder givennameXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttribute");
        workflowDocument.setApplicationContent("<test></test>");
        givennameXMLDef.addPropertyDefinition(key, "jack");
        workflowDocument.addSearchableDefinition(givennameXMLDef.build());
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("rkirkend");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jack");
        DocumentSearchResults results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = null;
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "fred");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = null;
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "fakeproperty", "doesntexist");
        try {
            docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException wsee) {
            Assert.assertTrue((boolean)wsee.getMessage().contains("LookupException"));
        }
    }

    @Test
    public void testDocumentSearchAttributeWildcarding() throws Exception {
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        String documentTypeName = "SearchDocType";
        String key = "givenname";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)documentTypeName);
        WorkflowAttributeDefinition.Builder givennameXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttribute");
        workflowDocument.setApplicationContent("<test></test>");
        givennameXMLDef.addPropertyDefinition(key, "jack");
        workflowDocument.addSearchableDefinition(givennameXMLDef.build());
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("rkirkend");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jack");
        DocumentSearchResults results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "ja*");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "ja");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "*ack");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
    }

    @Test
    public void testDocumentSearchAttributeWildcardingDisallow() throws Exception {
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        String documentTypeName = "SearchDocTypeStandardSearchDataType";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        String userNetworkId = "rkirkend";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(userNetworkId), (String)documentTypeName);
        WorkflowAttributeDefinition.Builder longXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttributeStdLong");
        longXMLDef.addPropertyDefinition("testLongKey", TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString());
        workflowDocument.addSearchableDefinition(longXMLDef.build());
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(userNetworkId);
        String validSearchValue = TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString();
        DocumentSearchCriteria.Builder criteria = null;
        DocumentSearchResults results = null;
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "testLongKey", validSearchValue);
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "testLongKey", "*" + validSearchValue.substring(2));
        if (new SearchableAttributeLongValue().allowsWildcards()) {
            results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
            Assert.assertEquals((String)"Search results should be empty using wildcard '*' value.", (long)0L, (long)results.getSearchResults().size());
        } else {
            try {
                docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
                Assert.fail((String)"Search results should be throwing a validation exception for use of the character '*' without allowing wildcards");
            }
            catch (WorkflowServiceErrorException workflowServiceErrorException) {
                // empty catch block
            }
        }
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "testLongKey", validSearchValue.substring(0, validSearchValue.length() - 2));
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty trying to use assumed ending wildcard.", (long)0L, (long)results.getSearchResults().size());
    }

    @Test
    public void testDocumentSearchAttributeCaseSensitivity() throws Exception {
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        String documentTypeName = "SearchDocTypeCaseSensitivity";
        String networkId = "rkirkend";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        String key = "givenname";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(networkId), (String)documentTypeName);
        WorkflowAttributeDefinition.Builder givennameXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttribute");
        givennameXMLDef.addPropertyDefinition(key, "jack");
        workflowDocument.addSearchableDefinition(givennameXMLDef.build());
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(networkId);
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jack");
        DocumentSearchResults results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "JACK");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jAck");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jacK");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        key = "givenname_nocase";
        workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(networkId), (String)documentTypeName);
        WorkflowAttributeDefinition.Builder givenname_nocaseXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLSearchableAttribute_CaseInsensitive");
        givenname_nocaseXMLDef.addPropertyDefinition(key, "jaCk");
        workflowDocument.addSearchableDefinition(givenname_nocaseXMLDef.build());
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jack");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "JACK");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jaCk");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jacK");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jAc");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jA*");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "*aCk");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
    }

    @Test
    public void testRouteDocumentWithMalformedSearchableAttributeContent() throws WorkflowException {
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"SearchDocType");
        workflowDocument.setApplicationContent("hey, <I'm Not ] Even & XML");
        workflowDocument.setTitle("Routing style");
        try {
            workflowDocument.route("routing this document.");
            Assert.fail((String)"routeDocument succeeded with malformed XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUtilities.waitForExceptionRouting();
    }

    @Test
    public void testRouteDocumentWithInvalidSearchableAttributeContent() throws Exception {
        String documentTypeName = "SearchDocType";
        String key = "givenname";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)documentTypeName);
        workflowDocument.setApplicationContent("<documentContent><searchableContent><garbage><blah>not going to match anything</blah></garbage></searchableContent></documentContent>");
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("rkirkend");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jack");
        DocumentSearchResults results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "fred");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "fakeproperty", "doesntexist");
        try {
            results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException wsee) {
            Assert.assertTrue((boolean)wsee.getMessage().contains("LookupException"));
        }
    }

    @Test
    public void testRouteDocumentWithMoreInvalidSearchableAttributeContent() throws Exception {
        String documentTypeName = "SearchDocType";
        String key = "givenname";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)documentTypeName);
        workflowDocument.setApplicationContent("<documentContent><NOTsearchableContent><garbage><blah>not going to match anything</blah></garbage></NOTsearchableContent></documentContent>");
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("rkirkend");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jack");
        DocumentSearchResults results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "fred");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "fakeproperty", "doesntexist");
        try {
            results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException wsee) {
            Assert.assertTrue((boolean)wsee.getMessage().contains("LookupException"));
        }
    }

    @Test
    public void testGetSearchContent() throws Exception {
        String documentTypeName = "SearchDocType";
        this.assertGeneratedSearchContent(documentTypeName, "XMLSearchableAttribute", "givenname", "value", "//putWhateverWordsIwantInsideThisTag/givenname/value");
        this.assertGeneratedSearchContent(documentTypeName, "XMLSearchableAttributeStdLong", "testLongKey", "123458", "//putWhateverWordsIwantInsideThisTag/testLongKey/value");
        this.assertGeneratedSearchContent(documentTypeName, "XMLSearchableAttributeStdFloat", "testFloatKey", "2568.204", "//putWhateverWordsIwantInsideThisTag/testFloatKey/value");
        this.assertGeneratedSearchContent(documentTypeName, "XMLSearchableAttributeStdCurrency", "testCurrencyKey", "2248.20", "//putWhateverWordsIwantInsideThisTag/testCurrencyKey/value");
        String value = DocumentSearchInternalUtils.getDisplayValueWithDateOnly((DateTime)TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE);
        this.assertGeneratedSearchContent(documentTypeName, "XMLSearchableAttributeStdDateTime", "testDateTimeKey", value, "//putWhateverWordsIwantInsideThisTag/testDateTimeKey/value");
    }

    protected void assertGeneratedSearchContent(String docType, String attrName, String key, String value, String expr) throws Exception {
        StandardGenericXMLSearchableAttribute attribute = this.getAttribute(attrName);
        ExtensionDefinition ed = StandardGenericXMLSearchableAttributeTest.createExtensionDefinition(attrName);
        WorkflowAttributeDefinition.Builder wad = WorkflowAttributeDefinition.Builder.create((String)attrName);
        wad.addPropertyDefinition(key, value);
        String searchContent = attribute.generateSearchContent(ed, docType, wad.build());
        Assert.assertTrue((String)"searchContent was not found.", (searchContent != null && searchContent.length() > 0 ? 1 : 0) != 0);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Element foundDocContent = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new BufferedReader(new StringReader(searchContent)))).getDocumentElement();
        Assert.assertTrue((String)("Search content does not contain correct value for field '" + key + "'."), (boolean)value.equals(xpath.evaluate(expr, foundDocContent, XPathConstants.STRING)));
    }

    @Test
    public void testExtractDocumentAttributes() throws ParseException {
        String documentTypeName = "SearchDocType";
        String key = "givenname";
        String value = "jack";
        this.assertExtractDocumentAttributes(documentTypeName, "XMLSearchableAttribute", key, value, "<putWhateverWordsIwantInsideThisTag><" + key + ">" + "<value>" + value + "</value>" + "</" + key + ">" + "</putWhateverWordsIwantInsideThisTag>");
        key = "testLongKey";
        value = "123458";
        this.assertExtractDocumentAttributes(documentTypeName, "XMLSearchableAttributeStdLong", key, new BigInteger(value), "<putWhateverWordsIwantInsideThisTag><" + key + ">" + "<value>" + value + "</value>" + "</" + key + ">" + "</putWhateverWordsIwantInsideThisTag>");
        this.assertExtractDocumentAttributes(documentTypeName, "XMLSearchableAttributeStdLong", key, new BigInteger(value), "<putWhateverWordsIwantInsideThisTag><" + key + ">" + "<value>" + " " + value + " " + "</value>" + "</" + key + ">" + "</putWhateverWordsIwantInsideThisTag>");
        key = "testFloatKey";
        value = "2568.204154796";
        this.assertExtractDocumentAttributes(documentTypeName, "XMLSearchableAttributeStdFloat", key, new BigDecimal(value), "<putWhateverWordsIwantInsideThisTag><" + key + ">" + "<value>" + value + "</value>" + "</" + key + ">" + "</putWhateverWordsIwantInsideThisTag>");
        key = "testDateTimeKey";
        value = DocumentSearchInternalUtils.getDisplayValueWithDateOnly((DateTime)TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE);
        DateMidnight expected = TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE.toDateMidnight();
        this.assertExtractDocumentAttributes(documentTypeName, "XMLSearchableAttributeStdDateTime", key, expected, "<putWhateverWordsIwantInsideThisTag><" + key + ">" + "<value>" + value + "</value>" + "</" + key + ">" + "</putWhateverWordsIwantInsideThisTag>");
        value = "02/20/2007";
        String returnValue = "02/20/2007";
        Date d = RiceConstants.getDefaultDateFormat().parse(returnValue);
        expected = new DateTime(d.getTime()).toDateMidnight();
        this.assertExtractDocumentAttributes(documentTypeName, "XMLSearchableAttributeStdDateTime", key, expected, "<putWhateverWordsIwantInsideThisTag><" + key + ">" + "<value>" + value + "</value>" + "</" + key + ">" + "</putWhateverWordsIwantInsideThisTag>");
    }

    protected DocumentWithContent createDocumentWithSearchableContent(String docType, String content) {
        Document doc = Document.Builder.create((String)"fakeDocId123", (String)"fake initiator", (String)docType, (String)"fake doc type id").build();
        DocumentContent.Builder c = DocumentContent.Builder.create((String)"fakeDocId123");
        c.setSearchableContent(content);
        return DocumentWithContent.create((Document)doc, (DocumentContent)c.build());
    }

    protected void assertExtractDocumentAttributes(String docType, String attrName, String key, Object value, String searchableContent) {
        StandardGenericXMLSearchableAttribute attribute = this.getAttribute(attrName);
        ExtensionDefinition ed = StandardGenericXMLSearchableAttributeTest.createExtensionDefinition(attrName);
        List values = attribute.extractDocumentAttributes(ed, this.createDocumentWithSearchableContent(docType, searchableContent));
        Assert.assertEquals((String)"Number of search attribute values is wrong", (long)1L, (long)values.size());
        for (DocumentAttribute attrib : values) {
            Assert.assertEquals((String)"Key of attribute is wrong", (Object)key, (Object)attrib.getName());
            Assert.assertEquals((String)"Value of attribute is wrong", (Object)value, (Object)attrib.getValue());
        }
    }

    private String insertCommasIfNeeded(String value, int interval) {
        int indexOfDecimal = value.indexOf(".");
        String decimalPointOn = value.substring(indexOfDecimal);
        String temp = value.substring(0, indexOfDecimal);
        StringBuffer builtValue = new StringBuffer();
        if (temp.length() <= interval) {
            builtValue.append(temp);
        } else {
            int counter = 0;
            for (int i = temp.length() - 1; i >= 0; --i) {
                if (counter == interval) {
                    builtValue.insert(0, ",");
                    counter = 0;
                }
                ++counter;
                builtValue.insert(0, temp.substring(i, i + 1));
            }
        }
        return builtValue.append(decimalPointOn).toString();
    }

    @Test
    public void testGetSearchFields() {
        ExtensionDefinition ed;
        String documentTypeName = "SearchDocType";
        StandardGenericXMLSearchableAttribute searchAttribute = this.getAttribute(null);
        List remotableAttributeFields = searchAttribute.getSearchFields(ed = StandardGenericXMLSearchableAttributeTest.createExtensionDefinition("XMLSearchableAttribute"), documentTypeName);
        List rows = FieldUtils.convertRemotableAttributeFields((List)remotableAttributeFields);
        Assert.assertTrue((String)"Invalid number of search rows", (rows.size() == 1 ? 1 : 0) != 0);
        searchAttribute = this.getAttribute("BlankDropDownSearchAttribute");
        ed = StandardGenericXMLSearchableAttributeTest.createExtensionDefinition("BlankDropDownSearchAttribute");
        remotableAttributeFields = searchAttribute.getSearchFields(ed, documentTypeName);
        rows = FieldUtils.convertRemotableAttributeFields((List)remotableAttributeFields);
        Assert.assertEquals((String)"Invalid number of search rows", (long)1L, (long)rows.size());
        Row row = (Row)rows.get(0);
        Field field = row.getField(0);
        Assert.assertEquals((String)"Should be 5 valid values", (long)5L, (long)field.getFieldValidValues().size());
        Assert.assertEquals((String)"Default value is not correct", (Object)"AMST", (Object)field.getPropertyValue());
    }

    @Test
    public void testValidateUserSearchInputs() {
        String documentTypeName = "SearchDocType";
        StandardGenericXMLSearchableAttribute searchAttribute = this.getAttribute("XMLSearchableAttribute");
        ExtensionDefinition ed = StandardGenericXMLSearchableAttributeTest.createExtensionDefinition("XMLSearchableAttribute");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "givenname", "jack", false);
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "givenname", "jack.jack", true);
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "givenname", "jack*jack", false);
        searchAttribute = this.getAttribute("XMLSearchableAttributeStdLong");
        ed = StandardGenericXMLSearchableAttributeTest.createExtensionDefinition("XMLSearchableAttributeStdLong");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testLongKey", TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString(), false);
        RemotableAttributeError error = this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testLongKey", TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString() + ".33", true);
        Assert.assertTrue((String)"Validation error is incorrect", (boolean)error.getMessage().endsWith("does not conform to standard validation for field type."));
        error = this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testLongKey", TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString() + "jack*jack", true);
        Assert.assertTrue((String)"Validation error is incorrect", (boolean)error.getMessage().endsWith("does not conform to standard validation for field type."));
        searchAttribute = this.getAttribute("XMLSearchableAttributeStdFloat");
        ed = StandardGenericXMLSearchableAttributeTest.createExtensionDefinition("XMLSearchableAttributeStdFloat");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testFloatKey", TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString(), false);
        error = this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testFloatKey", TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString() + "a", true);
        Assert.assertTrue((String)"Validation error is incorrect", (boolean)error.getMessage().endsWith("does not conform to standard validation for field type."));
        error = this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testFloatKey", TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString() + "*", true);
        Assert.assertTrue((String)"Validation error is incorrect", (boolean)error.getMessage().endsWith("does not conform to standard validation for field type."));
        searchAttribute = this.getAttribute("XMLSearchableAttributeStdCurrency");
        ed = StandardGenericXMLSearchableAttributeTest.createExtensionDefinition("XMLSearchableAttributeStdCurrency");
        String key = "testCurrencyKey";
        Float value = Float.valueOf("5486.25");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, key, value.toString(), false);
        error = this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, key, value.toString() + "a", true);
        Assert.assertTrue((String)"Validation error is incorrect", (boolean)error.getMessage().endsWith("does not conform to standard validation for field type."));
        error = this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, key, value.toString() + "*", true);
        Assert.assertTrue((String)"Validation error is incorrect", (boolean)error.getMessage().endsWith("does not conform to standard validation for field type."));
        searchAttribute = this.getAttribute("XMLSearchableAttributeStdDateTime");
        ed = StandardGenericXMLSearchableAttributeTest.createExtensionDefinition("XMLSearchableAttributeStdDateTime");
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testDateTimeKey", DocumentSearchInternalUtils.getDisplayValueWithDateOnly((DateTime)TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE), false);
        this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testDateTimeKey", "001/5/08", false);
        error = this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testDateTimeKey", "41/5/08", true);
        Assert.assertTrue((String)"Validation error is incorrect", (boolean)error.getMessage().endsWith("does not conform to standard validation for field type."));
        error = this.assertDocumentSearchCriteriaValidation(searchAttribute, ed, "testDateTimeKey", "01/02/20*", true);
        Assert.assertTrue((String)"Validation error is incorrect", (boolean)error.getMessage().endsWith("does not conform to standard validation for field type."));
    }

    protected RemotableAttributeError assertDocumentSearchCriteriaValidation(StandardGenericXMLSearchableAttribute attribute, ExtensionDefinition ed, String attrkey, String attrvalue, boolean expectError) {
        DocumentSearchCriteria.Builder dscb = DocumentSearchCriteria.Builder.create();
        dscb.addDocumentAttributeValue(attrkey, attrvalue);
        List errors = attribute.validateDocumentAttributeCriteria(ed, dscb.build());
        if (expectError) {
            Assert.assertEquals((String)"Validation should return a single error message.", (long)1L, (long)errors.size());
            return (RemotableAttributeError)errors.get(0);
        }
        Assert.assertEquals((String)"Validation should not have returned an error.", (long)0L, (long)errors.size());
        return null;
    }

    @Test
    public void testRouteDocumentWithXStreamSearchableAttribute() throws Exception {
        String documentTypeName = "SearchDocType";
        String key = "givenname";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"SearchDocTypeXStream");
        WorkflowAttributeDefinition.Builder givennameXMLDef = WorkflowAttributeDefinition.Builder.create((String)"XMLXStreamSearchableAttribute");
        workflowDocument.setApplicationContent("<test></test>");
        givennameXMLDef.addPropertyDefinition("givenname", "jack");
        workflowDocument.addSearchableDefinition(givennameXMLDef.build());
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("rkirkend");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jack");
        DocumentSearchResults results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "fred");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "fakeproperty", "doesntexist");
        try {
            results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException wsee) {
            Assert.assertTrue((boolean)wsee.getMessage().contains("LookupException"));
        }
    }

    @Test
    public void testSearchableAttributeWithQuickfinder() throws Exception {
        String documentTypeName = "AttributeWithQuickfinderDocType";
        String key = "chart";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)documentTypeName);
        WorkflowAttributeDefinition.Builder chartDef = WorkflowAttributeDefinition.Builder.create((String)"SearchableAttributeWithQuickfinder");
        chartDef.addPropertyDefinition(key, "BL");
        document.addSearchableDefinition(chartDef.build());
        document.setTitle("Routin' with style");
        document.saveDocument("Savin' this document.");
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("rkirkend");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "BL");
        DocumentSearchResults results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        DocumentSearchResult result = (DocumentSearchResult)results.getSearchResults().get(0);
        String documentId = result.getDocument().getDocumentId();
        Assert.assertEquals((String)"Wrong document in search results.", (Object)document.getDocumentId(), (Object)documentId);
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        result = (DocumentSearchResult)results.getSearchResults().get(0);
        Assert.assertEquals((String)"Wrong document in search results.", (Object)document.getDocumentId(), (Object)result.getDocument().getDocumentId());
    }

    @Ignore
    @Test
    public void testSearchableAttributeWithHiddens() throws Exception {
        String docType = "AttributeWithHiddensDocType";
        DocumentType documentType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(docType);
        String attributeName = "SearchableAttributeWithHiddens";
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)docType);
        WorkflowAttributeDefinition.Builder chartDef = WorkflowAttributeDefinition.Builder.create((String)attributeName);
        chartDef.addPropertyDefinition("chart", "BL");
        chartDef.addPropertyDefinition("org", "ARSC");
        chartDef.addPropertyDefinition("dollar", "24");
        document.addSearchableDefinition(chartDef.build());
        document.setTitle("Routin' with style");
        document.saveDocument("Savin' this document.");
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("rkirkend");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(docType);
        this.addSearchableAttribute(criteria, "chart", "BL");
        DocumentSearchResults results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        DocumentSearchResult result = (DocumentSearchResult)results.getSearchResults().get(0);
        Assert.assertEquals((String)"Wrong document in search results.", (Object)document.getDocumentId(), (Object)result.getDocument().getDocumentId());
        DocumentAttribute documentAttribute = result.getSingleDocumentAttributeByName("chart");
        Assert.assertNull((String)"The chart column should not be in the result set!", (Object)documentAttribute);
        documentAttribute = result.getSingleDocumentAttributeByName("org");
        Assert.assertNotNull((String)"The org column should be in the result set", (Object)documentAttribute);
        Assert.assertEquals((String)"Wrong org code.", (Object)"ARSC", (Object)documentAttribute.getValue());
        documentAttribute = result.getSingleDocumentAttributeByName("dollar");
        Assert.assertNotNull((String)"The dollar column should be in the result set", (Object)documentAttribute);
        Assert.assertEquals((String)"Wrong dollar code.", (Object)"24", (Object)documentAttribute.getValue().toString());
    }

    @Test
    public void testSetApplicationContentXMLRoutedDocument() throws Exception {
        String documentTypeName = "SearchDocType";
        String key = "givenname";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)documentTypeName);
        workflowDocument.setApplicationContent("<documentContent><searchableContent><putWhateverWordsIwantInsideThisTag><givenname><value>jack</value></givenname></putWhateverWordsIwantInsideThisTag></searchableContent></documentContent>");
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        DocumentSearchService docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("rkirkend");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "jack");
        DocumentSearchResults results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, key, "fred");
        results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        this.addSearchableAttribute(criteria, "fakeproperty", "doesntexist");
        try {
            results = docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (RuntimeException wsee) {
            Assert.assertTrue((boolean)wsee.getMessage().contains("LookupException"));
        }
    }

    @Test
    public void testBlankValidValuesOnKeyValues() throws Exception {
        boolean[] shouldHaveBlank = new boolean[]{true, false};
        String[] attributesToTest = new String[]{"XMLSearchableAttributeWithBlank", "XMLSearchableAttributeWithoutBlank"};
        for (int i = 0; i < shouldHaveBlank.length; ++i) {
            ExtensionDefinition ed = StandardGenericXMLSearchableAttributeTest.createExtensionDefinition(attributesToTest[i]);
            List remotableAttributeFields = this.getAttribute(attributesToTest[i]).getSearchFields(ed, "BlankValidValuesDocType");
            List rowList = FieldUtils.convertRemotableAttributeFields((List)remotableAttributeFields);
            Assert.assertEquals((String)("The searching fields for " + attributesToTest[i] + " should have exactly one element"), (long)1L, (long)rowList.size());
            Assert.assertEquals((String)("Searching row for " + attributesToTest[i] + " should have exactly one field"), (long)1L, (long)((Row)rowList.get(0)).getFields().size());
            Field testField = (Field)((Row)rowList.get(0)).getFields().get(0);
            try {
                Assert.assertEquals((String)("The field for " + attributesToTest[i] + " does not have the expected getHasBlankValidValue() result"), (Object)shouldHaveBlank[i], (Object)testField.getHasBlankValidValue());
                continue;
            }
            catch (Exception ex) {
                Assert.fail((String)("An exception occurred while running getHasBlankValidValue() on " + attributesToTest[i] + ": " + ex.getMessage()));
            }
        }
    }
}

