/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import mocks.MockPostProcessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Element;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.edl.framework.workflow.EDocLitePostProcessor;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.engine.node.NodeType;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kew.framework.postprocessor.PostProcessor;
import org.kuali.rice.kew.postprocessor.DefaultPostProcessor;
import org.kuali.rice.kew.server.TestSplitNode;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.kew.xml.export.DocumentTypeXmlExporter;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class DocumentTypeTest
extends KEWTestCase {
    private static final Logger LOG = LogManager.getLogger(DocumentTypeTest.class);

    @Override
    protected void loadTestData() throws Exception {
        ConfigContext.getCurrentContextConfig().putProperty("test.doctype.workgroup", "TestWorkgroup");
        this.loadXmlFile("DoctypeConfig.xml");
    }

    @Test
    public void testDuplicateNodeName() throws Exception {
        try {
            this.loadXmlFile("DocTypeConfig_loadDupliateNodes.xml");
            Assert.fail((String)"loadXmlFile should have thrown routing exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDuplicateNodeNameInRoutePath() throws Exception {
        this.loadXmlFile("DocTypeConfig_duplicateNodes.xml");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"TestDoubleNodeDocumentType");
        document.setTitle("");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        Assert.assertTrue((String)"user2 should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user3"), (String)document.getDocumentId());
        Assert.assertTrue((String)"user3 should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
    }

    @Test
    public void testDocumentTypeParentChildLinking() throws Exception {
        super.loadXmlFile("ParentWithChildrenDocTypeConfiguration.xml");
        this.verifyDocumentTypeLinking();
        super.loadXmlFile("ParentWithChildrenDocTypeConfigurationUpdate1.xml");
        this.verifyDocumentTypeLinking();
        super.loadXmlFile("ParentWithChildrenDocTypeConfigurationUpdate2.xml");
        this.verifyDocumentTypeLinking();
        super.loadXmlFile("ParentWithChildrenDocTypeConfiguration.xml");
        this.verifyDocumentTypeLinking();
        super.loadXmlFile("ParentWithChildrenDocTypeConfigurationUpdate3.xml");
        this.verifyDocumentTypeLinking();
        String[] fileNames = new String[]{"ParentWithChildrenDocTypeConfiguration.xml", "DocTypeIngestTestConfig1.xml", "DocumentTypeAttributeFetchTest.xml", "ChildDocType1.xml", "ChildDocType2.xml", "ChildDocType3.xml", "ChildDocType4.xml"};
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        CyclicBarrier barrier = new CyclicBarrier(fileNames.length);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < fileNames.length; ++i) {
            Callback callback = new Callback();
            callbacks.add(callback);
            threads.add(new Thread(new LoadXml(fileNames[i], callback, barrier)));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join(120000L);
        }
        boolean atLeastOneFailure = false;
        for (Callback callback : callbacks) {
            if (callback.isXmlLoaded()) continue;
            atLeastOneFailure = true;
        }
        Assert.assertTrue((String)"At least one of the XML files should have failed the ingestion process", (boolean)atLeastOneFailure);
        this.verifyDocumentTypeLinking();
        super.loadXmlFile("ParentWithChildrenDocTypeConfiguration.xml");
        this.verifyDocumentTypeLinking();
    }

    @Test
    public void testNestedDuplicateNodeNameInRoutePath() throws Exception {
        TestSplitNode.setLeftBranch(true);
        TestSplitNode.setRightBranch(true);
        this.loadXmlFile("DocTypeConfig_nestedNodes.xml");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"TestNestedNodeDocumentType");
        document.setTitle("");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have an approve request; the first request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        Assert.assertTrue((String)"user2 should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user4"), (String)document.getDocumentId());
        Assert.assertTrue((String)"user4 should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user3"), (String)document.getDocumentId());
        Assert.assertTrue((String)"user3 should have an approve request; the first request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have an approve request; the second request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user3"), (String)document.getDocumentId());
        Assert.assertTrue((String)"user3 should have an approve request; the second request", (boolean)document.isApprovalRequested());
        document.approve("");
    }

    @Test
    public void testChangingDocumentTypeOnEnrouteDocument() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"DocumentType");
        document.setTitle("");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have an approve request", (boolean)document.isApprovalRequested());
        org.kuali.rice.kew.api.doctype.DocumentTypeService docTypeService = KewApiServiceLocator.getDocumentTypeService();
        Integer version1 = docTypeService.getDocumentTypeByName(document.getDocumentTypeName()).getDocumentTypeVersion();
        this.loadXmlFile("DoctypeSecondVersion.xml");
        Integer version2 = docTypeService.getDocumentTypeByName(document.getDocumentTypeName()).getDocumentTypeVersion();
        Assert.assertTrue((String)"Version2 should be larger than verison1", (version2 > version1 ? 1 : 0) != 0);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        Integer versionDocument = docTypeService.getDocumentTypeById(document.getDocument().getDocumentTypeId()).getDocumentTypeVersion();
        Assert.assertTrue((String)"user2 should have an approve request", (boolean)document.isApprovalRequested());
        Assert.assertEquals((String)"Document has the wrong document type version", (Object)version1, (Object)versionDocument);
    }

    @Test
    public void testFinalApproverRouting() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"FinalApproverDocumentType");
        document.setTitle("");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        try {
            document.approve("");
            Assert.fail((String)"document should have thrown routing exception");
        }
        catch (Exception e) {
            TestUtilities.getExceptionThreader().join();
            document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
            Assert.assertTrue((String)"Document should be in exception routing", (boolean)document.isException());
        }
    }

    @Test
    public void testEmptyRoutePath() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"EmptyRoutePathDocumentType");
        document.setTitle("");
        document.route("");
        Assert.assertTrue((String)"Document should be in final state", (boolean)document.isFinal());
    }

    @Test
    public void testMandatoryRoute() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"MandatoryRouteDocumentType");
        document.setTitle("");
        try {
            document.route("");
        }
        catch (Exception e) {
            TestUtilities.getExceptionThreader().join();
            document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)document.getDocumentId());
            Assert.assertTrue((String)"Document should be in exception routing", (boolean)document.isException());
        }
    }

    @Test
    public void testDocumentTypeXmlParser() throws Exception {
        ConfigContext.getCurrentContextConfig().putProperty("test.base.url", "http://someurl/path");
        DocumentType parsedDocument = KEWServiceLocator.getDocumentTypeService().findByName("DocumentType");
        Assert.assertEquals((String)"Wrong name", (Object)"DocumentType", (Object)parsedDocument.getName());
        Assert.assertEquals((String)"Wrong description", (Object)"TestDocumentType", (Object)parsedDocument.getDescription());
        Assert.assertEquals((String)"Wrong label", (Object)"TestDocumentType", (Object)parsedDocument.getLabel());
        Assert.assertEquals((String)"Wrong postprocessor", (Object)"org.kuali.rice.kew.postprocessor.DefaultPostProcessor", (Object)parsedDocument.getPostProcessorName());
        Assert.assertEquals((String)"Wrong su workgroup", (Object)"TestWorkgroup", (Object)parsedDocument.getSuperUserWorkgroup().getName());
        DocumentTypeXmlExporter exporter = new DocumentTypeXmlExporter();
        KewExportDataSet dataSet = new KewExportDataSet();
        dataSet.getDocumentTypes().add(parsedDocument);
        String regex = "(?s).*<defaultExceptionGroupName namespace=\"KR-WKFLW\">TestWorkgroup</defaultExceptionGroupName>.*";
        LOG.warn("Using regex: " + regex);
        Assert.assertTrue((boolean)XmlJotter.jotNode((Element)exporter.export(dataSet.createExportDataSet())).matches(regex));
        Assert.assertEquals((String)"Wrong doc handler url", (Object)"http://someurl/path/_blank", (Object)parsedDocument.getResolvedDocumentHandlerUrl());
        Assert.assertEquals((String)"Wrong unresolved doc handler url", (Object)"${test.base.url}/_blank", (Object)parsedDocument.getUnresolvedDocHandlerUrl());
        Assert.assertEquals((String)"Wrong help def url", (Object)"/_help", (Object)parsedDocument.getHelpDefinitionUrl());
        Assert.assertEquals((String)"Wrong unresolved help def url", (Object)"/_help", (Object)parsedDocument.getUnresolvedHelpDefinitionUrl());
        Assert.assertEquals((String)"Wrong blanketApprover workgroup", (Object)"TestWorkgroup", (Object)parsedDocument.getBlanketApproveWorkgroup().getName());
        Assert.assertEquals((String)"Wrong blanketApprove policy", null, (Object)parsedDocument.getBlanketApprovePolicy());
        Assert.assertEquals((String)"Wrong DEFAULT_APPROVE policy value", (Object)Boolean.FALSE, (Object)parsedDocument.getDefaultApprovePolicy().getPolicyValue());
        Assert.assertEquals((String)"Wrong LOOK_FUTURE", (Object)Boolean.TRUE, (Object)parsedDocument.getLookIntoFuturePolicy().getPolicyValue());
        List processes = parsedDocument.getProcesses();
        Assert.assertEquals((String)"Should only be 1 process", (long)1L, (long)processes.size());
        ProcessDefinitionBo process = (ProcessDefinitionBo)processes.get(0);
        List flattenedNodeList = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(process);
        Assert.assertEquals((String)"Should be 6 total route nodes", (long)6L, (long)flattenedNodeList.size());
        RouteNode adHocNode = process.getInitialRouteNode();
        Assert.assertEquals((String)"Wrong node name should be 'AdHoc'", (Object)"AdHoc", (Object)adHocNode.getRouteNodeName());
        Assert.assertTrue((String)"Wrong node type", (boolean)NodeType.START.isAssignableFrom(Class.forName(adHocNode.getNodeType())));
        Assert.assertEquals((String)"Default Exception workgroup not propagated", (Object)"TestWorkgroup", (Object)adHocNode.getExceptionWorkgroup().getName());
        RouteNode split = (RouteNode)adHocNode.getNextNodes().get(0);
        Assert.assertEquals((String)"Wrong node name", (Object)"Split", (Object)split.getRouteNodeName());
        Assert.assertTrue((String)"Wrong node type", (boolean)NodeType.SPLIT.isAssignableFrom(Class.forName(split.getNodeType())));
        Assert.assertEquals((String)"Default Exception workgroup not propagated", (Object)"TestWorkgroup", (Object)split.getExceptionWorkgroup().getName());
        Assert.assertTrue((split.getNextNodes().size() == 2 ? 1 : 0) != 0);
        boolean ruleTemplate1Found = false;
        boolean ruleTemplate2Found = false;
        for (RouteNode routeNode : split.getNextNodes()) {
            if (routeNode.getRouteNodeName().equals("RuleTemplate1")) {
                Assert.assertTrue((String)"Wrong node type", (boolean)NodeType.REQUESTS.isAssignableFrom(Class.forName(routeNode.getNodeType())));
                Assert.assertEquals((String)"Wrong branch name", (Object)"B1", (Object)routeNode.getBranch().getName());
                Assert.assertEquals((String)"Default Exception workgroup not propagated", (Object)"TestWorkgroup", (Object)routeNode.getExceptionWorkgroup().getName());
                ruleTemplate1Found = true;
            }
            if (!routeNode.getRouteNodeName().equals("RuleTemplate2")) continue;
            Assert.assertTrue((String)"Wrong node type", (boolean)NodeType.REQUESTS.isAssignableFrom(Class.forName(routeNode.getNodeType())));
            Assert.assertEquals((String)"Wrong branch name", (Object)"B2", (Object)routeNode.getBranch().getName());
            Assert.assertEquals((String)"Default Exception workgroup not propagated", (Object)"TestWorkgroup", (Object)routeNode.getExceptionWorkgroup().getName());
            ruleTemplate2Found = true;
            RouteNode join = (RouteNode)routeNode.getNextNodes().get(0);
            Assert.assertEquals((String)"Wrong node name", (Object)"Join", (Object)join.getRouteNodeName());
            Assert.assertTrue((String)"Wrong node type", (boolean)NodeType.JOIN.isAssignableFrom(Class.forName(join.getNodeType())));
            Assert.assertEquals((String)"Default Exception workgroup not propagated", (Object)"TestWorkgroup", (Object)join.getExceptionWorkgroup().getName());
            RouteNode ruleTemplate3 = (RouteNode)join.getNextNodes().get(0);
            Assert.assertEquals((String)"Wrong node name", (Object)"RuleTemplate3", (Object)ruleTemplate3.getRouteNodeName());
            Assert.assertTrue((String)"Wrong node type", (boolean)NodeType.REQUESTS.isAssignableFrom(Class.forName(ruleTemplate3.getNodeType())));
            Assert.assertEquals((String)"Default Exception workgroup not propagated", (Object)"TestWorkgroup", (Object)ruleTemplate3.getExceptionWorkgroup().getName());
        }
        Assert.assertTrue((boolean)ruleTemplate1Found);
        Assert.assertTrue((boolean)ruleTemplate2Found);
    }

    @Test
    public void testHierarchyUpload() throws Exception {
        super.loadXmlFile("ParentWithChildrenDocTypeConfiguration.xml");
        DocumentType parent = KEWServiceLocator.getDocumentTypeService().findByName("UGSDocumentType");
        boolean foundRemonstrance = false;
        boolean foundNewCourse = false;
        boolean foundDelete = false;
        for (DocumentType childDocType : parent.getChildrenDocTypes()) {
            Assert.assertTrue((String)"child documenttype should be current", (boolean)childDocType.getCurrentInd());
            if (childDocType.getName().equals("CourseRemonstranceProcess")) {
                foundRemonstrance = true;
                continue;
            }
            if (childDocType.getName().equals("NewCourseRequest")) {
                foundNewCourse = true;
                continue;
            }
            if (!childDocType.getName().equals("DeleteCourseRequest")) continue;
            foundDelete = true;
        }
        Assert.assertTrue((String)"Didn't find CourseRemonstraneProcess", (boolean)foundRemonstrance);
        Assert.assertTrue((String)"Didn't find NewCourseRequest", (boolean)foundNewCourse);
        Assert.assertTrue((String)"Didn't find DeleteCourseRequest", (boolean)foundDelete);
        super.loadXmlFile("ParentWithChildrenDocTypeConfiguration2.xml");
        parent = KEWServiceLocator.getDocumentTypeService().findByName("UGSDocumentType");
        foundRemonstrance = false;
        foundNewCourse = false;
        foundDelete = false;
        int i = 0;
        for (DocumentType childDocType : parent.getChildrenDocTypes()) {
            Assert.assertTrue((String)"child documenttype should be current", (boolean)childDocType.getCurrentInd());
            if (childDocType.getName().equals("CourseRemonstranceProcess")) {
                foundRemonstrance = true;
            } else if (childDocType.getName().equals("NewCourseRequest")) {
                foundNewCourse = true;
            } else if (childDocType.getName().equals("DeleteCourseRequest")) {
                foundDelete = true;
            }
            ++i;
        }
        Assert.assertTrue((String)"Didn't find CourseRemonstranceProcess", (boolean)foundRemonstrance);
        Assert.assertTrue((String)"Didn't find NewCourseRequest", (boolean)foundNewCourse);
        Assert.assertTrue((String)"Didn't find DeleteCourseRequest", (boolean)foundDelete);
    }

    @Test
    public void testHierarchyUpload2() throws Exception {
        super.loadXmlFile("DocTypesWithoutParent.xml");
        DocumentType courseRemonstrance1 = KEWServiceLocator.getDocumentTypeService().findByName("CourseRemonstranceProcess");
        DocumentType newCourseRequest1 = KEWServiceLocator.getDocumentTypeService().findByName("NewCourseRequest");
        DocumentType deleteCourse1 = KEWServiceLocator.getDocumentTypeService().findByName("DeleteCourseRequest");
        super.loadXmlFile("ParentWithChildrenDocTypeConfiguration.xml");
        DocumentType courseRemonstrance2 = null;
        DocumentType newCourseRequest2 = null;
        DocumentType deleteCourse2 = null;
        DocumentType ugsDocumentType = KEWServiceLocator.getDocumentTypeService().findByName("UGSDocumentType");
        for (DocumentType childDocType : ugsDocumentType.getChildrenDocTypes()) {
            if (childDocType.getName().equals("CourseRemonstranceProcess")) {
                courseRemonstrance2 = childDocType;
                continue;
            }
            if (childDocType.getName().equals("NewCourseRequest")) {
                newCourseRequest2 = childDocType;
                continue;
            }
            if (!childDocType.getName().equals("DeleteCourseRequest")) continue;
            deleteCourse2 = childDocType;
        }
        Assert.assertNotNull(courseRemonstrance2);
        Assert.assertNotNull(newCourseRequest2);
        Assert.assertNotNull(deleteCourse2);
        Assert.assertTrue((String)"Version didn't get incremented", (courseRemonstrance1.getVersion() < courseRemonstrance2.getVersion() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Version didn't increment", (newCourseRequest1.getVersion() < newCourseRequest2.getVersion() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Version didn't increment", (deleteCourse1.getVersion() < deleteCourse2.getVersion() ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentTypeIngestion() throws Exception {
        super.loadXmlFile("DocTypeIngestTestConfig1.xml");
        super.loadXmlFile("DocTypeIngestTestConfig2.xml");
        DocumentType secondIngestDoc = KEWServiceLocator.getDocumentTypeService().findByName("IngestTestDocumentType");
        Assert.assertNotNull((String)"Second ingested document has empty Previous Version ID after first ingest", (Object)secondIngestDoc.getPreviousVersionId());
        DocumentType firstIngestDoc = KEWServiceLocator.getDocumentTypeService().findById(secondIngestDoc.getPreviousVersionId());
        Assert.assertEquals((String)"First ingested document is still set to Current after first ingest", (Object)Boolean.FALSE, (Object)firstIngestDoc.getCurrentInd());
        Assert.assertEquals((String)"Second ingested document is not set to Current after first ingest", (Object)Boolean.TRUE, (Object)secondIngestDoc.getCurrentInd());
        super.loadXmlFile("DocTypeIngestTestConfig3.xml");
        firstIngestDoc = null;
        secondIngestDoc = null;
        DocumentType thirdIngestDoc = KEWServiceLocator.getDocumentTypeService().findByName("IngestTestDocumentType");
        Assert.assertNotNull((String)"Third ingested document has empty Previous Version ID after second ingest", (Object)thirdIngestDoc.getPreviousVersionId());
        secondIngestDoc = KEWServiceLocator.getDocumentTypeService().findById(thirdIngestDoc.getPreviousVersionId());
        Assert.assertNotNull((String)"Second ingested document has empty Previous Version ID after second ingest", (Object)secondIngestDoc.getPreviousVersionId());
        firstIngestDoc = KEWServiceLocator.getDocumentTypeService().findById(secondIngestDoc.getPreviousVersionId());
        Assert.assertEquals((String)"First ingested document is set to Current after second ingest", (Object)Boolean.FALSE, (Object)firstIngestDoc.getCurrentInd());
        Assert.assertEquals((String)"Second ingested document is set to Current after second ingest", (Object)Boolean.FALSE, (Object)secondIngestDoc.getCurrentInd());
        Assert.assertEquals((String)"Third ingested document is not set to Inactive after second ingest", (Object)Boolean.FALSE, (Object)thirdIngestDoc.getActive());
        Assert.assertEquals((String)"Third ingested document is not set to Current after second ingest", (Object)Boolean.TRUE, (Object)thirdIngestDoc.getCurrentInd());
        super.loadXmlFile("DocTypeIngestTestConfig4.xml");
        firstIngestDoc = null;
        secondIngestDoc = null;
        thirdIngestDoc = null;
        DocumentType fourthIngestDoc = KEWServiceLocator.getDocumentTypeService().findByName("IngestTestDocumentType");
        Assert.assertNotNull((String)"Fourth ingested document has empty Previous Version ID after third ingest", (Object)fourthIngestDoc.getPreviousVersionId());
        thirdIngestDoc = KEWServiceLocator.getDocumentTypeService().findById(fourthIngestDoc.getPreviousVersionId());
        Assert.assertNotNull((String)"Third ingested document has empty Previous Version ID after third ingest", (Object)thirdIngestDoc.getPreviousVersionId());
        secondIngestDoc = KEWServiceLocator.getDocumentTypeService().findById(thirdIngestDoc.getPreviousVersionId());
        Assert.assertNotNull((String)"Second ingested document has empty Previous Version ID after third ingest", (Object)secondIngestDoc.getPreviousVersionId());
        firstIngestDoc = KEWServiceLocator.getDocumentTypeService().findById(secondIngestDoc.getPreviousVersionId());
        Assert.assertEquals((String)"First ingested document is set to Current after third ingest", (Object)Boolean.FALSE, (Object)firstIngestDoc.getCurrentInd());
        Assert.assertEquals((String)"Second ingested document is set to Current after third ingest", (Object)Boolean.FALSE, (Object)secondIngestDoc.getCurrentInd());
        Assert.assertEquals((String)"Third ingested document is set to Current after third ingest", (Object)Boolean.FALSE, (Object)thirdIngestDoc.getCurrentInd());
        Assert.assertEquals((String)"Fourth ingested document is not set to Active after third ingest", (Object)Boolean.TRUE, (Object)fourthIngestDoc.getActive());
        Assert.assertEquals((String)"Fourth ingested document is not set to Current after third ingest", (Object)Boolean.TRUE, (Object)fourthIngestDoc.getCurrentInd());
    }

    @Test
    public void testSameFileChildParentIngestion() throws Exception {
        this.loadXmlFile("ChildParentTestConfig1.xml");
        this.verifyDocumentTypeLinking();
        this.loadXmlFile("ChildParentTestConfig2.xml");
        this.verifyDocumentTypeLinking();
    }

    @Test
    public void testPostProcessor() throws Exception {
        this.loadXmlFile("DoctypePostProcessorConfig.xml");
        DocumentType ppTestParent1 = KEWServiceLocator.getDocumentTypeService().findByName("PPTestParent1");
        DocumentType ppTestParent2 = KEWServiceLocator.getDocumentTypeService().findByName("PPTestParent2");
        DocumentType ppTestChild1 = KEWServiceLocator.getDocumentTypeService().findByName("PPTestChild1");
        DocumentType ppTestChild2 = KEWServiceLocator.getDocumentTypeService().findByName("PPTestChild2");
        DocumentType ppTestChild3 = KEWServiceLocator.getDocumentTypeService().findByName("PPTestChild3");
        Assert.assertEquals((String)"Incorrect PostProcessor", MockPostProcessor.class, ppTestParent1.getPostProcessor().getClass());
        Assert.assertEquals((String)"Incorrect PostProcessor", DefaultPostProcessor.class, ppTestParent2.getPostProcessor().getClass());
        Assert.assertEquals((String)"Incorrect PostProcessor", MockPostProcessor.class, ppTestChild1.getPostProcessor().getClass());
        PostProcessor testChild2PP = ppTestChild2.getPostProcessor();
        Assert.assertEquals((String)"Incorrect PostProcessorRemote", EDocLitePostProcessor.class, testChild2PP.getClass());
        Assert.assertEquals((String)"Incorrect PostProcessor", DefaultPostProcessor.class, ppTestChild3.getPostProcessor().getClass());
    }

    @Test
    public void testUpdateOfDocTypeFields() throws Exception {
        String[][] expectedValues = new String[][]{{"TestWithMostParams1", "TestParent01", "A test of doc type parameters.", "TestWithMostParams1", "mocks.MockPostProcessor", "KR-WKFLW:TestWorkgroup", null, "any", "KR-WKFLW:TestWorkgroup", "KR-WKFLW:TestWorkgroup", "_blank", "_blank", "_blank", "_blank", "_blank", "TestCl1", "false", "a.doc.type.authorizer"}, {"TestWithMostParams1", "AnotherParent", "Another test of most parameters.", "AntoherTestWithMostParams", "org.kuali.rice.kew.postprocessor.DefaultPostProcessor", "KR-WKFLW:WorkflowAdmin", "KR-WKFLW:WorkflowAdmin", null, "KR-WKFLW:WorkflowAdmin", "KR-WKFLW:WorkflowAdmin", "_nothing", "_nothing", "_nothing", "_nothing", "_nothing", "KEW", "true", "a.parent.authorizer"}};
        for (int i = 0; i < expectedValues.length; ++i) {
            String fileToLoad = "DocTypeWithMostParams" + (i + 1) + ".xml";
            this.loadXmlFile(fileToLoad);
            DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName("TestWithMostParams1");
            Group baWorkgroup = docType.getBlanketApproveWorkgroup();
            Group rpWorkgroup = docType.getReportingWorkgroup();
            Group deWorkgroup = this.getValidDefaultExceptionWorkgroup(docType);
            String[] actualValues = new String[]{docType.getName(), docType.getParentDocType().getName(), docType.getDescription(), docType.getLabel(), docType.getPostProcessorName(), this.constructGroupNameWithNamespace(docType.getSuperUserWorkgroupNoInheritence()), this.constructGroupNameWithNamespace(baWorkgroup), docType.getBlanketApprovePolicy(), this.constructGroupNameWithNamespace(rpWorkgroup), this.constructGroupNameWithNamespace(deWorkgroup), docType.getUnresolvedDocHandlerUrl(), docType.getUnresolvedHelpDefinitionUrl(), docType.getUnresolvedDocSearchHelpUrl(), docType.getNotificationFromAddress(), docType.getCustomEmailStylesheet(), docType.getApplicationId(), docType.getActive().toString(), docType.getAuthorizer()};
            for (int j = 0; j < expectedValues[i].length; ++j) {
                Assert.assertEquals((String)("The document does not have the expected parameter value. (i=" + i + ",j=" + j + ")"), (Object)expectedValues[i][j], (Object)actualValues[j]);
            }
        }
    }

    private Group getValidDefaultExceptionWorkgroup(DocumentType documentType) {
        List flattenedNodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(documentType, false);
        Assert.assertTrue((String)("Document Type '" + documentType.getName() + "' should have a default exception workgroup."), (boolean)this.hasDefaultExceptionWorkgroup(flattenedNodes));
        return ((RouteNode)flattenedNodes.get(0)).getExceptionWorkgroup();
    }

    private boolean hasDefaultExceptionWorkgroup(List flattenedNodes) {
        boolean hasDefaultExceptionWorkgroup = true;
        String exceptionWorkgroupName = null;
        for (RouteNode node : flattenedNodes) {
            if (exceptionWorkgroupName == null) {
                exceptionWorkgroupName = node.getExceptionWorkgroupName();
            }
            if (exceptionWorkgroupName != null && exceptionWorkgroupName.equals(node.getExceptionWorkgroupName())) continue;
            hasDefaultExceptionWorkgroup = false;
            break;
        }
        return hasDefaultExceptionWorkgroup;
    }

    private String constructGroupNameWithNamespace(Group group) {
        if (group == null) {
            return null;
        }
        return group.getNamespaceCode() + ":" + group.getName();
    }

    protected void verifyDocumentTypeLinking() throws Exception {
        DocumentTypeService service = KEWServiceLocator.getDocumentTypeService();
        List rootDocs = service.findAllCurrentRootDocuments();
        int numRoots = rootDocs.size();
        List documentTypes = service.findAllCurrent();
        ArrayList<DocumentType> leafs = new ArrayList<DocumentType>();
        for (DocumentType documentType : documentTypes) {
            List children;
            if (KRADUtils.isNotNull((Object)documentType.getParentDocType())) {
                Assert.assertEquals((String)("Parent of document type '" + documentType.getName() + "' should be Current"), (Object)Boolean.TRUE, (Object)documentType.getParentDocType().getCurrentInd());
            }
            if ((children = service.getChildDocumentTypes(documentType.getDocumentTypeId())).isEmpty()) {
                leafs.add(documentType);
                continue;
            }
            for (DocumentType childDocType : children) {
                Assert.assertEquals((String)"Any child document type should be Current", (Object)Boolean.TRUE, (Object)childDocType.getCurrentInd());
            }
        }
        HashSet<String> rootDocIds = new HashSet<String>();
        for (DocumentType leaf : leafs) {
            this.verifyHierarchy(leaf, rootDocIds);
        }
        Assert.assertEquals((String)"Should have the same number of roots", (long)numRoots, (long)rootDocIds.size());
    }

    protected void verifyHierarchy(DocumentType docType, Set<String> rootDocIds) {
        Assert.assertTrue((String)("DocumentType " + docType.getName() + " should be current."), (boolean)docType.getCurrentInd());
        if (docType.getParentDocType() == null) {
            rootDocIds.add(docType.getDocumentTypeId());
        } else {
            this.verifyHierarchy(docType.getParentDocType(), rootDocIds);
        }
    }

    private class Callback {
        private String xmlFile;
        private Throwable t;

        private Callback() {
        }

        public void record(String xmlFile, Throwable t) {
            this.xmlFile = xmlFile;
            this.t = t;
        }

        public boolean isXmlLoaded() {
            if (this.t != null) {
                this.t.printStackTrace();
                LOG.info("The XML file " + this.xmlFile + " failed to load, but this was expected.");
                return false;
            }
            return true;
        }
    }

    private class LoadXml
    implements Runnable {
        private final String xmlFile;
        private final Callback callback;
        private final CyclicBarrier barrier;

        LoadXml(String xmlFile, Callback callback, CyclicBarrier barrier) {
            this.xmlFile = xmlFile;
            this.callback = callback;
            this.barrier = barrier;
        }

        @Override
        public void run() {
            DocumentTypeTest.this.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    try {
                        LoadXml.this.barrier.await(120L, TimeUnit.SECONDS);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        DocumentTypeTest.this.loadXmlFile(LoadXml.this.xmlFile);
                    }
                    catch (Throwable t) {
                        LoadXml.this.callback.record(LoadXml.this.xmlFile, t);
                    }
                }
            });
        }
    }
}

